/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.query.BaseResult;
import io.requery.query.Expression;
import io.requery.query.Tuple;
import io.requery.sql.ResultReader;
import io.requery.sql.ResultSetIterator;
import io.requery.sql.RuntimeConfiguration;
import io.requery.sql.TupleResultReader;
import io.requery.util.CloseableIterator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

class GeneratedKeyResult
extends BaseResult<Tuple> {
    private final Connection connection;
    private final ResultReader<Tuple> reader;
    private final ResultSet results;
    private final Set<? extends Expression<?>> selection;

    GeneratedKeyResult(RuntimeConfiguration configuration, Set<? extends Expression<?>> selection, Connection connection, ResultSet results, Integer maxSize) {
        super(maxSize);
        this.results = results;
        this.connection = connection;
        this.selection = selection;
        this.reader = new TupleResultReader(configuration);
    }

    @Override
    public CloseableIterator<Tuple> createIterator(int skip, int take) {
        return new ResultSetIterator<Tuple>(this.reader, this.results, this.selection, true, true);
    }

    @Override
    public void close() {
        super.close();
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

