/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class StatementExecutionException
extends PersistenceException {
    private static boolean useSuppressed;
    private final String sql;

    static StatementExecutionException closing(Statement statement, Throwable cause, String sql) {
        StatementExecutionException e = new StatementExecutionException(cause, sql);
        if (statement != null) {
            Connection connection;
            block3: {
                connection = null;
                try {
                    connection = statement.getConnection();
                }
                catch (SQLException suppressed) {
                    if (!useSuppressed) break block3;
                    e.addSuppressed(suppressed);
                }
            }
            e.closeSuppressed(statement);
            e.closeSuppressed(connection);
        }
        return e;
    }

    StatementExecutionException(Throwable throwable, String sql) {
        super("Exception executing statement: " + sql, throwable);
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    private void closeSuppressed(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception suppressed) {
                if (useSuppressed) {
                    this.addSuppressed(suppressed);
                }
                suppressed.printStackTrace();
            }
        }
    }

    static {
        String vendor = System.getProperty("java.vendor");
        useSuppressed = !vendor.contains("Android");
    }
}

