/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.gen;

import io.requery.meta.Attribute;
import io.requery.meta.QueryAttribute;
import io.requery.query.Aliasable;
import io.requery.query.Condition;
import io.requery.query.Expression;
import io.requery.query.ExpressionType;
import io.requery.query.NamedExpression;
import io.requery.query.NullOperand;
import io.requery.query.Operator;
import io.requery.query.RowExpression;
import io.requery.query.element.JoinConditionElement;
import io.requery.query.element.JoinOnElement;
import io.requery.query.element.LogicalElement;
import io.requery.query.element.LogicalOperator;
import io.requery.query.element.QueryElement;
import io.requery.query.element.QueryWrapper;
import io.requery.query.function.Case;
import io.requery.query.function.Function;
import io.requery.sql.BoundParameters;
import io.requery.sql.Keyword;
import io.requery.sql.QueryBuilder;
import io.requery.sql.RuntimeConfiguration;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.Output;
import io.requery.util.function.Supplier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultOutput
implements Output {
    private final RuntimeConfiguration configuration;
    private final QueryElement<?> query;
    private final Aliases inheritedAliases;
    private final boolean parameterize;
    private final BoundParameters parameters;
    private final Generator<QueryElement<?>> statementGenerator;
    private final QueryBuilder qb;
    private Aliases aliases;
    private boolean autoAlias;

    public DefaultOutput(RuntimeConfiguration configuration, QueryElement<?> query) {
        this(configuration, query, new QueryBuilder(configuration.getQueryBuilderOptions()), null, true);
    }

    public DefaultOutput(RuntimeConfiguration configuration, QueryElement<?> query, QueryBuilder qb, Aliases inherited, boolean parameterize) {
        this.configuration = configuration;
        this.query = query;
        this.qb = qb;
        this.inheritedAliases = inherited;
        this.parameterize = parameterize;
        this.statementGenerator = configuration.getStatementGenerator();
        this.parameters = parameterize ? new BoundParameters() : null;
    }

    @Override
    public QueryBuilder builder() {
        return this.qb;
    }

    @Override
    public BoundParameters parameters() {
        return this.parameters;
    }

    public String toSql() {
        this.aliases = this.inheritedAliases == null ? new Aliases() : this.inheritedAliases;
        Set<Expression<?>> from = this.query.fromExpressions();
        Set<JoinOnElement<?>> joins = this.query.joinElements();
        this.autoAlias = from.size() > 1 || joins != null && joins.size() > 0;
        this.statementGenerator.write(this, this.query);
        return this.qb.toString();
    }

    @Override
    public void appendTables() {
        Set<Expression<?>> from = this.query.fromExpressions();
        this.qb.commaSeparated(from, new QueryBuilder.Appender<Expression<?>>(){

            @Override
            public void append(QueryBuilder qb, Expression<?> value) {
                if (value instanceof QueryWrapper) {
                    DefaultOutput.this.appendFromExpression(value);
                } else if (DefaultOutput.this.autoAlias) {
                    DefaultOutput.this.aliases.append(qb, value.getName());
                } else {
                    qb.tableName(value.getName());
                }
            }
        });
        this.appendJoins();
    }

    private void appendJoins() {
        if (this.query.joinElements() != null && !this.query.joinElements().isEmpty()) {
            for (JoinOnElement<?> join : this.query.joinElements()) {
                this.appendJoin(join);
            }
        }
    }

    private void appendFromExpression(Expression expression) {
        if (expression.getExpressionType() == ExpressionType.QUERY) {
            QueryWrapper wrapper = (QueryWrapper)((Object)expression);
            String alias = wrapper.unwrapQuery().getAlias();
            if (alias == null) {
                throw new IllegalStateException("query in 'from' expression must have an alias");
            }
            this.qb.openParenthesis();
            this.appendQuery(wrapper);
            this.qb.closeParenthesis().space();
            this.qb.append(alias).space();
        } else {
            this.qb.append(expression.getName());
        }
    }

    private static Expression<?> unwrapExpression(Expression<?> expression) {
        if (expression.getInnerExpression() != null) {
            return expression.getInnerExpression();
        }
        return expression;
    }

    private String findAlias(Expression<?> expression) {
        String alias = null;
        if (expression instanceof Aliasable) {
            Aliasable aliasable = (Aliasable)((Object)expression);
            alias = aliasable.getAlias();
        }
        return alias;
    }

    @Override
    public void appendColumn(Expression<?> expression) {
        String alias = this.findAlias(expression);
        if (expression instanceof Function) {
            this.appendFunction((Function)expression);
        } else if (this.autoAlias && alias == null && expression.getExpressionType() == ExpressionType.ATTRIBUTE) {
            this.aliases.prefix(this.qb, expression);
        } else if (alias == null || alias.length() == 0) {
            this.appendColumnExpression(expression);
        } else {
            this.qb.append(alias).space();
        }
    }

    @Override
    public void appendColumnForSelect(Expression<?> expression) {
        String alias = this.findAlias(expression);
        if (expression instanceof Function) {
            this.appendFunction((Function)expression);
        } else if (this.autoAlias) {
            if (expression instanceof Attribute) {
                this.aliases.prefix(this.qb, (Attribute)((Object)expression));
            } else {
                this.aliases.prefix(this.qb, expression);
            }
        } else {
            this.appendColumnExpression(expression);
        }
        if (alias != null && alias.length() > 0) {
            this.qb.keyword(Keyword.AS);
            this.qb.append(alias).space();
        }
    }

    private void appendColumnExpression(Expression expression) {
        switch (expression.getExpressionType()) {
            case ATTRIBUTE: {
                Attribute attribute = (Attribute)((Object)expression);
                this.qb.attribute(attribute);
                break;
            }
            default: {
                if (expression instanceof RowExpression) {
                    RowExpression collection = (RowExpression)expression;
                    this.qb.openParenthesis();
                    this.qb.commaSeparated(collection.getExpressions(), new QueryBuilder.Appender<Expression<?>>(){

                        @Override
                        public void append(QueryBuilder qb, Expression<?> value) {
                            DefaultOutput.this.appendColumnForSelect(value);
                        }
                    });
                    this.qb.closeParenthesis().space();
                    break;
                }
                this.qb.append(expression.getName()).space();
            }
        }
    }

    private void appendFunction(Function function2) {
        if (function2 instanceof Case) {
            this.appendCaseFunction((Case)function2);
        } else {
            Function.Name name = this.configuration.getMapping().mapFunctionName(function2);
            this.qb.append(name.getName());
            if (function2.arguments().length == 0 && name.isConstant()) {
                return;
            }
            this.qb.openParenthesis();
            int index = 0;
            for (Object arg : function2.arguments()) {
                if (index > 0) {
                    this.qb.comma();
                }
                if (arg instanceof Expression) {
                    Expression expression = (Expression)arg;
                    switch (expression.getExpressionType()) {
                        case ATTRIBUTE: {
                            this.appendColumnForSelect(expression);
                            break;
                        }
                        case FUNCTION: {
                            Function inner = (Function)arg;
                            this.appendFunction(inner);
                            break;
                        }
                        default: {
                            this.qb.append(expression.getName());
                            break;
                        }
                    }
                } else if (arg instanceof Class) {
                    this.qb.append("*");
                } else {
                    this.appendConditionValue(function2.expressionForArgument(index), arg);
                }
                ++index;
            }
            this.qb.closeParenthesis().space();
        }
    }

    private void appendCaseFunction(Case<?> function2) {
        this.qb.keyword(Keyword.CASE);
        for (Case.CaseCondition<?, ?> condition : function2.conditions()) {
            this.qb.keyword(Keyword.WHEN);
            this.appendOperation(condition.condition(), 0);
            this.qb.keyword(Keyword.THEN);
            if (condition.thenValue() instanceof CharSequence || condition.thenValue() instanceof Number) {
                this.appendConditionValue(function2, condition.thenValue(), false);
                continue;
            }
            this.appendConditionValue(function2, condition.thenValue());
        }
        if (function2.elseValue() != null) {
            this.qb.keyword(Keyword.ELSE);
            this.appendConditionValue(function2, function2.elseValue());
        }
        this.qb.keyword(Keyword.END);
    }

    private void appendJoin(JoinOnElement<?> join) {
        switch (join.joinType()) {
            case INNER: {
                this.qb.keyword(Keyword.INNER, Keyword.JOIN);
                break;
            }
            case LEFT: {
                this.qb.keyword(Keyword.LEFT, Keyword.JOIN);
                break;
            }
            case RIGHT: {
                this.qb.keyword(Keyword.RIGHT, Keyword.JOIN);
            }
        }
        if (join.tableName() != null) {
            if (this.autoAlias) {
                this.aliases.remove(join.tableName());
                this.aliases.append(this.qb, join.tableName());
            } else {
                this.qb.tableName(join.tableName());
            }
        } else if (join.subQuery() != null) {
            this.qb.openParenthesis();
            this.appendQuery((QueryWrapper)((Object)join.subQuery()));
            this.qb.closeParenthesis().space();
            if (join.subQuery().getAlias() != null) {
                this.qb.append(join.subQuery().getAlias()).space();
            }
        }
        this.qb.keyword(Keyword.ON);
        for (JoinConditionElement<?> where : join.conditions()) {
            this.appendConditional(where);
        }
    }

    private void appendOperation(Condition condition, int depth) {
        Object leftOperand = condition.getLeftOperand();
        if (leftOperand instanceof Expression) {
            final Expression expression = (Expression)condition.getLeftOperand();
            this.appendColumn(expression);
            Object value = condition.getRightOperand();
            this.appendOperator(condition.getOperator());
            if (value instanceof Collection && (condition.getOperator() == Operator.IN || condition.getOperator() == Operator.NOT_IN)) {
                Collection collection = (Collection)value;
                this.qb.openParenthesis();
                this.qb.commaSeparated(collection, new QueryBuilder.Appender(){

                    public void append(QueryBuilder qb, Object value) {
                        DefaultOutput.this.appendConditionValue(expression, value);
                    }
                });
                this.qb.closeParenthesis();
            } else if (value instanceof Object[]) {
                Object[] values2 = (Object[])value;
                if (condition.getOperator() == Operator.BETWEEN) {
                    Object begin = values2[0];
                    Object end = values2[1];
                    this.appendConditionValue(expression, begin);
                    this.qb.keyword(Keyword.AND);
                    this.appendConditionValue(expression, end);
                } else {
                    for (Object o : values2) {
                        this.appendConditionValue(expression, o);
                    }
                }
            } else if (value instanceof QueryWrapper) {
                QueryWrapper wrapper = (QueryWrapper)value;
                this.qb.openParenthesis();
                this.appendQuery(wrapper);
                this.qb.closeParenthesis().space();
            } else if (value instanceof Condition) {
                this.appendOperation((Condition)value, depth + 1);
            } else if (value != null) {
                this.appendConditionValue(expression, value);
            }
        } else if (leftOperand instanceof Condition) {
            if (condition.getRightOperand() instanceof NullOperand) {
                this.appendOperator(condition.getOperator());
                if (depth > 0) {
                    this.qb.openParenthesis();
                }
                this.appendOperation((Condition)leftOperand, depth + 1);
                if (depth > 0) {
                    this.qb.closeParenthesis().space();
                }
            } else {
                if (depth > 0) {
                    this.qb.openParenthesis();
                }
                this.appendOperation((Condition)leftOperand, depth + 1);
                this.appendOperator(condition.getOperator());
                Object value = condition.getRightOperand();
                if (!(value instanceof Condition)) {
                    throw new IllegalStateException();
                }
                this.appendOperation((Condition)value, depth + 1);
                if (depth > 0) {
                    this.qb.closeParenthesis().space();
                }
            }
        } else {
            throw new IllegalStateException("unknown start expression type " + leftOperand);
        }
    }

    @Override
    public void appendConditionValue(Expression expression, Object value) {
        this.appendConditionValue(expression, value, true);
    }

    private void appendConditionValue(Expression expression, Object value, boolean parameterize) {
        if (value instanceof QueryAttribute) {
            this.appendColumn((Expression)value);
        } else if (value instanceof Supplier && ((Supplier)value).get() instanceof QueryAttribute) {
            this.appendColumn((Expression)((Supplier)value).get());
        } else if (value instanceof NamedExpression) {
            NamedExpression namedExpression = (NamedExpression)value;
            this.qb.append(namedExpression.getName());
        } else if (value instanceof Function) {
            this.appendFunction((Function)value);
        } else if (value instanceof Collection && expression.getExpressionType() == ExpressionType.ROW) {
            this.qb.openParenthesis();
            this.qb.commaSeparated((Collection)value);
            this.qb.closeParenthesis();
        } else if (parameterize) {
            if (this.parameters != null) {
                this.parameters.add(expression, value);
            }
            this.qb.append("?").space();
        } else if (value instanceof CharSequence) {
            this.qb.appendQuoted(value.toString()).space();
        } else {
            this.qb.append(value).space();
        }
    }

    @Override
    public void appendConditional(LogicalElement element) {
        Condition<?, ?> condition;
        boolean nested;
        LogicalOperator op = element.getOperator();
        if (op != null) {
            switch (op) {
                case AND: {
                    this.qb.keyword(Keyword.AND);
                    break;
                }
                case OR: {
                    this.qb.keyword(Keyword.OR);
                }
            }
        }
        if (nested = (condition = element.getCondition()).getRightOperand() instanceof Condition) {
            this.qb.openParenthesis();
        }
        this.appendOperation(condition, 0);
        if (nested) {
            this.qb.closeParenthesis().space();
        }
    }

    @Override
    public void appendOperator(Operator operator) {
        switch (operator) {
            case EQUAL: {
                this.qb.value("=");
                break;
            }
            case NOT_EQUAL: {
                this.qb.value("!=");
                break;
            }
            case LESS_THAN: {
                this.qb.value("<");
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                this.qb.value("<=");
                break;
            }
            case GREATER_THAN: {
                this.qb.value(">");
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                this.qb.value(">=");
                break;
            }
            case IN: {
                this.qb.keyword(Keyword.IN);
                break;
            }
            case NOT_IN: {
                this.qb.keyword(Keyword.NOT, Keyword.IN);
                break;
            }
            case LIKE: {
                this.qb.keyword(Keyword.LIKE);
                break;
            }
            case NOT_LIKE: {
                this.qb.keyword(Keyword.NOT, Keyword.LIKE);
                break;
            }
            case BETWEEN: {
                this.qb.keyword(Keyword.BETWEEN);
                break;
            }
            case IS_NULL: {
                this.qb.keyword(Keyword.IS, Keyword.NULL);
                break;
            }
            case NOT_NULL: {
                this.qb.keyword(Keyword.IS, Keyword.NOT, Keyword.NULL);
                break;
            }
            case AND: {
                this.qb.keyword(Keyword.AND);
                break;
            }
            case OR: {
                this.qb.keyword(Keyword.OR);
                break;
            }
            case NOT: {
                this.qb.keyword(Keyword.NOT);
            }
        }
    }

    @Override
    public void appendQuery(QueryWrapper<?> wrapper) {
        QueryElement<?> query = wrapper.unwrapQuery();
        DefaultOutput generator = new DefaultOutput(this.configuration, query, this.qb, this.aliases, this.parameterize);
        generator.toSql();
        if (this.parameters != null) {
            this.parameters.addAll(generator.parameters());
        }
    }

    private static class Aliases {
        private final Map<String, String> aliases = new HashMap<String, String>();
        private final Set<String> appended = new HashSet<String>();
        private char index = (char)97;

        private Aliases() {
        }

        private String alias(String key) {
            String alias = this.aliases.get(key);
            if (alias == null) {
                if (this.index > 'z') {
                    throw new IllegalStateException();
                }
                alias = String.valueOf(this.index);
                this.aliases.put(key, alias);
                this.index = (char)(this.index + '\u0001');
            }
            return alias;
        }

        void remove(String table) {
            String key = table.replaceAll("\"", "");
            if (this.appended.contains(key)) {
                this.aliases.remove(key);
            }
        }

        void append(QueryBuilder qb, String table) {
            String key = table.replaceAll("\"", "");
            String alias = this.alias(key);
            qb.tableName(table).value(alias);
            this.appended.add(key);
        }

        void prefix(QueryBuilder qb, Attribute attribute) {
            String key = attribute.getDeclaringType().getName();
            String alias = this.alias(key);
            qb.aliasAttribute(alias, attribute);
        }

        void prefix(QueryBuilder qb, Expression expression) {
            Expression inner = DefaultOutput.unwrapExpression(expression);
            if (inner.getExpressionType() == ExpressionType.ATTRIBUTE) {
                Attribute attribute = (Attribute)((Object)inner);
                if (expression.getExpressionType() == ExpressionType.ALIAS) {
                    String key = attribute.getDeclaringType().getName();
                    qb.append(this.alias(key) + "." + expression.getName()).space();
                } else {
                    this.prefix(qb, attribute);
                }
            } else {
                String key = inner.getName();
                String alias = this.alias(key);
                qb.append(alias + "." + expression.getName()).space();
            }
        }
    }
}

