/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.setup;

import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.config.ConfigStore;
import eu.pretix.libpretixsync.setup.RemoteEvent;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Hours;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J0\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eJ2\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00192\b\b\u0002\u0010 \u001a\u00020\n2\b\b\u0002\u0010!\u001a\u00020\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\f\u001a&\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u000fR\u00020\u00060\rj\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u000fR\u00020\u0006`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Leu/pretix/libpretixsync/setup/EventManager;", "", "store", "Lio/requery/BlockingEntityStore;", "Lio/requery/Persistable;", "api", "Leu/pretix/libpretixsync/api/PretixApi;", "conf", "Leu/pretix/libpretixsync/config/ConfigStore;", "require_live", "", "(Lio/requery/BlockingEntityStore;Leu/pretix/libpretixsync/api/PretixApi;Leu/pretix/libpretixsync/config/ConfigStore;Z)V", "eventMap", "Ljava/util/HashMap;", "", "Leu/pretix/libpretixsync/api/PretixApi$ApiResponse;", "Lkotlin/collections/HashMap;", "getEventMap", "()Ljava/util/HashMap;", "getAvailableEvents", "", "Leu/pretix/libpretixsync/setup/RemoteEvent;", "endsAfter", "Lorg/joda/time/DateTime;", "maxPages", "", "availabilityForChannel", "requireChannel", "parseEvents", "data", "Lorg/json/JSONObject;", "maxDepth", "subevents", "depth", "libpretixsync"})
public final class EventManager {
    @NotNull
    private final BlockingEntityStore<Persistable> store;
    @NotNull
    private final PretixApi api;
    @NotNull
    private final ConfigStore conf;
    private final boolean require_live;
    @NotNull
    private final HashMap<String, PretixApi.ApiResponse> eventMap;

    public EventManager(@NotNull BlockingEntityStore<Persistable> store, @NotNull PretixApi api, @NotNull ConfigStore conf, boolean require_live) {
        Intrinsics.checkNotNullParameter(store, "store");
        Intrinsics.checkNotNullParameter(api, "api");
        Intrinsics.checkNotNullParameter(conf, "conf");
        this.store = store;
        this.api = api;
        this.conf = conf;
        this.require_live = require_live;
        this.eventMap = new HashMap();
    }

    @NotNull
    public final HashMap<String, PretixApi.ApiResponse> getEventMap() {
        return this.eventMap;
    }

    @NotNull
    public final List<RemoteEvent> getAvailableEvents() {
        DateTime oneDayAgo = DateTime.now().minus(Hours.hours(24));
        Intrinsics.checkNotNullExpressionValue(oneDayAgo, "oneDayAgo");
        return this.getAvailableEvents(oneDayAgo, 5, null, null);
    }

    @NotNull
    public final List<RemoteEvent> getAvailableEvents(@NotNull DateTime endsAfter, int maxPages, @Nullable String availabilityForChannel, @Nullable String requireChannel) {
        Intrinsics.checkNotNullParameter(endsAfter, "endsAfter");
        this.eventMap.clear();
        String avail = availabilityForChannel != null ? "with_availability_for=" + availabilityForChannel + '&' : "";
        String endsAfterUrl = URLEncoder.encode(endsAfter.toString());
        PretixApi.ApiResponse resp_events = this.api.fetchResource(this.api.organizerResourceUrl("events") + '?' + avail + "ends_after=" + endsAfterUrl + (this.require_live ? "&live=true" : "") + (requireChannel != null ? Intrinsics.stringPlus("&sales_channel=", requireChannel) : ""));
        if (resp_events.getResponse().code() != 200) {
            throw new IOException();
        }
        JSONObject jSONObject = resp_events.getData();
        Intrinsics.checkNotNull(jSONObject);
        List events = EventManager.parseEvents$default(this, jSONObject, maxPages, false, 0, 12, null);
        PretixApi.ApiResponse resp_subevents = this.api.fetchResource(this.api.organizerResourceUrl("subevents") + '?' + avail + "ends_after=" + endsAfterUrl + (this.require_live ? "&active=true&event__live=true" : "") + (requireChannel != null ? Intrinsics.stringPlus("&sales_channel=", requireChannel) : ""));
        if (resp_subevents.getResponse().code() != 200) {
            throw new IOException();
        }
        Collection collection = events;
        JSONObject jSONObject2 = resp_subevents.getData();
        Intrinsics.checkNotNull(jSONObject2);
        JSONObject jSONObject3 = jSONObject2;
        events = CollectionsKt.plus(collection, (Iterable)EventManager.parseEvents$default(this, jSONObject3, maxPages, true, 0, 8, null));
        Iterable $this$sortedBy$iv = events;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                RemoteEvent it = (RemoteEvent)a;
                boolean bl2 = false;
                Comparable comparable = it.getDate_from();
                it = (RemoteEvent)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                DateTime dateTime = it.getDate_from();
                return ComparisonsKt.compareValues(comparable2, (Comparable)dateTime);
            }
        });
    }

    private final List<RemoteEvent> parseEvents(JSONObject data2, int maxDepth, boolean subevents, int depth) {
        ArrayList<RemoteEvent> events = new ArrayList<RemoteEvent>();
        int n = 0;
        JSONArray results = data2.getJSONArray("results");
        int n2 = results.length();
        if (n < n2) {
            do {
                boolean bl;
                int i2 = n++;
                JSONObject json2 = results.getJSONObject(i2);
                Object object = json2.getJSONObject("name");
                Intrinsics.checkNotNullExpressionValue(object, "json.getJSONObject(\"name\")");
                JSONObject jSONObject = object;
                object = subevents ? json2.getString("event") : json2.getString("slug");
                Intrinsics.checkNotNullExpressionValue(object, "if (subevents) json.getS\u2026se json.getString(\"slug\")");
                DateTime dateTime = new DateTime(json2.getString("date_from"));
                DateTime dateTime2 = json2.isNull("date_to") ? null : new DateTime(json2.optString("date_to"));
                Long l = subevents ? Long.valueOf(json2.getLong("id")) : null;
                Long l2 = json2.has("best_availability_state") && !json2.isNull("best_availability_state") ? Long.valueOf(json2.getLong("best_availability_state")) : (Long)null;
                if (subevents && !this.require_live) {
                    String eventSlug = json2.getString("event");
                    PretixApi.ApiResponse event = this.eventMap.get(eventSlug);
                    if (event == null) {
                        event = this.api.fetchResource(this.api.organizerResourceUrl(Intrinsics.stringPlus("events/", eventSlug)));
                        if (event.getResponse().code() != 200) {
                            throw new IOException();
                        }
                        Map map = this.eventMap;
                        Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                        String string = eventSlug;
                        boolean bl2 = false;
                        map.put(string, event);
                    }
                    JSONObject jSONObject2 = event.getData();
                    Intrinsics.checkNotNull(jSONObject2);
                    bl = jSONObject2.getBoolean("live") && json2.getBoolean("active");
                } else {
                    bl = this.require_live ? true : json2.getBoolean("live");
                }
                events.add(new RemoteEvent(jSONObject, (String)object, dateTime, dateTime2, l, l2, bl));
            } while (n < n2);
        }
        if (!data2.isNull("next") && depth < maxDepth) {
            String next = data2.getString("next");
            Intrinsics.checkNotNullExpressionValue(next, "next");
            PretixApi.ApiResponse resp = this.api.fetchResource(next);
            if (resp.getResponse().code() != 200) {
                throw new IOException();
            }
            Collection collection = events;
            JSONObject jSONObject = resp.getData();
            Intrinsics.checkNotNull(jSONObject);
            return CollectionsKt.plus(collection, (Iterable)this.parseEvents(jSONObject, maxDepth, subevents, depth + 1));
        }
        return events;
    }

    static /* synthetic */ List parseEvents$default(EventManager eventManager, JSONObject jSONObject, int n, boolean bl, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        if ((n3 & 8) != 0) {
            n2 = 1;
        }
        return eventManager.parseEvents(jSONObject, n, bl, n2);
    }
}

