/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.api.ResourceNotModified;
import eu.pretix.libpretixsync.db.CachedPdfImage;
import eu.pretix.libpretixsync.db.CheckIn;
import eu.pretix.libpretixsync.db.CheckInList;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.Migrations;
import eu.pretix.libpretixsync.db.Order;
import eu.pretix.libpretixsync.db.OrderPosition;
import eu.pretix.libpretixsync.db.ResourceSyncStatus;
import eu.pretix.libpretixsync.sync.BaseDownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import eu.pretix.libpretixsync.utils.HashUtils;
import eu.pretix.libpretixsync.utils.JSONUtils;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Condition;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OrderSyncAdapter
extends BaseDownloadSyncAdapter<Order, String> {
    private Map<Long, Item> itemCache = new HashMap<Long, Item>();
    private Map<Long, CheckInList> listCache = new HashMap<Long, CheckInList>();
    private Map<Long, List<CheckIn>> checkinCache = new HashMap<Long, List<CheckIn>>();
    private List<CheckIn> checkinCreateCache = new ArrayList<CheckIn>();
    private String firstResponseTimestamp;
    private String lastOrderTimestamp;
    private ResourceSyncStatus rlm;
    private boolean withPdfData;
    private boolean is_pretixpos;
    private Long subeventId;

    public OrderSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage, String eventSlug, Long subeventId, boolean withPdfData, boolean is_pretixpos, PretixApi api, String syncCylceId, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage, eventSlug, api, syncCylceId, feedback);
        this.withPdfData = withPdfData;
        this.subeventId = subeventId;
        this.is_pretixpos = is_pretixpos;
    }

    private String rlmName() {
        if (this.withPdfData) {
            return "orders_withpdfdata";
        }
        return "orders";
    }

    @Override
    public void download() throws JSONException, ApiException, ExecutionException, InterruptedException {
        boolean completed = false;
        try {
            super.download();
            completed = true;
        }
        finally {
            ResourceSyncStatus resourceSyncStatus = (ResourceSyncStatus)((Result)((WhereAndOr)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)this.rlmName())).and(ResourceSyncStatus.EVENT_SLUG.eq((Object)this.eventSlug))).limit(1).get()).firstOrNull();
            if (this.firstResponseTimestamp != null) {
                if (resourceSyncStatus == null) {
                    resourceSyncStatus = new ResourceSyncStatus();
                    resourceSyncStatus.setResource(this.rlmName());
                    resourceSyncStatus.setEvent_slug(this.eventSlug);
                    if (completed) {
                        resourceSyncStatus.setStatus("complete");
                    } else {
                        resourceSyncStatus.setStatus("incomplete:" + this.lastOrderTimestamp);
                    }
                    resourceSyncStatus.setLast_modified(this.firstResponseTimestamp);
                    this.store.upsert(resourceSyncStatus);
                } else if (completed) {
                    resourceSyncStatus.setLast_modified(this.firstResponseTimestamp);
                    this.store.upsert(resourceSyncStatus);
                }
            } else if (completed && resourceSyncStatus != null) {
                resourceSyncStatus.setStatus("complete");
                this.store.update(resourceSyncStatus);
            } else if (!completed && this.lastOrderTimestamp != null && resourceSyncStatus != null) {
                resourceSyncStatus.setStatus("incomplete:" + this.lastOrderTimestamp);
                this.store.update(resourceSyncStatus);
            }
            this.lastOrderTimestamp = null;
            this.firstResponseTimestamp = null;
        }
    }

    private Item getItem(long id) {
        if (this.itemCache.size() == 0) {
            List items = ((Result)this.store.select(Item.class, new QueryAttribute[0]).get()).toList();
            for (Item item : items) {
                this.itemCache.put(item.getServer_id(), item);
            }
        }
        return this.itemCache.get(id);
    }

    private void updatePositionObject(OrderPosition obj, JSONObject jsonobj, JSONObject jsonorder, JSONObject parent) throws JSONException {
        JSONObject pdfdata;
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setPositionid(jsonobj.getLong("positionid"));
        obj.setAttendee_name(jsonobj.isNull("attendee_name") ? "" : jsonobj.optString("attendee_name"));
        obj.setAttendee_email(jsonobj.isNull("attendee_email") ? "" : jsonobj.optString("attendee_email"));
        obj.setSecret(jsonobj.optString("secret"));
        obj.setJson_data(jsonobj.toString());
        obj.setItem(this.getItem(jsonobj.getLong("item")));
        obj.setSubevent_id(jsonobj.optLong("subevent"));
        obj.setVariation_id(jsonobj.optLong("variation"));
        if (obj.getAttendee_name() == null && parent != null && !parent.isNull("attendee_name")) {
            obj.setAttendee_name(parent.getString("attendee_name"));
        }
        if (obj.getAttendee_email() == null && parent != null && !parent.isNull("attendee_email")) {
            obj.setAttendee_email(parent.getString("attendee_email"));
        }
        if (obj.getAttendee_name() == null) {
            try {
                JSONObject jInvoiceAddress = jsonorder.getJSONObject("invoice_address");
                if (jInvoiceAddress.isNull("name")) {
                    obj.setAttendee_name(jInvoiceAddress.getString("name"));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (obj.getId() == null) {
            this.store.insert(obj);
        }
        HashMap<Long, CheckIn> known = new HashMap<Long, CheckIn>();
        List<CheckIn> checkincache = this.checkinCache.get(obj.getId());
        if (checkincache != null) {
            for (CheckIn op : checkincache) {
                if (op.getServer_id() != null && op.getServer_id() > 0L) {
                    known.put(op.getServer_id(), op);
                    continue;
                }
                this.store.delete(op);
            }
        }
        JSONArray checkins = jsonobj.getJSONArray("checkins");
        for (int i2 = 0; i2 < checkins.length(); ++i2) {
            CheckIn ciobj;
            JSONObject ci = checkins.getJSONObject(i2);
            Long listid = ci.getLong("list");
            if (known.containsKey(listid)) {
                ciobj = (CheckIn)known.remove(listid);
                ciobj.setPosition(obj);
                ciobj.setType(ci.optString("type", "entry"));
                ciobj.setListId(listid);
                ciobj.setDatetime(ISODateTimeFormat.dateTimeParser().parseDateTime(ci.getString("datetime")).toDate());
                ciobj.setJson_data(ci.toString());
                this.store.update(ciobj);
                continue;
            }
            ciobj = new CheckIn();
            ciobj.setPosition(obj);
            ciobj.setType(ci.optString("type", "entry"));
            ciobj.setListId(listid);
            ciobj.setDatetime(ISODateTimeFormat.dateTimeParser().parseDateTime(ci.getString("datetime")).toDate());
            ciobj.setJson_data(ci.toString());
            ciobj.setServer_id(ci.optLong("id"));
            this.checkinCreateCache.add(ciobj);
        }
        if (known.size() > 0) {
            this.store.delete(known.values());
        }
        if (jsonobj.has("pdf_data") && (pdfdata = jsonobj.getJSONObject("pdf_data")).has("images")) {
            JSONObject images = pdfdata.getJSONObject("images");
            OrderSyncAdapter.updatePdfImages(this.store, this.fileStorage, this.api, obj.getServer_id(), images);
        }
    }

    public static void updatePdfImages(BlockingEntityStore<Persistable> store, FileStorage fileStorage, PretixApi api, Long serverId, JSONObject images) {
        HashSet<String> seen_etags = new HashSet<String>();
        Iterator it = images.keys();
        while (it.hasNext()) {
            CachedPdfImage cpi;
            String k = (String)it.next();
            String remote_filename = images.optString(k);
            if (remote_filename == null || !remote_filename.startsWith("http")) continue;
            String etag = HashUtils.toSHA1(remote_filename.getBytes());
            if (remote_filename.contains("#etag=")) {
                etag = remote_filename.split("#etag=")[1];
            }
            String local_filename = "pdfimage_" + etag + ".bin";
            seen_etags.add(etag);
            if (!fileStorage.contains(local_filename)) {
                try {
                    int byteread;
                    PretixApi.ApiResponse file = api.downloadFile(remote_filename);
                    OutputStream os = fileStorage.writeStream(local_filename);
                    InputStream is = file.getResponse().body().byteStream();
                    byte[] buffer = new byte[1444];
                    while ((byteread = is.read(buffer)) != -1) {
                        os.write(buffer, 0, byteread);
                    }
                    is.close();
                    os.close();
                }
                catch (ApiException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    fileStorage.delete(local_filename);
                }
            }
            if ((cpi = (CachedPdfImage)((Result)((WhereAndOr)store.select(CachedPdfImage.class, new QueryAttribute[0]).where(CachedPdfImage.ORDERPOSITION_ID.eq((Object)serverId)).and(CachedPdfImage.KEY.eq((Object)k))).get()).firstOrNull()) == null) {
                cpi = new CachedPdfImage();
                cpi.setEtag(etag);
                cpi.setKey(k);
                cpi.setOrderposition_id(serverId);
                store.insert(cpi);
                continue;
            }
            cpi.setEtag(etag);
            store.update(cpi);
        }
        store.delete(CachedPdfImage.class).where((Condition)CachedPdfImage.ORDERPOSITION_ID.eq((Object)serverId).and(CachedPdfImage.ETAG.notIn(seen_etags)));
    }

    @Override
    protected void afterPage() {
        super.afterPage();
        this.store.insert(this.checkinCreateCache);
        this.checkinCreateCache.clear();
    }

    @Override
    public void updateObject(Order obj, JSONObject jsonobj) throws JSONException {
        JSONObject posjson;
        int i2;
        obj.setEvent_slug(this.eventSlug);
        obj.setCode(jsonobj.getString("code"));
        obj.setStatus(jsonobj.getString("status"));
        obj.setEmail(jsonobj.optString("email"));
        obj.setCheckin_attention(jsonobj.optBoolean("checkin_attention"));
        obj.setJson_data(jsonobj.toString());
        obj.setDeleteAfterTimestamp(0L);
        if (obj.getId() == null) {
            this.store.insert(obj);
        }
        HashMap<Long, OrderPosition> known = new HashMap<Long, OrderPosition>();
        List allPos = ((Result)this.store.select(OrderPosition.class, new QueryAttribute[0]).leftJoin(Order.class).on(Order.ID.eq(OrderPosition.ORDER_ID)).where(Order.ID.eq((Object)obj.getId())).get()).toList();
        for (OrderPosition op : allPos) {
            known.put(op.getServer_id(), op);
        }
        JSONArray posarray = jsonobj.getJSONArray("positions");
        HashMap<Long, JSONObject> posmap = new HashMap<Long, JSONObject>();
        for (i2 = 0; i2 < posarray.length(); ++i2) {
            posjson = posarray.getJSONObject(i2);
            posmap.put(posjson.getLong("id"), posjson);
        }
        for (i2 = 0; i2 < posarray.length(); ++i2) {
            OrderPosition posobj;
            posjson = posarray.getJSONObject(i2);
            posjson.put("__libpretixsync_dbversion", Migrations.CURRENT_VERSION);
            posjson.put("__libpretixsync_syncCycleId", this.syncCycleId);
            Long jsonid = posjson.getLong("id");
            JSONObject old = null;
            if (known.containsKey(jsonid)) {
                posobj = (OrderPosition)known.get(jsonid);
                old = posobj.getJSON();
            } else {
                posobj = new OrderPosition();
                posobj.setOrder(obj);
            }
            JSONObject parent = null;
            if (!posjson.isNull("addon_to")) {
                parent = (JSONObject)posmap.get(posjson.getLong("addon_to"));
            }
            if (known.containsKey(jsonid)) {
                known.remove(jsonid);
                if (JSONUtils.similar(posjson, (Object)old)) continue;
                this.updatePositionObject(posobj, posjson, jsonobj, parent);
                this.store.update(posobj);
                continue;
            }
            this.updatePositionObject(posobj, posjson, jsonobj, parent);
        }
        if (known.size() > 0) {
            this.store.delete(known.values());
        }
    }

    @Override
    protected boolean deleteUnseen() {
        return false;
    }

    @Override
    protected JSONObject downloadPage(String url, boolean isFirstPage) throws ApiException, ResourceNotModified {
        if (isFirstPage) {
            this.rlm = (ResourceSyncStatus)((Result)((WhereAndOr)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)this.rlmName())).and(ResourceSyncStatus.EVENT_SLUG.eq((Object)this.eventSlug))).limit(1).get()).firstOrNull();
        }
        boolean is_continued_fetch = false;
        if (!url.contains("testmode=")) {
            url = url.contains("?") ? url + "&" : url + "?";
            url = url + "testmode=false&exclude=downloads&exclude=payment_date&exclude=payment_provider&exclude=fees&exclude=positions.downloads";
            if (!this.is_pretixpos) {
                url = url + "&exclude=payments&exclude=refunds";
            }
            if (this.withPdfData) {
                url = url + "&pdf_data=true";
            }
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ssZ");
        DateTime cutoff = new DateTime().withZone(DateTimeZone.UTC).minus(Duration.standardDays(14L));
        String firstrun_params = "";
        try {
            if (this.subeventId != null && this.subeventId > 0L) {
                firstrun_params = "&subevent_after=" + URLEncoder.encode(formatter.print(cutoff), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (this.rlm != null) {
            if (this.rlm.getStatus() != null && this.rlm.getStatus().startsWith("incomplete:")) {
                is_continued_fetch = true;
                try {
                    if (!url.contains("created_since")) {
                        url = url + "&ordering=datetime&created_since=" + URLEncoder.encode(this.rlm.getStatus().substring(11), "UTF-8") + firstrun_params;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    if (!url.contains("modified_since")) {
                        url = url + "&ordering=-last_modified&modified_since=" + URLEncoder.encode(this.rlm.getLast_modified(), "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        } else if (!url.contains("subevent_after")) {
            url = url + firstrun_params;
        }
        PretixApi.ApiResponse apiResponse = this.api.fetchResource(url);
        if (isFirstPage && !is_continued_fetch) {
            this.firstResponseTimestamp = apiResponse.getResponse().header("X-Page-Generated");
        }
        JSONObject d = apiResponse.getData();
        if (apiResponse.getResponse().code() == 200) {
            try {
                JSONArray res = d.getJSONArray("results");
                if (res.length() > 0) {
                    this.lastOrderTimestamp = res.getJSONObject(res.length() - 1).getString("datetime");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return d;
    }

    @Override
    protected Map<String, Order> getKnownObjects(Set<String> ids) {
        this.checkinCache.clear();
        if (ids.isEmpty()) {
            return new HashMap<String, Order>();
        }
        List allCheckins = ((Result)this.store.select(CheckIn.class, new QueryAttribute[0]).leftJoin(OrderPosition.class).on(OrderPosition.ID.eq(CheckIn.POSITION_ID)).leftJoin(Order.class).on(Order.ID.eq(OrderPosition.ORDER_ID)).where(Order.CODE.in(ids)).get()).toList();
        for (CheckIn c : allCheckins) {
            Long pk = c.getPosition().getId();
            if (this.checkinCache.containsKey(pk)) {
                this.checkinCache.get(pk).add(c);
                continue;
            }
            ArrayList<CheckIn> l = new ArrayList<CheckIn>();
            l.add(c);
            this.checkinCache.put(pk, l);
        }
        return super.getKnownObjects(ids);
    }

    @Override
    public CloseableIterator<Order> runBatch(List<String> ids) {
        return ((Result)((WhereAndOr)this.store.select(Order.class, new QueryAttribute[0]).where(Order.EVENT_SLUG.eq((Object)this.eventSlug)).and(Order.CODE.in(ids))).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(Order.CODE).where(Item.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    protected boolean autoPersist() {
        return false;
    }

    @Override
    String getResourceName() {
        return "orders";
    }

    @Override
    String getId(JSONObject obj) throws JSONException {
        return obj.getString("code");
    }

    @Override
    String getId(Order obj) {
        return obj.getCode();
    }

    @Override
    Order newEmptyObject() {
        return new Order();
    }

    public void standaloneRefreshFromJSON(JSONObject data2) throws JSONException {
        Order order = ((Result)this.store.select(Order.class, new QueryAttribute[0]).where(Order.CODE.eq((Object)data2.getString("code"))).get()).firstOr(this.newEmptyObject());
        JSONObject old = null;
        if (order.getId() != null) {
            old = order.getJSON();
        }
        HashSet<String> ids = new HashSet<String>();
        ids.add(data2.getString("code"));
        this.getKnownObjects((Set<String>)ids);
        data2.put("__libpretixsync_dbversion", Migrations.CURRENT_VERSION);
        data2.put("__libpretixsync_syncCycleId", this.syncCycleId);
        if (old == null) {
            this.updateObject(order, data2);
        } else if (!JSONUtils.similar(data2, (Object)old)) {
            this.updateObject(order, data2);
            this.store.update(order);
        }
        this.store.insert(this.checkinCreateCache);
        this.checkinCreateCache.clear();
    }
}

