/*
 * Decompiled with CFR 0.152.
 */
package io.requery.query.element;

import io.requery.query.AndOr;
import io.requery.query.Condition;
import io.requery.query.element.LogicalElement;
import io.requery.query.element.LogicalOperator;
import io.requery.util.Objects;
import java.util.Set;

abstract class BaseLogicalElement<E extends S, S>
implements AndOr<S>,
LogicalElement {
    private final Set<E> elements;
    private final LogicalOperator operator;
    private final Condition<?, ?> condition;

    BaseLogicalElement(Set<E> elements, Condition<?, ?> condition, LogicalOperator operator) {
        this.elements = elements;
        this.condition = condition;
        this.operator = operator;
    }

    abstract E newElement(Set<E> var1, Condition<?, ?> var2, LogicalOperator var3);

    @Override
    public <V> S and(Condition<V, ?> condition) {
        E element = this.newElement(this.elements, condition, LogicalOperator.AND);
        this.elements.add(element);
        return (S)element;
    }

    @Override
    public <V> S or(Condition<V, ?> condition) {
        E element = this.newElement(this.elements, condition, LogicalOperator.OR);
        this.elements.add(element);
        return (S)element;
    }

    @Override
    public S not() {
        E element = this.newElement(this.elements, this.condition, LogicalOperator.NOT);
        this.elements.add(element);
        return (S)element;
    }

    @Override
    public Condition<?, ?> getCondition() {
        return this.condition;
    }

    @Override
    public LogicalOperator getOperator() {
        return this.operator;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseLogicalElement) {
            BaseLogicalElement other = (BaseLogicalElement)obj;
            return Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.condition, other.condition);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.condition});
    }
}

