/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.ItemCategory;
import eu.pretix.libpretixsync.sync.BaseConditionalSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ItemCategorySyncAdapter
extends BaseConditionalSyncAdapter<ItemCategory, Long> {
    public ItemCategorySyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage, String eventSlug, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage, eventSlug, api, syncCycleId, feedback);
    }

    @Override
    public void updateObject(ItemCategory obj, JSONObject jsonobj) throws JSONException {
        obj.setEvent_slug(this.eventSlug);
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setPosition(jsonobj.getLong("position"));
        obj.setIs_addon(jsonobj.optBoolean("is_addon", false));
        obj.setJson_data(jsonobj.toString());
    }

    @Override
    public CloseableIterator<ItemCategory> runBatch(List<Long> ids) {
        return ((Result)((WhereAndOr)this.store.select(ItemCategory.class, new QueryAttribute[0]).where(ItemCategory.EVENT_SLUG.eq((Object)this.eventSlug)).and(ItemCategory.SERVER_ID.in(ids))).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(ItemCategory.SERVER_ID).where(ItemCategory.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    String getResourceName() {
        return "categories";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(ItemCategory obj) {
        return obj.getServer_id();
    }

    @Override
    ItemCategory newEmptyObject() {
        return new ItemCategory();
    }
}

