/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.EntityCache;
import io.requery.TransactionIsolation;
import io.requery.TransactionListener;
import io.requery.cache.WeakEntityCache;
import io.requery.meta.EntityModel;
import io.requery.sql.Configuration;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.DataSourceConnectionProvider;
import io.requery.sql.EntityStateListener;
import io.requery.sql.ImmutableConfiguration;
import io.requery.sql.Mapping;
import io.requery.sql.Platform;
import io.requery.sql.PooledConnectionProvider;
import io.requery.sql.StatementListener;
import io.requery.sql.TransactionMode;
import io.requery.util.Objects;
import io.requery.util.function.Function;
import io.requery.util.function.Supplier;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;

public class ConfigurationBuilder {
    private final EntityModel model;
    private final ConnectionProvider connectionProvider;
    private final Set<StatementListener> statementListeners;
    private final Set<Supplier<TransactionListener>> transactionListenerFactory;
    private final Set<EntityStateListener> entityStateListeners;
    private Platform platform;
    private EntityCache cache;
    private Mapping mapping;
    private TransactionMode transactionMode;
    private TransactionIsolation transactionIsolation;
    private boolean useDefaultLogging;
    private int statementCacheSize;
    private int batchUpdateSize;
    private boolean quoteTableNames;
    private boolean quoteColumnNames;
    private Function<String, String> tableTransformer;
    private Function<String, String> columnTransformer;
    private Executor writeExecutor;

    public ConfigurationBuilder(ConnectionProvider connectionProvider, EntityModel model) {
        this.connectionProvider = Objects.requireNotNull(connectionProvider);
        this.model = Objects.requireNotNull(model);
        this.statementListeners = new LinkedHashSet<StatementListener>();
        this.entityStateListeners = new LinkedHashSet<EntityStateListener>();
        this.transactionListenerFactory = new LinkedHashSet<Supplier<TransactionListener>>();
        this.setQuoteTableNames(false);
        this.setQuoteColumnNames(false);
        this.setEntityCache(new WeakEntityCache());
        this.setStatementCacheSize(0);
        this.setBatchUpdateSize(64);
        this.setTransactionMode(TransactionMode.AUTO);
        this.setTransactionIsolation(null);
        this.setTableTransformer(null);
        this.setColumnTransformer(null);
    }

    public ConfigurationBuilder(CommonDataSource dataSource, EntityModel model) {
        this(ConfigurationBuilder.createConnectionProvider(dataSource), model);
    }

    private static ConnectionProvider createConnectionProvider(CommonDataSource dataSource) {
        if (dataSource instanceof ConnectionPoolDataSource) {
            return new PooledConnectionProvider((ConnectionPoolDataSource)dataSource);
        }
        if (dataSource instanceof DataSource) {
            return new DataSourceConnectionProvider((DataSource)dataSource);
        }
        throw new IllegalArgumentException("unsupported dataSource " + dataSource);
    }

    public ConfigurationBuilder setMapping(Mapping mapping) {
        this.mapping = mapping;
        return this;
    }

    public ConfigurationBuilder setPlatform(Platform platform) {
        this.platform = platform;
        return this;
    }

    public ConfigurationBuilder setEntityCache(EntityCache cache2) {
        this.cache = cache2;
        return this;
    }

    public ConfigurationBuilder setStatementCacheSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.statementCacheSize = size;
        return this;
    }

    public ConfigurationBuilder setBatchUpdateSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.batchUpdateSize = size;
        return this;
    }

    public ConfigurationBuilder setQuoteTableNames(boolean quote) {
        this.quoteTableNames = quote;
        return this;
    }

    public ConfigurationBuilder setTableTransformer(Function<String, String> function2) {
        this.tableTransformer = function2;
        return this;
    }

    public ConfigurationBuilder setColumnTransformer(Function<String, String> function2) {
        this.columnTransformer = function2;
        return this;
    }

    public ConfigurationBuilder setQuoteColumnNames(boolean quote) {
        this.quoteColumnNames = quote;
        return this;
    }

    public ConfigurationBuilder setWriteExecutor(Executor writeExecutor) {
        this.writeExecutor = writeExecutor;
        return this;
    }

    public ConfigurationBuilder addStatementListener(StatementListener listener) {
        this.statementListeners.add(Objects.requireNotNull(listener));
        return this;
    }

    public ConfigurationBuilder addTransactionListenerFactory(Supplier<TransactionListener> supplier) {
        this.transactionListenerFactory.add(Objects.requireNotNull(supplier));
        return this;
    }

    public ConfigurationBuilder useDefaultLogging() {
        this.useDefaultLogging = true;
        return this;
    }

    public ConfigurationBuilder addEntityStateListener(EntityStateListener listener) {
        this.entityStateListeners.add(Objects.requireNotNull(listener));
        return this;
    }

    public ConfigurationBuilder setTransactionIsolation(TransactionIsolation isolation) {
        this.transactionIsolation = isolation;
        return this;
    }

    public ConfigurationBuilder setTransactionMode(TransactionMode mode) {
        this.transactionMode = mode;
        return this;
    }

    public Configuration build() {
        return new ImmutableConfiguration(this.connectionProvider, this.platform, this.model, this.cache, this.mapping, this.useDefaultLogging, this.statementCacheSize, this.batchUpdateSize, this.quoteTableNames, this.quoteColumnNames, this.tableTransformer, this.columnTransformer, this.entityStateListeners, this.statementListeners, this.transactionMode, this.transactionIsolation, this.transactionListenerFactory, this.writeExecutor);
    }
}

