/*
 * Decompiled with CFR 0.152.
 */
package io.requery.meta;

import io.requery.CascadeAction;
import io.requery.Converter;
import io.requery.ReferentialAction;
import io.requery.meta.Attribute;
import io.requery.meta.AttributeBuilder;
import io.requery.meta.Cardinality;
import io.requery.meta.PrimitiveKind;
import io.requery.meta.QueryAttribute;
import io.requery.meta.Type;
import io.requery.meta.TypeDeclarable;
import io.requery.proxy.Initializer;
import io.requery.proxy.Property;
import io.requery.proxy.PropertyState;
import io.requery.query.ExpressionType;
import io.requery.query.FieldExpression;
import io.requery.query.Order;
import io.requery.util.Objects;
import io.requery.util.function.Supplier;
import java.util.Collections;
import java.util.Set;

abstract class BaseAttribute<T, V>
extends FieldExpression<V>
implements QueryAttribute<T, V>,
TypeDeclarable<T> {
    Property<?, V> builderProperty;
    Cardinality cardinality;
    Set<CascadeAction> cascadeActions;
    Class<V> classType;
    String collate;
    Converter<V, ?> converter;
    Type<T> declaringType;
    String defaultValue;
    String definition;
    ReferentialAction deleteAction;
    Class<?> elementClass;
    Set<String> indexNames;
    Initializer<T, V> initializer;
    boolean isForeignKey;
    boolean isKey;
    boolean isGenerated;
    boolean isIndex;
    boolean isLazy;
    boolean isNullable;
    boolean isReadOnly;
    boolean isUnique;
    boolean isVersion;
    Integer length;
    Class<?> mapKeyClass;
    Supplier<Attribute> mappedAttribute;
    String name;
    Supplier<Attribute> orderByAttribute;
    Order orderByDirection;
    PrimitiveKind primitiveKind;
    Property<T, V> property;
    String propertyName;
    Property<T, PropertyState> propertyState;
    Supplier<Attribute> referencedAttribute;
    Class<?> referencedClass;
    ReferentialAction updateAction;

    BaseAttribute() {
    }

    BaseAttribute(AttributeBuilder<T, V> builder) {
        this.builderProperty = builder.getBuilderProperty();
        this.cardinality = builder.getCardinality();
        this.cascadeActions = builder.getCascadeActions();
        this.classType = builder.getClassType();
        this.collate = builder.getCollate();
        this.converter = builder.getConverter();
        this.defaultValue = builder.getDefaultValue();
        this.definition = builder.getDefinition();
        this.deleteAction = builder.getDeleteAction();
        this.elementClass = builder.getElementClass();
        this.indexNames = builder.getIndexNames();
        this.initializer = builder.getInitializer();
        this.isForeignKey = builder.isForeignKey();
        this.isGenerated = builder.isGenerated();
        this.isIndex = builder.isIndexed();
        this.isKey = builder.isKey();
        this.isLazy = builder.isLazy();
        this.isNullable = builder.isNullable();
        this.isReadOnly = builder.isReadOnly();
        this.isUnique = builder.isUnique();
        this.isVersion = builder.isVersion();
        this.length = builder.getLength();
        this.mapKeyClass = builder.getMapKeyClass();
        this.mappedAttribute = builder.getMappedAttribute();
        this.name = builder.getName();
        this.orderByAttribute = builder.getOrderByAttribute();
        this.orderByDirection = builder.getOrderByDirection();
        this.primitiveKind = builder.getPrimitiveKind();
        this.property = builder.getProperty();
        this.propertyName = builder.getPropertyName();
        this.propertyState = builder.getPropertyState();
        this.referencedAttribute = builder.getReferencedAttribute();
        this.referencedClass = builder.getReferencedClass();
        this.updateAction = builder.getUpdateAction();
    }

    @Override
    public Property<?, V> getBuilderProperty() {
        return this.builderProperty;
    }

    @Override
    public Class<V> getClassType() {
        return this.classType;
    }

    @Override
    public Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public Set<CascadeAction> getCascadeActions() {
        return this.cascadeActions == null ? Collections.emptySet() : this.cascadeActions;
    }

    @Override
    public String getCollate() {
        return this.collate;
    }

    @Override
    public Converter<V, ?> getConverter() {
        return this.converter;
    }

    @Override
    public Type<T> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    public ReferentialAction getDeleteAction() {
        return this.deleteAction;
    }

    @Override
    public Class<?> getElementClass() {
        return this.elementClass;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.ATTRIBUTE;
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    @Override
    public Initializer<T, V> getInitializer() {
        return this.initializer;
    }

    @Override
    public Integer getLength() {
        return this.converter != null ? this.converter.getPersistedSize() : this.length;
    }

    @Override
    public Class<?> getMapKeyClass() {
        return this.mapKeyClass;
    }

    @Override
    public Supplier<Attribute> getMappedAttribute() {
        return this.mappedAttribute;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Supplier<Attribute> getOrderByAttribute() {
        return this.orderByAttribute;
    }

    @Override
    public Order getOrderByDirection() {
        return this.orderByDirection;
    }

    @Override
    public PrimitiveKind getPrimitiveKind() {
        return this.primitiveKind;
    }

    @Override
    public Property<T, V> getProperty() {
        return this.property;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Property<T, PropertyState> getPropertyState() {
        return this.propertyState;
    }

    @Override
    public Supplier<Attribute> getReferencedAttribute() {
        return this.referencedAttribute;
    }

    @Override
    public Class<?> getReferencedClass() {
        return this.referencedClass;
    }

    @Override
    public ReferentialAction getUpdateAction() {
        return this.updateAction;
    }

    @Override
    public boolean isAssociation() {
        return this.cardinality != null;
    }

    @Override
    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    @Override
    public boolean isGenerated() {
        return this.isGenerated;
    }

    @Override
    public boolean isIndexed() {
        return this.isIndex;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public boolean isVersion() {
        return this.isVersion;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Attribute) {
            Attribute attribute = (Attribute)obj;
            return Objects.equals(this.name, attribute.getName()) && Objects.equals(this.classType, attribute.getClassType()) && Objects.equals(this.declaringType, attribute.getDeclaringType());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.classType, this.declaringType);
    }

    public String toString() {
        return this.getDeclaringType() == null ? this.getName() : this.getDeclaringType().getName() + "." + this.getName();
    }

    @Override
    public void setDeclaringType(Type<T> type2) {
        this.declaringType = type2;
    }
}

