/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.TransactionListenable;
import io.requery.TransactionListener;
import io.requery.meta.Attribute;
import io.requery.query.BaseResult;
import io.requery.query.Expression;
import io.requery.query.element.QueryElement;
import io.requery.query.element.QueryWrapper;
import io.requery.sql.Attributes;
import io.requery.sql.BoundParameters;
import io.requery.sql.Mapping;
import io.requery.sql.ResultReader;
import io.requery.sql.ResultSetIterator;
import io.requery.sql.RuntimeConfiguration;
import io.requery.sql.StatementExecutionException;
import io.requery.sql.StatementListener;
import io.requery.sql.UncloseableConnection;
import io.requery.sql.gen.DefaultOutput;
import io.requery.util.CloseableIterator;
import io.requery.util.function.Supplier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;

class SelectResult<E>
extends BaseResult<E>
implements TransactionListenable,
QueryWrapper {
    private final QueryElement<?> query;
    private final RuntimeConfiguration configuration;
    private final ResultReader<E> reader;
    private final Set<? extends Expression<?>> selection;
    private final Integer limit;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private String sql;
    private boolean closeConnection;

    SelectResult(RuntimeConfiguration configuration, QueryElement<?> query, ResultReader<E> reader) {
        super(query.getLimit());
        this.query = query;
        this.configuration = configuration;
        this.reader = reader;
        this.selection = query.getSelection();
        this.limit = query.getLimit();
        this.closeConnection = true;
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
    }

    private Statement createStatement(boolean prepared) throws SQLException {
        Connection connection = this.configuration.getConnection();
        this.closeConnection = !(connection instanceof UncloseableConnection);
        Statement statement = !prepared ? connection.createStatement(this.resultSetType, this.resultSetConcurrency) : connection.prepareStatement(this.sql, this.resultSetType, this.resultSetConcurrency);
        return statement;
    }

    private BoundParameters createQuery(int skip, int take) {
        if (this.limit == null && take > 0 && take != Integer.MAX_VALUE) {
            this.query.limit(take).offset(skip);
        }
        DefaultOutput generator = new DefaultOutput(this.configuration, this.query);
        this.sql = generator.toSql();
        return generator.parameters();
    }

    @Override
    public CloseableIterator<E> createIterator(int skip, int take) {
        Statement statement = null;
        try {
            ResultSet results;
            BoundParameters parameters2 = this.createQuery(skip, take);
            statement = this.createStatement(!parameters2.isEmpty());
            statement.setFetchSize(this.limit == null ? 0 : this.limit);
            StatementListener listener = this.configuration.getStatementListener();
            listener.beforeExecuteQuery(statement, this.sql, parameters2);
            if (parameters2.isEmpty()) {
                results = statement.executeQuery(this.sql);
            } else {
                PreparedStatement preparedStatement = (PreparedStatement)statement;
                Mapping mapping = this.configuration.getMapping();
                for (int i2 = 0; i2 < parameters2.count(); ++i2) {
                    Attribute attribute;
                    Expression<?> expression = parameters2.expressionAt(i2);
                    Object value = parameters2.valueAt(i2);
                    if (expression instanceof Attribute && (attribute = (Attribute)((Object)expression)).isAssociation() && (attribute.isForeignKey() || attribute.isKey()) && value != null && expression.getClassType().isAssignableFrom(value.getClass())) {
                        value = Attributes.replaceKeyReference(value, attribute);
                    }
                    mapping.write(expression, preparedStatement, i2 + 1, value);
                }
                results = preparedStatement.executeQuery();
            }
            listener.afterExecuteQuery(statement);
            return new ResultSetIterator<E>(this.reader, results, this.selection, true, this.closeConnection);
        }
        catch (Exception e) {
            throw StatementExecutionException.closing(statement, e, this.sql);
        }
    }

    @Override
    public void addTransactionListener(Supplier<TransactionListener> supplier) {
        if (supplier != null) {
            this.configuration.getTransactionListenerFactories().add(supplier);
        }
    }

    public QueryElement unwrapQuery() {
        return this.query;
    }
}

