/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.check;

import eu.pretix.libpretixsync.DummySentryImplementation;
import eu.pretix.libpretixsync.SentryInterface;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.check.AsyncCheckProvider;
import eu.pretix.libpretixsync.check.CheckException;
import eu.pretix.libpretixsync.check.TicketCheckProvider;
import eu.pretix.libpretixsync.config.ConfigStore;
import eu.pretix.libpretixsync.crypto.sig1.TicketProtos;
import eu.pretix.libpretixsync.db.Answer;
import eu.pretix.libpretixsync.db.BlockedTicketSecret;
import eu.pretix.libpretixsync.db.CheckIn;
import eu.pretix.libpretixsync.db.CheckInList;
import eu.pretix.libpretixsync.db.CheckInList_Item;
import eu.pretix.libpretixsync.db.Event;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.ItemVariation;
import eu.pretix.libpretixsync.db.NonceGenerator;
import eu.pretix.libpretixsync.db.Order;
import eu.pretix.libpretixsync.db.OrderPosition;
import eu.pretix.libpretixsync.db.Question;
import eu.pretix.libpretixsync.db.QuestionLike;
import eu.pretix.libpretixsync.db.QueuedCall;
import eu.pretix.libpretixsync.db.QueuedCheckIn;
import eu.pretix.libpretixsync.db.RevokedTicketSecret;
import eu.pretix.libpretixsync.db.SubEvent;
import eu.pretix.libpretixsync.utils.codec.binary.Base64;
import eu.pretix.libpretixsync.utils.logic.JsonLogic;
import eu.pretix.libpretixsync.utils.logic.UtilsKt;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.kotlin.Logical;
import io.requery.meta.QueryAttribute;
import io.requery.query.Condition;
import io.requery.query.DistinctSelection;
import io.requery.query.Expression;
import io.requery.query.LogicalCondition;
import io.requery.query.Result;
import io.requery.query.Return;
import io.requery.query.Scalar;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.IllegalInstantException;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001BB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J0\u0010\f\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000e0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u0019H\u0016JL\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u00192\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0016J<\u0010\"\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u0011H\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0019H\u0003J \u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\tH\u0002J2\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00112\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u000fH\u0016J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\tJ\u0010\u00105\u001a\u0002032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u001aH\u0016Je\u0010:\u001a\u0002032\u0006\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010AR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Leu/pretix/libpretixsync/check/AsyncCheckProvider;", "Leu/pretix/libpretixsync/check/TicketCheckProvider;", "config", "Leu/pretix/libpretixsync/config/ConfigStore;", "dataStore", "Lio/requery/BlockingEntityStore;", "Lio/requery/Persistable;", "(Leu/pretix/libpretixsync/config/ConfigStore;Lio/requery/BlockingEntityStore;)V", "overrideNow", "Lorg/joda/time/DateTime;", "sentry", "Leu/pretix/libpretixsync/SentryInterface;", "basePositionQuery", "Lio/requery/query/WhereAndOr;", "Lio/requery/query/Scalar;", "", "lists", "", "Leu/pretix/libpretixsync/db/CheckInList;", "onlyCheckedIn", "", "check", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckResult;", "eventsAndCheckinLists", "", "", "", "ticketid", "answers", "Leu/pretix/libpretixsync/db/Answer;", "ignore_unpaid", "with_badge_data", "type", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckInType;", "checkOfflineWithoutData", "decodePretixSig1", "Leu/pretix/libpretixsync/check/AsyncCheckProvider$SignedTicketData;", "event", "Leu/pretix/libpretixsync/db/Event;", "qrcode", "initJsonLogic", "Leu/pretix/libpretixsync/utils/logic/JsonLogic;", "subeventId", "tz", "Lorg/joda/time/DateTimeZone;", "now", "search", "Leu/pretix/libpretixsync/check/TicketCheckProvider$SearchResult;", "query", "page", "setNow", "", "d", "setSentry", "status", "Leu/pretix/libpretixsync/check/TicketCheckProvider$StatusResult;", "eventSlug", "listId", "storeFailedCheckin", "error_reason", "raw_barcode", "position", "item", "variation", "subevent", "(Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckInType;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;)V", "SignedTicketData", "libpretixsync"})
public final class AsyncCheckProvider
implements TicketCheckProvider {
    @NotNull
    private final ConfigStore config;
    @NotNull
    private final BlockingEntityStore<Persistable> dataStore;
    @NotNull
    private SentryInterface sentry;
    @Nullable
    private DateTime overrideNow;

    public AsyncCheckProvider(@NotNull ConfigStore config, @NotNull BlockingEntityStore<Persistable> dataStore) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(dataStore, "dataStore");
        this.config = config;
        this.dataStore = dataStore;
        this.sentry = new DummySentryImplementation();
    }

    @Override
    public void setSentry(@NotNull SentryInterface sentry) {
        Intrinsics.checkNotNullParameter(sentry, "sentry");
        this.sentry = sentry;
    }

    private final void storeFailedCheckin(String eventSlug, long listId, String error_reason, String raw_barcode, TicketCheckProvider.CheckInType type2, Long position, Long item, Long variation, Long subevent) {
        String string;
        DateTime dt = this.now();
        JSONObject jdoc = new JSONObject();
        jdoc.put("datetime", QueuedCheckIn.formatDatetime(dt.toDate()));
        Object object = raw_barcode;
        Object object2 = new Regex("[\\p{C}]");
        boolean bl = false;
        if (((Regex)object2).containsMatchIn((CharSequence)object)) {
            object2 = raw_barcode;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset()");
            boolean bl2 = false;
            Object object3 = object2;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = ((String)object3).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
            object = Base64.encodeBase64(byArray);
            Intrinsics.checkNotNullExpressionValue(object, "encodeBase64(raw_barcode\u2026harset.defaultCharset()))");
            object2 = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(object2, "defaultCharset()");
            boolean bl3 = false;
            bl2 = false;
            jdoc.put("raw_barcode", Intrinsics.stringPlus("binary:", new String((byte[])object, (Charset)object2)));
        } else {
            jdoc.put("raw_barcode", raw_barcode);
        }
        object = type2;
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                string = "entry";
                break;
            }
            case 2: {
                string = "exit";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        jdoc.put("type", string);
        jdoc.put("error_reason", error_reason);
        if (position != null && position > 0L) {
            jdoc.put("position", position);
        }
        if (item != null && item > 0L) {
            jdoc.put("item", item);
        }
        if (variation != null && variation > 0L) {
            jdoc.put("variation", variation);
        }
        if (subevent != null && subevent > 0L) {
            jdoc.put("subevent", subevent);
        }
        QueuedCall qo = new QueuedCall();
        PretixApi api = PretixApi.Companion.fromConfig(this.config);
        qo.setUrl(api.eventResourceUrl(eventSlug, "checkinlists") + listId + "/failed_checkins/");
        qo.setBody(jdoc.toString());
        qo.setIdempotency_key(NonceGenerator.nextNonce());
        this.dataStore.insert(qo);
    }

    static /* synthetic */ void storeFailedCheckin$default(AsyncCheckProvider asyncCheckProvider, String string, long l, String string2, String string3, TicketCheckProvider.CheckInType checkInType, Long l2, Long l3, Long l4, Long l5, int n, Object object) {
        if ((n & 0x20) != 0) {
            l2 = null;
        }
        if ((n & 0x40) != 0) {
            l3 = null;
        }
        if ((n & 0x80) != 0) {
            l4 = null;
        }
        if ((n & 0x100) != 0) {
            l5 = null;
        }
        asyncCheckProvider.storeFailedCheckin(string, l, string2, string3, checkInType, l2, l3, l4, l5);
    }

    private final JsonLogic initJsonLogic(Event event, long subeventId, DateTimeZone tz) {
        JsonLogic jsonLogic = new JsonLogic();
        jsonLogic.addOperation("objectList", initJsonLogic.1.INSTANCE);
        jsonLogic.addOperation("lookup", initJsonLogic.2.INSTANCE);
        jsonLogic.addOperation("inList", initJsonLogic.3.INSTANCE);
        jsonLogic.addOperation("isAfter", initJsonLogic.4.INSTANCE);
        jsonLogic.addOperation("isBefore", initJsonLogic.5.INSTANCE);
        jsonLogic.addOperation("buildTime", (Function2<? super List<? extends Object>, Object, ? extends Object>)new Function2<List<? extends Object>, Object, Object>(event, subeventId, this, tz){
            final /* synthetic */ Event $event;
            final /* synthetic */ long $subeventId;
            final /* synthetic */ AsyncCheckProvider this$0;
            final /* synthetic */ DateTimeZone $tz;
            {
                this.$event = $event;
                this.$subeventId = $subeventId;
                this.this$0 = $receiver;
                this.$tz = $tz;
                super(2);
            }

            @Nullable
            public final Object invoke(@Nullable List<? extends Object> l, @Nullable Object d) {
                DateTime dateTime;
                List<? extends Object> list = l;
                Object t = list == null ? null : CollectionsKt.getOrNull(list, 0);
                JSONObject evjson = this.$event.getJSON();
                if (this.$subeventId != 0L) {
                    SubEvent subevent = (SubEvent)((Result)((WhereAndOr)AsyncCheckProvider.access$getDataStore$p(this.this$0).select(SubEvent.class, new QueryAttribute[0]).where((Condition)SubEvent.EVENT_SLUG.eq((Object)this.$event.slug)).and((Condition)SubEvent.SERVER_ID.eq((Object)this.$subeventId))).get()).first();
                    evjson = subevent.getJSON();
                }
                if (Intrinsics.areEqual(t, "custom")) {
                    dateTime = ISODateTimeFormat.dateTimeParser().parseDateTime((String)CollectionsKt.getOrNull(l, 1));
                } else if (Intrinsics.areEqual(t, "customtime")) {
                    DateTime dateTime2;
                    LocalTime time = ISODateTimeFormat.timeParser().parseLocalTime((String)CollectionsKt.getOrNull(l, 1));
                    LocalDate today = new DateTime(AsyncCheckProvider.access$now(this.this$0)).withZone(this.$tz).toLocalDate();
                    try {
                        dateTime2 = today.toLocalDateTime(time).toDateTime(this.$tz);
                    }
                    catch (IllegalInstantException e) {
                        dateTime2 = today.toLocalDateTime(time.minusHours(1)).toDateTime(this.$tz);
                    }
                    dateTime = dateTime2;
                } else {
                    String string;
                    dateTime = Intrinsics.areEqual(t, "date_from") ? ISODateTimeFormat.dateTimeParser().parseDateTime(evjson.getString("date_from")) : (Intrinsics.areEqual(t, "date_to") ? ISODateTimeFormat.dateTimeParser().parseDateTime(evjson.optString("date_to")) : (Intrinsics.areEqual(t, "date_admission") ? ISODateTimeFormat.dateTimeParser().parseDateTime((string = evjson.optString("date_admission")) == null ? evjson.getString("date_from") : string) : (DateTime)null));
                }
                return dateTime;
            }
        });
        return jsonLogic;
    }

    @ExperimentalUnsignedTypes
    private final SignedTicketData decodePretixSig1(Event event, String qrcode) {
        JSONArray jSONArray;
        byte by;
        byte[] rawbytes = null;
        try {
            String string = qrcode;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.reversed((CharSequence)string2)).toString();
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset()");
            by = 0;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = Base64.decodeBase64(byArray);
            Intrinsics.checkNotNullExpressionValue(byArray2, "decodeBase64(qrcode.reve\u2026harset.defaultCharset()))");
            rawbytes = byArray2;
        }
        catch (Exception e) {
            return null;
        }
        if (rawbytes.length == 0) {
            return null;
        }
        byte by2 = rawbytes[0];
        byte by3 = 0;
        by2 = UByte.constructor-impl(by2);
        by3 = 0;
        int version = by2 & 0xFF;
        if (version != 1) {
            return null;
        }
        by3 = rawbytes[1];
        by = 0;
        by3 = UByte.constructor-impl(by3);
        by = 0;
        int n = (by3 & 0xFF) << 2;
        by3 = rawbytes[2];
        by = 0;
        by3 = UByte.constructor-impl(by3);
        by = 0;
        int payloadLength = n + (by3 & 0xFF);
        by = rawbytes[3];
        boolean bl = false;
        by = UByte.constructor-impl(by);
        bl = false;
        int n2 = (by & 0xFF) << 2;
        by = rawbytes[4];
        bl = false;
        by = UByte.constructor-impl(by);
        bl = false;
        int signatureLength = n2 + (by & 0xFF);
        byte[] byArray = rawbytes;
        int n3 = 5;
        int n4 = 5 + payloadLength;
        int n5 = 0;
        byte[] payload = ArraysKt.copyOfRange(byArray, n3, n4);
        byte[] byArray3 = rawbytes;
        n4 = 5 + payloadLength;
        n5 = 5 + payloadLength + signatureLength;
        boolean bl2 = false;
        byte[] signature2 = ArraysKt.copyOfRange(byArray3, n4, n5);
        JSONObject jSONObject = event.getValidKeys();
        JSONArray jSONArray2 = jSONArray = jSONObject == null ? null : jSONObject.optJSONArray("pretix_sig1");
        if (jSONArray == null) {
            return null;
        }
        int n6 = 0;
        JSONArray validKeys = jSONArray;
        int n7 = validKeys.length();
        if (n6 < n7) {
            do {
                int vki = n6++;
                String vk = validKeys.getString(vki);
                Intrinsics.checkNotNullExpressionValue(vk, "vk");
                Object object = vk;
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset()");
                boolean bl3 = false;
                byte[] byArray4 = ((String)object).getBytes(charset);
                Intrinsics.checkNotNullExpressionValue(byArray4, "(this as java.lang.String).getBytes(charset)");
                byte[] byArray5 = Base64.decodeBase64(byArray4);
                Intrinsics.checkNotNullExpressionValue(byArray5, "decodeBase64(vk.toByteAr\u2026harset.defaultCharset()))");
                object = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue(object, "defaultCharset()");
                boolean bl4 = false;
                bl3 = false;
                if (!eu.pretix.libpretixsync.crypto.UtilsKt.isValidSignature(payload, signature2, eu.pretix.libpretixsync.crypto.UtilsKt.readPubkeyFromPem(new String(byArray5, (Charset)object)))) continue;
                TicketProtos.Ticket ticket = TicketProtos.Ticket.parseFrom(payload);
                object = ticket.getSeed();
                Intrinsics.checkNotNullExpressionValue(object, "ticket.seed");
                return new SignedTicketData((String)object, ticket.getItem(), ticket.getVariation(), ticket.getSubevent(), ticket.hasValidFromUnixTime() && ticket.getValidFromUnixTime() > 0L ? new DateTime(ticket.getValidFromUnixTime() * (long)1000) : null, ticket.hasValidUntilUnixTime() && ticket.getValidUntilUnixTime() > 0L ? new DateTime(ticket.getValidUntilUnixTime() * (long)1000) : null);
            } while (n6 < n7);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final TicketCheckProvider.CheckResult checkOfflineWithoutData(Map<String, Long> eventsAndCheckinLists, String ticketid, TicketCheckProvider.CheckInType type, List<Answer> answers) {
        block51: {
            block48: {
                block50: {
                    block49: {
                        dt = this.now();
                        events = ((Result)this.dataStore.select(Event.class, new QueryAttribute[0]).where((Condition)Event.SLUG.in(CollectionsKt.toList((Iterable)eventsAndCheckinLists.keySet()))).get()).toList();
                        decoded = null;
                        event = null;
                        for (Event e : events) {
                            Intrinsics.checkNotNullExpressionValue(e, "e");
                            decoded = this.decodePretixSig1(e, ticketid);
                            event = e;
                            if (decoded == null) continue;
                        }
                        if (decoded == null || event == null) {
                            firstentry = (Map.Entry)CollectionsKt.first((Iterable)eventsAndCheckinLists.entrySet());
                            AsyncCheckProvider.storeFailedCheckin$default(this, (String)firstentry.getKey(), ((Number)firstentry.getValue()).longValue(), "invalid", ticketid, type, null, null, null, null, 480, null);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID);
                        }
                        var11_12 = eventsAndCheckinLists.get(event.slug);
                        if (var11_12 == null) {
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Check-in list not set for event");
                        }
                        listId = var11_12;
                        eventSlug = event.slug;
                        var13_13 = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)eventSlug))).get()).firstOrNull();
                        if (var13_13 == null) {
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Check-in list not found");
                        }
                        list = var13_13;
                        is_revoked = (Integer)((Scalar)this.dataStore.count(RevokedTicketSecret.class).where((Condition)RevokedTicketSecret.SECRET.eq((Object)ticketid)).get()).value();
                        Intrinsics.checkNotNullExpressionValue(is_revoked, "is_revoked");
                        if (is_revoked > 0) {
                            Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                            AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "revoked", ticketid, type, null, null, null, null, 480, null);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.REVOKED);
                        }
                        is_blocked = (Integer)((Scalar)((WhereAndOr)this.dataStore.count(BlockedTicketSecret.class).where((Condition)BlockedTicketSecret.SECRET.eq((Object)ticketid)).and((Condition)BlockedTicketSecret.BLOCKED.eq((Object)true))).get()).value();
                        Intrinsics.checkNotNullExpressionValue(is_blocked, "is_blocked");
                        if (is_blocked > 0) {
                            Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                            AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "blocked", ticketid, type, null, null, null, null, 480, null);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.BLOCKED);
                        }
                        if (type != TicketCheckProvider.CheckInType.EXIT) {
                            var15_16 = decoded.getValidFrom();
                            if (var15_16 == null ? false : var15_16.isAfter(this.now()) == true) {
                                Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                                AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "invalid_time", ticketid, type, null, decoded.getItem(), decoded.getVariation(), decoded.getSubevent(), 32, null);
                                return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID_TIME);
                            }
                            var15_16 = decoded.getValidUntil();
                            if (var15_16 == null ? false : var15_16.isBefore(this.now()) == true) {
                                Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                                AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "invalid_time", ticketid, type, null, decoded.getItem(), decoded.getVariation(), decoded.getSubevent(), 32, null);
                                return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID_TIME);
                            }
                        }
                        if (!list.all_items) {
                            v0 = this.dataStore.count(CheckInList_Item.class).leftJoin(Item.class);
                            var16_17 = Item.ID;
                            Intrinsics.checkNotNullExpressionValue(var16_17, "ID");
                            v1 = is_in_list = (Integer)((Scalar)((WhereAndOr)v0.on((Condition)CheckInList_Item.ITEM_ID.eq(var16_17)).where((Condition)Item.SERVER_ID.eq((Object)decoded.getItem())).and((Condition)CheckInList_Item.CHECK_IN_LIST_ID.eq((Object)list.getId()))).get()).value();
                            var16_18 = false;
                            if (v1 != null && v1.intValue() == 0) {
                                Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                                AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "product", ticketid, type, null, null, null, decoded.getSubevent(), 224, null);
                                return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.PRODUCT);
                            }
                        }
                        if (list.getSubevent_id() != null) {
                            is_in_list = list.getSubevent_id();
                            Intrinsics.checkNotNullExpressionValue(is_in_list, "list.getSubevent_id()");
                            if (((Number)is_in_list).longValue() > 0L && !Intrinsics.areEqual(list.getSubevent_id(), decoded.getSubevent())) {
                                Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                                AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "invalid", ticketid, type, null, null, null, null, 480, null);
                                return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID);
                            }
                        }
                        if ((item = (Item)((Result)((WhereAndOr)this.dataStore.select(Item.class, new QueryAttribute[0]).where((Condition)Item.SERVER_ID.eq((Object)decoded.getItem())).and((Condition)Item.EVENT_SLUG.eq((Object)eventSlug))).get()).firstOrNull()) == null) {
                            Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                            AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "product", ticketid, type, null, null, null, decoded.getSubevent(), 224, null);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Item not found");
                        }
                        res = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR);
                        res.setScanType(type);
                        res.setTicket(item.getInternalName());
                        if (decoded.getVariation() == null) ** GOTO lbl-1000
                        v2 = decoded.getVariation();
                        Intrinsics.checkNotNull(v2);
                        if (v2 > 0L) {
                            try {
                                var18_20 = item.getVariation(decoded.getVariation());
                                var18_20 = var18_20 == null ? null : var18_20;
                            }
                            catch (JSONException e) {
                                this.sentry.captureException(e);
                                var18_20 = null;
                            }
                            v3 = var18_20;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = variation = (ItemVariation)null;
                        }
                        if (variation != null) {
                            res.setVariation(variation.getStringValue());
                        }
                        require_attention = false;
                        try {
                            require_attention = item.getJSON().optBoolean("checkin_attention", false);
                        }
                        catch (JSONException e) {
                            this.sentry.captureException(e);
                        }
                        res.setRequireAttention(require_attention != false || ((e = variation) == null ? false : e.isCheckin_attention() == true) != false);
                        var20_26 = ((Result)this.dataStore.select(QueuedCheckIn.class, new QueryAttribute[0]).where((Condition)QueuedCheckIn.SECRET.eq((Object)ticketid)).get()).toList();
                        Intrinsics.checkNotNullExpressionValue(var20_26, "dataStore.select(QueuedC\u2026          .get().toList()");
                        $this$filter$iv = (Function1[])var20_26;
                        $i$f$filter = false;
                        var22_30 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$queuedCheckIns$1 = false;
                            v4 = it.getCheckinListId();
                            var29_55 = listId;
                            if (!(v4 != null && v4 == var29_55)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = new Function1[]{checkOfflineWithoutData.queuedCheckIns.2.INSTANCE, checkOfflineWithoutData.queuedCheckIns.3.INSTANCE};
                        queuedCheckIns = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy($this$filter$iv));
                        rules = list.getRules();
                        if (type != TicketCheckProvider.CheckInType.ENTRY || rules == null || rules.length() <= 0) break block49;
                        $this$filterTo$iv$iv = false;
                        data = new LinkedHashMap<K, V>();
                        tz = DateTimeZone.forID(event.getTimezone());
                        $i$f$filterTo = decoded.getSubevent();
                        v5 = $i$f$filterTo == null ? 0L : $i$f$filterTo.longValue();
                        Intrinsics.checkNotNullExpressionValue(tz, "tz");
                        jsonLogic = this.initJsonLogic(event, v5, tz);
                        data.put("product", String.valueOf(item.getServer_id()));
                        if (decoded.getVariation() == null) ** GOTO lbl-1000
                        v6 = decoded.getVariation();
                        Intrinsics.checkNotNull(v6);
                        if (v6 > 0L) {
                            v7 = String.valueOf(decoded.getVariation());
                        } else lbl-1000:
                        // 2 sources

                        {
                            v7 = "";
                        }
                        data.put("variation", v7);
                        data.put("now", dt);
                        data.put("now_isoweekday", dt.withZone(tz).dayOfWeek().get());
                        $i$f$filterTo = queuedCheckIns;
                        var35_63 = "entries_number";
                        var34_64 = data;
                        $i$f$filter = false;
                        element$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$1 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var36_72 = (List)destination$iv$iv /* !! */ ;
                        var34_64.put(var35_63, var36_72.size());
                        $this$filter$iv = queuedCheckIns;
                        var35_63 = "entries_today";
                        var34_64 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$2 = false;
                            if (!(Intrinsics.areEqual(new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate(), dt.withZone(tz).toLocalDate()) != false && Intrinsics.areEqual(it.type, "entry") != false)) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var36_72 = (List)destination$iv$iv /* !! */ ;
                        var34_64.put(var35_63, var36_72.size());
                        $this$filter$iv = queuedCheckIns;
                        var35_63 = "entries_days";
                        var34_64 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$3 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var36_72 = (List)destination$iv$iv /* !! */ ;
                        $this$filter$iv = var36_72;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        for (Iterator<T> item$iv$iv : $this$mapTo$iv$iv) {
                            it = (QueuedCheckIn)item$iv$iv;
                            var36_72 = destination$iv$iv /* !! */ ;
                            $i$a$-map-AsyncCheckProvider$checkOfflineWithoutData$4 = false;
                            var37_73 = new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate();
                            var36_72.add(var37_73);
                        }
                        var36_72 = (List)destination$iv$iv /* !! */ ;
                        var34_64.put(var35_63, CollectionsKt.toHashSet((Iterable)var36_72).size());
                        $this$filter$iv = queuedCheckIns;
                        $i$f$filter = false;
                        destination$iv$iv /* !! */  = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        item$iv$iv = $this$filterTo$iv$iv.iterator();
                        while (item$iv$iv.hasNext()) {
                            element$iv$iv = item$iv$iv.next();
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$minutes_since_entries$1 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        item$iv$iv = $this$mapTo$iv$iv.iterator();
                        while (item$iv$iv.hasNext()) {
                            item$iv$iv = item$iv$iv.next();
                            it = (QueuedCheckIn)item$iv$iv;
                            var34_64 = destination$iv$iv;
                            $i$a$-map-AsyncCheckProvider$checkOfflineWithoutData$minutes_since_entries$2 = false;
                            var35_63 = new Duration(new DateTime(it.getFullDatetime()).withZone(tz), dt).toStandardMinutes().getMinutes();
                            var34_64.add(var35_63);
                        }
                        minutes_since_entries = (List)destination$iv$iv;
                        $this$map$iv = (Integer)CollectionsKt.minOrNull(minutes_since_entries);
                        data.put("minutes_since_last_entry", $this$map$iv == null ? -1 : $this$map$iv.intValue());
                        $this$map$iv = (Integer)CollectionsKt.maxOrNull(minutes_since_entries);
                        data.put("minutes_since_first_entry", $this$map$iv == null ? -1 : $this$map$iv.intValue());
                        if (!UtilsKt.getTruthy(jsonLogic.applyString(rules.toString(), data, true))) {
                            res.setType(TicketCheckProvider.CheckResult.Type.RULES);
                            res.setCheckinAllowed(false);
                            Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                            AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "rules", ticketid, type, null, decoded.getItem(), decoded.getVariation(), decoded.getSubevent(), 32, null);
                            return res;
                        }
                    }
                    questions = item.getQuestions();
                    jsonLogic = false;
                    answerMap = new LinkedHashMap<K, V>();
                    if (answers != null) {
                        for (Answer a : answers) {
                            $this$map$iv = answerMap;
                            $i$f$map = ((Question)a.getQuestion()).getServer_id();
                            Intrinsics.checkNotNullExpressionValue($i$f$map, "a.question as Question).getServer_id()");
                            $this$mapTo$iv$iv = a.getValue();
                            destination$iv$iv = false;
                            $this$map$iv.put($i$f$map, $this$mapTo$iv$iv);
                        }
                    }
                    givenAnswers = new JSONArray();
                    required_answers = new ArrayList<E>();
                    ask_questions = false;
                    if (type != TicketCheckProvider.CheckInType.EXIT) {
                        for (Question q : questions) {
                            if (!q.isAskDuringCheckin()) continue;
                            answer = "";
                            if (answerMap.containsKey(q.getServer_id())) {
                                answer = (String)answerMap.get(q.getServer_id());
                                try {
                                    answer = q.clean_answer(answer, q.getOptions());
                                    jo = new JSONObject();
                                    jo.put("answer", answer);
                                    item$iv$iv = q.getServer_id();
                                    Intrinsics.checkNotNullExpressionValue(item$iv$iv, "q.getServer_id()");
                                    jo.put("question", ((Number)item$iv$iv).longValue());
                                    givenAnswers.put(jo);
                                }
                                catch (QuestionLike.ValidationException e) {
                                    answer = "";
                                    ask_questions = true;
                                }
                                catch (JSONException e) {
                                    answer = "";
                                    ask_questions = true;
                                }
                            } else {
                                ask_questions = true;
                            }
                            Intrinsics.checkNotNullExpressionValue(q, "q");
                            required_answers.add(new TicketCheckProvider.RequiredAnswer(q, answer));
                        }
                    }
                    if (!ask_questions || required_answers.size() <= 0) break block50;
                    res.setCheckinAllowed(true);
                    res.setType(TicketCheckProvider.CheckResult.Type.ANSWERS_REQUIRED);
                    res.setRequiredAnswers(required_answers);
                    break block51;
                }
                if (type == TicketCheckProvider.CheckInType.EXIT || list.isAllowMultipleEntries() || queuedCheckIns.isEmpty()) ** GOTO lbl-1000
                $this$all$iv = queuedCheckIns;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v8 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (QueuedCheckIn)element$iv;
                        $i$a$-all-AsyncCheckProvider$checkOfflineWithoutData$entry_allowed$1 = false;
                        if (Intrinsics.areEqual(it.type, "exit")) continue;
                        v8 = false;
                        break block48;
                    }
                    v8 = true;
                }
            }
            if (v8 || list.isAllowEntryAfterExit() && Intrinsics.areEqual(((QueuedCheckIn)CollectionsKt.last(queuedCheckIns)).type, "exit")) lbl-1000:
            // 2 sources

            {
                v9 = true;
            } else {
                v9 = entry_allowed = false;
            }
            if (!entry_allowed) {
                res.setCheckinAllowed(false);
                res.setFirstScanned(((QueuedCheckIn)CollectionsKt.first(queuedCheckIns)).getFullDatetime());
                res.setType(TicketCheckProvider.CheckResult.Type.USED);
                Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "already_redeemed", ticketid, type, null, decoded.getItem(), decoded.getVariation(), decoded.getSubevent(), 32, null);
            } else {
                res.setCheckinAllowed(true);
                res.setType(TicketCheckProvider.CheckResult.Type.VALID);
                qci = new QueuedCheckIn();
                qci.generateNonce();
                qci.setSecret(ticketid);
                qci.setDatetime(dt.toDate());
                qci.setDatetime_string(QueuedCheckIn.formatDatetime(dt.toDate()));
                qci.setAnswers(givenAnswers.toString());
                qci.setEvent_slug(eventSlug);
                var28_54 = type.toString();
                var29_62 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(var29_62, "getDefault()");
                var30_66 = false;
                v10 = var28_54;
                if (v10 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v11 = v10.toLowerCase(var29_62);
                Intrinsics.checkNotNullExpressionValue(v11, "(this as java.lang.String).toLowerCase(locale)");
                qci.setType(v11);
                qci.setCheckinListId(listId);
                this.dataStore.insert(qci);
            }
        }
        return res;
    }

    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String ticketid) {
        Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
        Intrinsics.checkNotNullParameter(ticketid, "ticketid");
        return this.check(eventsAndCheckinLists, ticketid, new ArrayList(), false, true, TicketCheckProvider.CheckInType.ENTRY);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String ticketid, @Nullable List<Answer> answers, boolean ignore_unpaid, boolean with_badge_data, @NotNull TicketCheckProvider.CheckInType type) {
        block65: {
            block63: {
                block64: {
                    Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
                    Intrinsics.checkNotNullParameter(ticketid, "ticketid");
                    Intrinsics.checkNotNullParameter((Object)type, "type");
                    this.sentry.addBreadcrumb("provider.check", "offline check started");
                    dt = this.now();
                    v0 = this.dataStore.select(OrderPosition.class, new QueryAttribute[0]).leftJoin(Order.class);
                    var9_8 = OrderPosition.ORDER_ID;
                    Intrinsics.checkNotNullExpressionValue(var9_8, "ORDER_ID");
                    tickets = ((Result)((WhereAndOr)v0.on((Condition)Order.ID.eq((Expression)var9_8)).where((Condition)OrderPosition.SECRET.eq((Object)ticketid)).and((Condition)Order.EVENT_SLUG.in(CollectionsKt.toList((Iterable)eventsAndCheckinLists.keySet())))).get()).toList();
                    if (tickets.size() == 0) {
                        var9_8 = answers;
                        return this.checkOfflineWithoutData(eventsAndCheckinLists, ticketid, type, (List<Answer>)(var9_8 == null ? CollectionsKt.emptyList() : var9_8));
                    }
                    if (tickets.size() > 1) {
                        eventSlug = ((OrderPosition)tickets.get(0)).getOrder().getEvent_slug();
                        Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                        var10_10 = eventsAndCheckinLists.get(eventSlug);
                        if (var10_10 == null) {
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "No check-in list selected");
                        }
                        this.storeFailedCheckin(eventSlug, var10_10, "ambiguous", ticketid, type, ((OrderPosition)tickets.get(0)).getServer_id(), ((OrderPosition)tickets.get(0)).getItem().getServer_id(), ((OrderPosition)tickets.get(0)).getVariation_id(), ((OrderPosition)tickets.get(0)).getSubevent_id());
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.AMBIGUOUS);
                    }
                    eventSlug = ((OrderPosition)tickets.get(0)).getOrder().getEvent_slug();
                    var11_12 = (Event)((Result)this.dataStore.select(Event.class, new QueryAttribute[0]).where((Condition)Event.SLUG.eq((Object)eventSlug)).get()).firstOrNull();
                    if (var11_12 == null) {
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Event not found");
                    }
                    event = var11_12;
                    var13_14 = eventsAndCheckinLists.get(eventSlug);
                    if (var13_14 == null) {
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "No check-in list selected");
                    }
                    listId = var13_14;
                    var14_15 = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)eventSlug))).get()).firstOrNull();
                    if (var14_15 == null) {
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Check-in list not found");
                    }
                    list = var14_15;
                    if (list.isAddonMatch()) {
                        var16_16 /* !! */  = new OrderPosition[]{(OrderPosition)tickets.get(0)};
                        candidates = CollectionsKt.mutableListOf(var16_16 /* !! */ );
                        var16_16 /* !! */  = ((OrderPosition)tickets.get(0)).getOrder().getPositions();
                        Intrinsics.checkNotNullExpressionValue(var16_16 /* !! */ , "tickets[0].getOrder().getPositions()");
                        var16_16 /* !! */  = (Iterable)var16_16 /* !! */ ;
                        var38_18 = candidates;
                        $i$f$filter = false;
                        var18_24 = $this$filter$iv;
                        destination$iv$iv = (Expression[])new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (OrderPosition)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$check$position$1 = false;
                            if (!Intrinsics.areEqual(it.getAddonToId(), ((OrderPosition)tickets.get(0)).getServer_id())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        var39_46 = (List)destination$iv$iv;
                        var38_18.addAll((Collection)var39_46);
                        if (!list.all_items) {
                            destination$iv$iv = new Expression[]{CheckInList_Item.ITEM_ID};
                            $this$filterTo$iv$iv = ((Result)this.dataStore.select(destination$iv$iv).where((Condition)CheckInList_Item.CHECK_IN_LIST_ID.eq((Object)list.getId())).get()).toList();
                            Intrinsics.checkNotNullExpressionValue($this$filterTo$iv$iv, "dataStore.select(CheckIn\u2026          .get().toList()");
                            $this$map$iv = $this$filterTo$iv$iv;
                            $i$f$map = false;
                            $i$f$filterTo = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            $i$f$mapTo = false;
                            it = $this$mapTo$iv$iv.iterator();
                            while (it.hasNext()) {
                                item$iv$iv = it.next();
                                var25_47 = (Tuple)item$iv$iv;
                                var38_18 = destination$iv$iv;
                                $i$a$-map-AsyncCheckProvider$check$position$filteredCandidates$items$1 = false;
                                var39_46 = (Long)it.get(0);
                                var38_18.add(var39_46);
                            }
                            items = CollectionsKt.toHashSet((List)destination$iv$iv);
                            $this$filter$iv = candidates;
                            $i$f$filter = false;
                            $this$mapTo$iv$iv = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                candidate = (OrderPosition)element$iv$iv;
                                $i$a$-filter-AsyncCheckProvider$check$position$filteredCandidates$1 = false;
                                if (!items.contains(candidate.getItem().getId())) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            v1 = (List)destination$iv$iv;
                        } else {
                            v1 = filteredCandidates = candidates;
                        }
                        if (filteredCandidates.isEmpty()) {
                            Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                            items = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue(items, "list.getServer_id()");
                            this.storeFailedCheckin(eventSlug, ((Number)items).longValue(), "product", ticketid, type, ((OrderPosition)tickets.get(0)).getServer_id(), ((OrderPosition)tickets.get(0)).getItem().getServer_id(), ((OrderPosition)tickets.get(0)).getVariation_id(), ((OrderPosition)tickets.get(0)).getSubevent_id());
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.PRODUCT);
                        }
                        if (filteredCandidates.size() > 1) {
                            Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                            items = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue(items, "list.getServer_id()");
                            this.storeFailedCheckin(eventSlug, ((Number)items).longValue(), "ambiguous", ticketid, type, ((OrderPosition)tickets.get(0)).getServer_id(), ((OrderPosition)tickets.get(0)).getItem().getServer_id(), ((OrderPosition)tickets.get(0)).getVariation_id(), ((OrderPosition)tickets.get(0)).getSubevent_id());
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.AMBIGUOUS);
                        }
                        v2 = filteredCandidates.get(0);
                    } else {
                        v2 = (OrderPosition)tickets.get(0);
                    }
                    position = v2;
                    item = position.getItem();
                    order = position.getOrder();
                    jPosition = null;
                    try {
                        $this$filter$iv = position.getJSON();
                        Intrinsics.checkNotNullExpressionValue($this$filter$iv, "{\n            position.json\n        }");
                    }
                    catch (JSONException e) {
                        this.sentry.captureException(e);
                        Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                        $this$filterTo$iv$iv = list.getServer_id();
                        Intrinsics.checkNotNullExpressionValue($this$filterTo$iv$iv, "list.getServer_id()");
                        this.storeFailedCheckin(eventSlug, ((Number)$this$filterTo$iv$iv).longValue(), "error", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR);
                    }
                    jPosition = $this$filter$iv;
                    res = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR);
                    res.setScanType(type);
                    res.setTicket(position.getItem().getInternalName());
                    varid = position.getVariationId();
                    if (varid != null) {
                        try {
                            destination$iv$iv = item.getVariation(varid);
                        }
                        catch (JSONException e) {
                            this.sentry.captureException(e);
                            destination$iv$iv = null;
                        }
                        v3 = destination$iv$iv;
                    } else {
                        v3 = variation = (ItemVariation)null;
                    }
                    if (variation != null) {
                        res.setVariation(variation.getStringValue());
                    }
                    res.setAttendee_name(position.attendee_name);
                    res.setSeat(position.getSeatName());
                    res.setOrderCode(position.getOrder().getCode());
                    res.setPositionId(position.getPositionid());
                    res.setPosition(jPosition);
                    res.setEventSlug(list.event_slug);
                    require_attention = position.getOrder().isCheckin_attention();
                    try {
                        require_attention = require_attention != false || item.getJSON().optBoolean("checkin_attention", false) != false;
                    }
                    catch (JSONException e) {
                        this.sentry.captureException(e);
                    }
                    res.setRequireAttention(require_attention != false || ((e = variation) == null ? false : e.isCheckin_attention() == true) != false);
                    storedCheckIns = ((Result)this.dataStore.select(CheckIn.class, new QueryAttribute[0]).where((Condition)CheckIn.POSITION_ID.eq(position.getId())).get()).toList();
                    Intrinsics.checkNotNullExpressionValue(storedCheckIns, "storedCheckIns");
                    $this$filter$iv /* !! */  = (Function1[])storedCheckIns;
                    $i$f$filter = false;
                    $i$a$-filter-AsyncCheckProvider$check$position$filteredCandidates$1 = $this$filter$iv /* !! */ ;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    var29_63 = $this$filterTo$iv$iv.iterator();
                    while (var29_63.hasNext()) {
                        element$iv$iv = var29_63.next();
                        it = (CheckIn)element$iv$iv;
                        $i$a$-filter-AsyncCheckProvider$check$checkIns$1 = false;
                        v4 = it.getListId();
                        var33_78 = listId;
                        if (!(v4 != null && v4 == var33_78)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv /* !! */  = new Function1[]{check.checkIns.2.INSTANCE, check.checkIns.3.INSTANCE};
                    checkIns = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy($this$filter$iv /* !! */ ));
                    if (!Intrinsics.areEqual(order.getStatus(), "p") && !Intrinsics.areEqual(order.getStatus(), "n")) {
                        res.setType(TicketCheckProvider.CheckResult.Type.CANCELED);
                        res.setCheckinAllowed(false);
                        Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                        $this$filter$iv /* !! */  = list.getServer_id();
                        Intrinsics.checkNotNullExpressionValue($this$filter$iv /* !! */ , "list.getServer_id()");
                        this.storeFailedCheckin(eventSlug, ((Number)$this$filter$iv /* !! */ ).longValue(), "canceled", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                        return res;
                    }
                    if (position.isBlocked()) {
                        res.setType(TicketCheckProvider.CheckResult.Type.BLOCKED);
                        res.setCheckinAllowed(false);
                        Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                        $this$filter$iv /* !! */  = list.getServer_id();
                        Intrinsics.checkNotNullExpressionValue($this$filter$iv /* !! */ , "list.getServer_id()");
                        this.storeFailedCheckin(eventSlug, ((Number)$this$filter$iv /* !! */ ).longValue(), "blocked", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                        return res;
                    }
                    if (type != TicketCheckProvider.CheckInType.EXIT) {
                        validFrom = position.getValidFrom();
                        if (validFrom != null && validFrom.isAfter(this.now())) {
                            res.setType(TicketCheckProvider.CheckResult.Type.INVALID_TIME);
                            res.setCheckinAllowed(false);
                            Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                            $i$f$filter = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue($i$f$filter, "list.getServer_id()");
                            this.storeFailedCheckin(eventSlug, ((Number)$i$f$filter).longValue(), "invalid_time", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                            return res;
                        }
                        validUntil = position.getValidUntil();
                        if (validUntil != null && validUntil.isBefore(this.now())) {
                            res.setType(TicketCheckProvider.CheckResult.Type.INVALID_TIME);
                            res.setCheckinAllowed(false);
                            Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                            $this$filterTo$iv$iv = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue($this$filterTo$iv$iv, "list.getServer_id()");
                            this.storeFailedCheckin(eventSlug, ((Number)$this$filterTo$iv$iv).longValue(), "invalid_time", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                            return res;
                        }
                    }
                    if (!list.all_items) {
                        v5 = is_in_list = (Integer)((Scalar)((WhereAndOr)this.dataStore.count(CheckInList_Item.class).where((Condition)CheckInList_Item.ITEM_ID.eq((Object)item.getId())).and((Condition)CheckInList_Item.CHECK_IN_LIST_ID.eq((Object)list.getId()))).get()).value();
                        validUntil = false;
                        if (v5 != null && v5.intValue() == 0) {
                            Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                            validUntil = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue(validUntil, "list.getServer_id()");
                            this.storeFailedCheckin(eventSlug, ((Number)validUntil).longValue(), "product", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.PRODUCT);
                        }
                    }
                    if (list.getSubevent_id() != null) {
                        is_in_list = list.getSubevent_id();
                        Intrinsics.checkNotNullExpressionValue(is_in_list, "list.getSubevent_id()");
                        if (((Number)is_in_list).longValue() > 0L && !Intrinsics.areEqual(list.getSubevent_id(), position.getSubeventId())) {
                            Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                            is_in_list = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue(is_in_list, "list.getServer_id()");
                            this.storeFailedCheckin(eventSlug, is_in_list.longValue(), "invalid", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID);
                        }
                    }
                    if (!Intrinsics.areEqual(order.status, "p") && order.isRequireApproval()) {
                        res.setType(TicketCheckProvider.CheckResult.Type.UNPAID);
                        res.setCheckinAllowed(false);
                        Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                        is_in_list = list.getServer_id();
                        Intrinsics.checkNotNullExpressionValue(is_in_list, "list.getServer_id()");
                        this.storeFailedCheckin(eventSlug, is_in_list.longValue(), "unpaid", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                        return res;
                    }
                    if (!(order.isValidStatus() || ignore_unpaid && list.include_pending)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.UNPAID);
                        res.setCheckinAllowed(list.include_pending != false && order.isValid_if_pending() == false);
                        Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                        is_in_list = list.getServer_id();
                        Intrinsics.checkNotNullExpressionValue(is_in_list, "list.getServer_id()");
                        this.storeFailedCheckin(eventSlug, is_in_list.longValue(), "unpaid", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                        return res;
                    }
                    rules = list.getRules();
                    if (type == TicketCheckProvider.CheckInType.ENTRY && rules != null && rules.length() > 0) {
                        $this$filterTo$iv$iv = false;
                        data = new LinkedHashMap<K, V>();
                        tz = DateTimeZone.forID(event.getTimezone());
                        $i$f$filterTo = position.getSubevent_id();
                        Intrinsics.checkNotNullExpressionValue($i$f$filterTo, "position.getSubevent_id()");
                        v6 = ((Number)$i$f$filterTo).longValue();
                        Intrinsics.checkNotNullExpressionValue(tz, "tz");
                        jsonLogic = this.initJsonLogic(event, v6, tz);
                        data.put("product", String.valueOf(position.getItem().getServer_id()));
                        data.put("variation", String.valueOf(position.getVariation_id()));
                        data.put("now", dt);
                        data.put("now_isoweekday", dt.withZone(tz).dayOfWeek().get());
                        $i$f$filterTo = checkIns;
                        var39_46 = "entries_number";
                        var38_18 = data;
                        $i$f$filter = false;
                        element$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$check$1 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var40_95 = (List)destination$iv$iv /* !! */ ;
                        var38_18.put(var39_46, var40_95.size());
                        $this$filter$iv = checkIns;
                        var39_46 = "entries_today";
                        var38_18 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$check$2 = false;
                            if (!(Intrinsics.areEqual(new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate(), dt.withZone(tz).toLocalDate()) != false && Intrinsics.areEqual(it.type, "entry") != false)) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var40_95 = (List)destination$iv$iv /* !! */ ;
                        var38_18.put(var39_46, var40_95.size());
                        $this$filter$iv = checkIns;
                        var39_46 = "entries_days";
                        var38_18 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$check$3 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var40_95 = (List)destination$iv$iv /* !! */ ;
                        $this$filter$iv = var40_95;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        for (Iterator<T> item$iv$iv : $this$mapTo$iv$iv) {
                            it = (CheckIn)item$iv$iv;
                            var40_95 = destination$iv$iv /* !! */ ;
                            $i$a$-map-AsyncCheckProvider$check$4 = false;
                            var41_96 = new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate();
                            var40_95.add(var41_96);
                        }
                        var40_95 = (List)destination$iv$iv /* !! */ ;
                        var38_18.put(var39_46, CollectionsKt.toHashSet((Iterable)var40_95).size());
                        $this$filter$iv = checkIns;
                        $i$f$filter = false;
                        destination$iv$iv /* !! */  = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        item$iv$iv = $this$filterTo$iv$iv.iterator();
                        while (item$iv$iv.hasNext()) {
                            element$iv$iv = item$iv$iv.next();
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$check$minutes_since_entries$1 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        item$iv$iv = $this$mapTo$iv$iv.iterator();
                        while (item$iv$iv.hasNext()) {
                            item$iv$iv = item$iv$iv.next();
                            it = (CheckIn)item$iv$iv;
                            var38_18 = destination$iv$iv;
                            $i$a$-map-AsyncCheckProvider$check$minutes_since_entries$2 = false;
                            var39_46 = new Duration(new DateTime(it.getFullDatetime()).withZone(tz), dt).toStandardMinutes().getMinutes();
                            var38_18.add(var39_46);
                        }
                        minutes_since_entries = (List)destination$iv$iv;
                        $this$map$iv = (Integer)CollectionsKt.minOrNull(minutes_since_entries);
                        data.put("minutes_since_last_entry", $this$map$iv == null ? -1 : $this$map$iv.intValue());
                        $this$map$iv = (Integer)CollectionsKt.maxOrNull(minutes_since_entries);
                        data.put("minutes_since_first_entry", $this$map$iv == null ? -1 : $this$map$iv.intValue());
                        if (!UtilsKt.getTruthy(jsonLogic.applyString(rules.toString(), data, true))) {
                            res.setType(TicketCheckProvider.CheckResult.Type.RULES);
                            res.setCheckinAllowed(false);
                            Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                            $this$map$iv = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue($this$map$iv, "list.getServer_id()");
                            this.storeFailedCheckin(eventSlug, ((Number)$this$map$iv).longValue(), "rules", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                            return res;
                        }
                    }
                    questions = item.getQuestions();
                    answerMap = position.getAnswers();
                    if (answers != null) {
                        for (Answer a : answers) {
                            Intrinsics.checkNotNullExpressionValue(answerMap, "answerMap");
                            $this$map$iv = answerMap;
                            $i$f$map = ((Question)a.getQuestion()).getServer_id();
                            $this$mapTo$iv$iv = a.getValue();
                            destination$iv$iv = false;
                            $this$map$iv.put((Long)$i$f$map, (String)$this$mapTo$iv$iv);
                        }
                    }
                    givenAnswers = new JSONArray();
                    required_answers = new ArrayList<E>();
                    ask_questions = false;
                    if (type != TicketCheckProvider.CheckInType.EXIT) {
                        for (Question q : questions) {
                            if (!q.isAskDuringCheckin()) continue;
                            answer = "";
                            if (answerMap.containsKey(q.getServer_id())) {
                                answer = answerMap.get(q.getServer_id());
                                try {
                                    answer = q.clean_answer(answer, q.getOptions());
                                    jo = new JSONObject();
                                    jo.put("answer", answer);
                                    item$iv$iv = q.getServer_id();
                                    Intrinsics.checkNotNullExpressionValue(item$iv$iv, "q.getServer_id()");
                                    jo.put("question", ((Number)item$iv$iv).longValue());
                                    givenAnswers.put(jo);
                                }
                                catch (QuestionLike.ValidationException e) {
                                    answer = "";
                                    ask_questions = true;
                                }
                                catch (JSONException e) {
                                    answer = "";
                                    ask_questions = true;
                                }
                            } else {
                                ask_questions = true;
                            }
                            Intrinsics.checkNotNullExpressionValue(q, "q");
                            required_answers.add(new TicketCheckProvider.RequiredAnswer(q, answer));
                        }
                    }
                    if (!ask_questions || required_answers.size() <= 0) break block64;
                    res.setCheckinAllowed(true);
                    res.setType(TicketCheckProvider.CheckResult.Type.ANSWERS_REQUIRED);
                    res.setRequiredAnswers(required_answers);
                    break block65;
                }
                if (type == TicketCheckProvider.CheckInType.EXIT || list.isAllowMultipleEntries() || checkIns.isEmpty()) ** GOTO lbl-1000
                $this$all$iv = checkIns;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v7 = true;
                } else {
                    var33_84 = $this$all$iv.iterator();
                    while (var33_84.hasNext()) {
                        element$iv = var33_84.next();
                        it = (CheckIn)element$iv;
                        $i$a$-all-AsyncCheckProvider$check$entry_allowed$1 = false;
                        if (Intrinsics.areEqual(it.type, "exit")) continue;
                        v7 = false;
                        break block63;
                    }
                    v7 = true;
                }
            }
            if (v7 || list.isAllowEntryAfterExit() && Intrinsics.areEqual(((CheckIn)CollectionsKt.last(checkIns)).type, "exit")) lbl-1000:
            // 2 sources

            {
                v8 = true;
            } else {
                v8 = entry_allowed = false;
            }
            if (!entry_allowed) {
                res.setCheckinAllowed(false);
                res.setFirstScanned(((CheckIn)CollectionsKt.first(checkIns)).getFullDatetime());
                res.setType(TicketCheckProvider.CheckResult.Type.USED);
                Intrinsics.checkNotNullExpressionValue(eventSlug, "eventSlug");
                $this$all$iv = list.getServer_id();
                Intrinsics.checkNotNullExpressionValue($this$all$iv, "list.getServer_id()");
                this.storeFailedCheckin(eventSlug, ((Number)$this$all$iv).longValue(), "already_redeemed", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
            } else {
                res.setCheckinAllowed(true);
                res.setType(TicketCheckProvider.CheckResult.Type.VALID);
                qci = new QueuedCheckIn();
                qci.generateNonce();
                qci.setSecret(ticketid);
                qci.setDatetime(dt.toDate());
                qci.setDatetime_string(QueuedCheckIn.formatDatetime(dt.toDate()));
                qci.setAnswers(givenAnswers.toString());
                qci.setEvent_slug(eventSlug);
                $i$f$all = type.toString();
                var33_85 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(var33_85, "getDefault()");
                var34_87 = false;
                v9 = $i$f$all;
                if (v9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v10 = v9.toLowerCase((Locale)var33_85);
                Intrinsics.checkNotNullExpressionValue(v10, "(this as java.lang.String).toLowerCase(locale)");
                qci.setType(v10);
                qci.setCheckinListId(listId);
                this.dataStore.insert(qci);
                ci = new CheckIn();
                ci.setListId(listId);
                ci.setPosition(position);
                var33_85 = type.toString();
                var34_88 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(var34_88, "getDefault()");
                var35_90 = false;
                v11 = var33_85;
                if (v11 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v12 = v11.toLowerCase(var34_88);
                Intrinsics.checkNotNullExpressionValue(v12, "(this as java.lang.String).toLowerCase(locale)");
                ci.setType(v12);
                ci.setDatetime(dt.toDate());
                v13 = new StringBuilder().append("{\"local\": true, \"type\": \"");
                var33_85 = type.toString();
                var34_88 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(var34_88, "getDefault()");
                var35_90 = false;
                v14 = var33_85;
                if (v14 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v15 = v14.toLowerCase(var34_88);
                Intrinsics.checkNotNullExpressionValue(v15, "(this as java.lang.String).toLowerCase(locale)");
                ci.setJson_data(v13.append(v15).append("\", \"datetime\": \"").append((Object)QueuedCheckIn.formatDatetime(dt.toDate())).append("\"}").toString());
                this.dataStore.insert(ci);
            }
        }
        return res;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public List<TicketCheckProvider.SearchResult> search(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String query, int page) throws CheckException {
        Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
        Intrinsics.checkNotNullParameter(query, "query");
        var5_4 = query;
        var6_5 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(var6_5, "getDefault()");
        var7_6 = false;
        v0 = var5_4.toUpperCase(var6_5);
        Intrinsics.checkNotNullExpressionValue(v0, "(this as java.lang.String).toUpperCase(locale)");
        query = v0;
        this.sentry.addBreadcrumb("provider.search", "offline search started");
        results = new ArrayList<E>();
        if (query.length() < 4) {
            return results;
        }
        search = null;
        var7_7 = ((LogicalCondition)((LogicalCondition)((LogicalCondition)OrderPosition.SECRET.upper().like(Intrinsics.stringPlus(query, "%")).or((Condition)OrderPosition.ATTENDEE_NAME.upper().like('%' + query + '%'))).or((Condition)OrderPosition.ATTENDEE_EMAIL.upper().like('%' + query + '%'))).or((Condition)Order.EMAIL.upper().like('%' + query + '%'))).or((Condition)Order.CODE.upper().like(Intrinsics.stringPlus(query, "%")));
        Intrinsics.checkNotNullExpressionValue(var7_7, "SECRET.upper().like(\"$qu\u2026.upper().like(\"$query%\"))");
        search = (LogicalCondition)var7_7;
        listfilters = null;
        for (Map.Entry<String, Long> entry : eventsAndCheckinLists.entrySet()) {
            var11_12 = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)entry.getValue())).and((Condition)CheckInList.EVENT_SLUG.eq((Object)entry.getKey()))).get()).firstOrNull();
            if (var11_12 == null) {
                throw new CheckException("Check-in list not found", null, 2, null);
            }
            list /* !! */  = var11_12;
            listfilter = Order.EVENT_SLUG.eq((Object)entry.getKey());
            if (!list /* !! */ .all_items) {
                itemids = new ArrayList<E>();
                for (Item item : list /* !! */ .getItems()) {
                    var15_16 = item.getId();
                    Intrinsics.checkNotNullExpressionValue(var15_16, "item.getId()");
                    itemids.add(var15_16);
                }
                listfilter = (Logical)Item.ID.in((Collection)itemids).and((Condition)listfilter);
            }
            if (list /* !! */ .getSubevent_id() != null) {
                itemids = list /* !! */ .getSubevent_id();
                Intrinsics.checkNotNullExpressionValue(itemids, "list.getSubevent_id()");
                if (((Number)itemids).longValue() > 0L) {
                    listfilter = (Logical)OrderPosition.SUBEVENT_ID.eq((Object)list /* !! */ .getSubevent_id()).and((Condition)listfilter);
                }
            }
            if (listfilters == null) {
                listfilters = listfilter;
                continue;
            }
            listfilters = (Logical)listfilter.or((Condition)listfilters);
        }
        var8_9 /* !! */  = search.and((Condition)listfilters);
        Intrinsics.checkNotNullExpressionValue(var8_9 /* !! */ , "search.and(listfilters)");
        search = (LogicalCondition)var8_9 /* !! */ ;
        positions = null;
        v1 = this.dataStore.select(OrderPosition.class, new QueryAttribute[0]).leftJoin(Order.class);
        listfilter = OrderPosition.ORDER_ID;
        Intrinsics.checkNotNullExpressionValue(listfilter, "ORDER_ID");
        v2 = v1.on((Condition)Order.ID.eq((Expression)listfilter)).leftJoin(Item.class);
        listfilter = OrderPosition.ITEM_ID;
        Intrinsics.checkNotNullExpressionValue(listfilter, "ITEM_ID");
        list /* !! */  = v2.on((Condition)Item.ID.eq((Expression)listfilter)).where(search).limit(50).offset(50 * (page - 1)).get();
        if (list /* !! */  == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.requery.query.Result<eu.pretix.libpretixsync.db.OrderPosition>");
        }
        var9_10 = ((Result)list /* !! */ ).toList();
        Intrinsics.checkNotNullExpressionValue(var9_10, "dataStore.select(OrderPo\u2026<OrderPosition>).toList()");
        positions = var9_10;
        for (OrderPosition position : positions) {
            item = position.getItem();
            order = position.getOrder();
            sr = new TicketCheckProvider.SearchResult();
            sr.setTicket(item.getInternalName());
            try {
                if (position.getVariationId() == null) ** GOTO lbl-1000
                var15_17 /* !! */  = position.getVariationId();
                Intrinsics.checkNotNullExpressionValue(var15_17 /* !! */ , "position.variationId");
                if (((Number)var15_17 /* !! */ ).longValue() > 0L) {
                    v3 = item.getVariation(position.getVariationId());
                } else lbl-1000:
                // 2 sources

                {
                    v3 = null;
                }
                var15_17 /* !! */  = v3;
            }
            catch (JSONException e) {
                this.sentry.captureException(e);
                var15_17 /* !! */  = null;
            }
            variation = var15_17 /* !! */ ;
            if (variation != null) {
                sr.setVariation(variation.getStringValue());
            }
            sr.setAttendee_name(position.attendee_name);
            sr.setSeat(position.getSeatName());
            sr.setOrderCode(order.getCode());
            sr.setPositionId(position.getPositionid());
            sr.setSecret(position.getSecret());
            queuedCheckIns = ((Number)((Scalar)((WhereAndOr)this.dataStore.count(QueuedCheckIn.class).where((Condition)QueuedCheckIn.SECRET.eq((Object)position.getSecret())).and((Condition)QueuedCheckIn.CHECKIN_LIST_ID.in(CollectionsKt.toList((Iterable)eventsAndCheckinLists.values())))).get()).value()).intValue();
            is_checked_in = queuedCheckIns > 0L;
            for (Object ci : position.getCheckins()) {
                if (!eventsAndCheckinLists.containsValue(ci.getListId())) continue;
                is_checked_in = true;
                break;
            }
            sr.setRedeemed(is_checked_in);
            if (Intrinsics.areEqual(order.getStatus(), "p")) {
                sr.setStatus(TicketCheckProvider.SearchResult.Status.PAID);
            } else if (Intrinsics.areEqual(order.getStatus(), "n")) {
                sr.setStatus(TicketCheckProvider.SearchResult.Status.PENDING);
            } else {
                sr.setStatus(TicketCheckProvider.SearchResult.Status.CANCELED);
            }
            require_attention = position.getOrder().isCheckin_attention();
            try {
                require_attention = require_attention != false || item.getJSON().optBoolean("checkin_attention", false) != false || ((ci = variation) == null ? false : ci.isCheckin_attention() == true) != false;
            }
            catch (JSONException e) {
                this.sentry.captureException(e);
            }
            sr.setRequireAttention(require_attention);
            sr.setPosition(position.getJSON());
            results.add(sr);
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final WhereAndOr<? extends Scalar<Integer>> basePositionQuery(List<? extends CheckInList> lists, boolean onlyCheckedIn) {
        WhereAndOr q = ((DistinctSelection)this.dataStore.count(OrderPosition.class).distinct()).leftJoin(Order.class).on((Condition)OrderPosition.ORDER_ID.eq((Expression)Order.ID)).where((Condition)OrderPosition.SERVER_ID.eq((Object)-1L));
        for (CheckInList checkInList : lists) {
            Object object;
            Object object2;
            Object lq = Order.EVENT_SLUG.eq((Object)checkInList.getEvent_slug());
            if (checkInList.include_pending) {
                object2 = new String[]{"p", "n"};
                lq = (Logical)lq.and((Condition)Order.STATUS.in(CollectionsKt.listOf(object2)));
            } else {
                lq = (Logical)lq.and((Condition)Order.STATUS.eq((Object)"p").or((Condition)Order.STATUS.eq((Object)"n").and((Condition)Order.VALID_IF_PENDING.eq((Object)true))));
            }
            if (checkInList.getSubevent_id() != null) {
                object2 = checkInList.getSubevent_id();
                Intrinsics.checkNotNullExpressionValue(object2, "list.getSubevent_id()");
                if (((Number)object2).longValue() > 0L) {
                    lq = (Logical)lq.and((Condition)OrderPosition.SUBEVENT_ID.eq((Object)checkInList.getSubevent_id()));
                }
            }
            if (!checkInList.isAll_items()) {
                void $this$mapTo$iv$iv;
                Expression[] expressionArray = new Expression[]{CheckInList_Item.ITEM_ID};
                object = ((Result)this.dataStore.select(expressionArray).where((Condition)CheckInList_Item.CHECK_IN_LIST_ID.eq((Object)checkInList.getId())).get()).toList();
                Intrinsics.checkNotNullExpressionValue(object, "dataStore.select(CheckIn\u2026          .get().toList()");
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Tuple tuple = (Tuple)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Long l = (Long)it.get(0);
                    collection.add(l);
                }
                List product_ids = (List)destination$iv$iv;
                object = OrderPosition.ITEM_ID.in(product_ids);
                Intrinsics.checkNotNullExpressionValue(object, "ITEM_ID.`in`(product_ids)");
                lq = (Logical)lq.and((Condition)object);
            }
            if (onlyCheckedIn) {
                object = new Expression[]{CheckIn.POSITION_ID};
                object2 = this.dataStore.select((Expression<?>)object).where((Condition)CheckIn.LIST_ID.eq((Object)checkInList.getServer_id())).and((Condition)CheckIn.TYPE.eq((Object)"entry"));
                Intrinsics.checkNotNullExpressionValue(object2, "dataStore.select(CheckIn\u2026CheckIn.TYPE.eq(\"entry\"))");
                lq = (Logical)lq.and((Condition)OrderPosition.ID.in((Return)object2));
            }
            q = (WhereAndOr)q.or((Condition)lq);
        }
        WhereAndOr whereAndOr = q;
        Intrinsics.checkNotNullExpressionValue(whereAndOr, "q");
        return whereAndOr;
    }

    @Override
    @NotNull
    public TicketCheckProvider.StatusResult status(@NotNull String eventSlug, long listId) throws CheckException {
        List<Item> list;
        List<Item> list2;
        Intrinsics.checkNotNullParameter(eventSlug, "eventSlug");
        this.sentry.addBreadcrumb("provider.status", "offline status started");
        List items = new ArrayList();
        CheckInList checkInList = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)eventSlug))).get()).firstOrNull();
        if (checkInList == null) {
            throw new CheckException("Check-in list not found", null, 2, null);
        }
        CheckInList list3 = checkInList;
        List<Item> products = null;
        if (list3.all_items) {
            list2 = ((Result)this.dataStore.select(Item.class, new QueryAttribute[0]).where((Condition)Item.EVENT_SLUG.eq((Object)eventSlug)).get()).toList();
            Intrinsics.checkNotNullExpressionValue(list2, "{\n            dataStore.\u2026.get().toList()\n        }");
            list = list2;
        } else {
            list2 = list3.getItems();
            Intrinsics.checkNotNullExpressionValue(list2, "{\n            list.items\n        }");
            list = list2;
        }
        products = list;
        int sum_pos = 0;
        int sum_ci = 0;
        for (Item product : products) {
            List variations = new ArrayList();
            try {
                for (ItemVariation var : product.getVariations()) {
                    Object r = ((WhereAndOr)((WhereAndOr)this.basePositionQuery(CollectionsKt.listOf(list3), false).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).and((Condition)OrderPosition.VARIATION_ID.eq((Object)var.getServer_id()))).get();
                    Intrinsics.checkNotNull(r);
                    Object e = ((Scalar)r).value();
                    Intrinsics.checkNotNull(e);
                    int position_count = ((Number)e).intValue();
                    Object r2 = ((WhereAndOr)((WhereAndOr)this.basePositionQuery(CollectionsKt.listOf(list3), true).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).and((Condition)OrderPosition.VARIATION_ID.eq((Object)var.getServer_id()))).get();
                    Intrinsics.checkNotNull(r2);
                    Object e2 = ((Scalar)r2).value();
                    Intrinsics.checkNotNull(e2);
                    int ci_count = ((Number)e2).intValue();
                    Long l = var.getServer_id();
                    Intrinsics.checkNotNullExpressionValue(l, "`var`.server_id");
                    variations.add(new TicketCheckProvider.StatusResultItemVariation(((Number)l).longValue(), var.getStringValue(), position_count, ci_count));
                }
                Object r = ((WhereAndOr)this.basePositionQuery(CollectionsKt.listOf(list3), false).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).get();
                Intrinsics.checkNotNull(r);
                Object e = ((Scalar)r).value();
                Intrinsics.checkNotNull(e);
                int position_count = ((Number)e).intValue();
                Object r3 = ((WhereAndOr)this.basePositionQuery(CollectionsKt.listOf(list3), true).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).get();
                Intrinsics.checkNotNull(r3);
                Object e3 = ((Scalar)r3).value();
                Intrinsics.checkNotNull(e3);
                int ci_count = ((Number)e3).intValue();
                Long l = product.getServer_id();
                Intrinsics.checkNotNullExpressionValue(l, "product.getServer_id()");
                items.add(new TicketCheckProvider.StatusResultItem(((Number)l).longValue(), product.getInternalName(), position_count, ci_count, variations, product.isAdmission()));
                sum_pos += position_count;
                sum_ci += ci_count;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return new TicketCheckProvider.StatusResult(list3.name, sum_pos, sum_ci, null, items);
    }

    public final void setNow(@NotNull DateTime d) {
        Intrinsics.checkNotNullParameter(d, "d");
        this.overrideNow = d;
    }

    private final DateTime now() {
        DateTime dateTime = this.overrideNow;
        return dateTime == null ? new DateTime() : dateTime;
    }

    public static final /* synthetic */ BlockingEntityStore access$getDataStore$p(AsyncCheckProvider $this) {
        return $this.dataStore;
    }

    public static final /* synthetic */ DateTime access$now(AsyncCheckProvider $this) {
        return $this.now();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\tH\u00c6\u0003JR\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006%"}, d2={"Leu/pretix/libpretixsync/check/AsyncCheckProvider$SignedTicketData;", "", "seed", "", "item", "", "variation", "subevent", "validFrom", "Lorg/joda/time/DateTime;", "validUntil", "(Ljava/lang/String;JLjava/lang/Long;Ljava/lang/Long;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;)V", "getItem", "()J", "getSeed", "()Ljava/lang/String;", "getSubevent", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getValidFrom", "()Lorg/joda/time/DateTime;", "getValidUntil", "getVariation", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;JLjava/lang/Long;Ljava/lang/Long;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;)Leu/pretix/libpretixsync/check/AsyncCheckProvider$SignedTicketData;", "equals", "", "other", "hashCode", "", "toString", "libpretixsync"})
    private static final class SignedTicketData {
        @NotNull
        private final String seed;
        private final long item;
        @Nullable
        private final Long variation;
        @Nullable
        private final Long subevent;
        @Nullable
        private final DateTime validFrom;
        @Nullable
        private final DateTime validUntil;

        public SignedTicketData(@NotNull String seed, long item, @Nullable Long variation, @Nullable Long subevent, @Nullable DateTime validFrom, @Nullable DateTime validUntil) {
            Intrinsics.checkNotNullParameter(seed, "seed");
            this.seed = seed;
            this.item = item;
            this.variation = variation;
            this.subevent = subevent;
            this.validFrom = validFrom;
            this.validUntil = validUntil;
        }

        @NotNull
        public final String getSeed() {
            return this.seed;
        }

        public final long getItem() {
            return this.item;
        }

        @Nullable
        public final Long getVariation() {
            return this.variation;
        }

        @Nullable
        public final Long getSubevent() {
            return this.subevent;
        }

        @Nullable
        public final DateTime getValidFrom() {
            return this.validFrom;
        }

        @Nullable
        public final DateTime getValidUntil() {
            return this.validUntil;
        }

        @NotNull
        public final String component1() {
            return this.seed;
        }

        public final long component2() {
            return this.item;
        }

        @Nullable
        public final Long component3() {
            return this.variation;
        }

        @Nullable
        public final Long component4() {
            return this.subevent;
        }

        @Nullable
        public final DateTime component5() {
            return this.validFrom;
        }

        @Nullable
        public final DateTime component6() {
            return this.validUntil;
        }

        @NotNull
        public final SignedTicketData copy(@NotNull String seed, long item, @Nullable Long variation, @Nullable Long subevent, @Nullable DateTime validFrom, @Nullable DateTime validUntil) {
            Intrinsics.checkNotNullParameter(seed, "seed");
            return new SignedTicketData(seed, item, variation, subevent, validFrom, validUntil);
        }

        public static /* synthetic */ SignedTicketData copy$default(SignedTicketData signedTicketData, String string, long l, Long l2, Long l3, DateTime dateTime, DateTime dateTime2, int n, Object object) {
            if ((n & 1) != 0) {
                string = signedTicketData.seed;
            }
            if ((n & 2) != 0) {
                l = signedTicketData.item;
            }
            if ((n & 4) != 0) {
                l2 = signedTicketData.variation;
            }
            if ((n & 8) != 0) {
                l3 = signedTicketData.subevent;
            }
            if ((n & 0x10) != 0) {
                dateTime = signedTicketData.validFrom;
            }
            if ((n & 0x20) != 0) {
                dateTime2 = signedTicketData.validUntil;
            }
            return signedTicketData.copy(string, l, l2, l3, dateTime, dateTime2);
        }

        @NotNull
        public String toString() {
            return "SignedTicketData(seed=" + this.seed + ", item=" + this.item + ", variation=" + this.variation + ", subevent=" + this.subevent + ", validFrom=" + this.validFrom + ", validUntil=" + this.validUntil + ')';
        }

        public int hashCode() {
            int result2 = this.seed.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.item);
            result2 = result2 * 31 + (this.variation == null ? 0 : ((Object)this.variation).hashCode());
            result2 = result2 * 31 + (this.subevent == null ? 0 : ((Object)this.subevent).hashCode());
            result2 = result2 * 31 + (this.validFrom == null ? 0 : this.validFrom.hashCode());
            result2 = result2 * 31 + (this.validUntil == null ? 0 : this.validUntil.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SignedTicketData)) {
                return false;
            }
            SignedTicketData signedTicketData = (SignedTicketData)other;
            if (!Intrinsics.areEqual(this.seed, signedTicketData.seed)) {
                return false;
            }
            if (this.item != signedTicketData.item) {
                return false;
            }
            if (!Intrinsics.areEqual(this.variation, signedTicketData.variation)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.subevent, signedTicketData.subevent)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.validFrom, signedTicketData.validFrom)) {
                return false;
            }
            return Intrinsics.areEqual(this.validUntil, signedTicketData.validUntil);
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TicketCheckProvider.CheckInType.values().length];
            nArray[TicketCheckProvider.CheckInType.ENTRY.ordinal()] = 1;
            nArray[TicketCheckProvider.CheckInType.EXIT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

