/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.LocalObject;
import eu.pretix.libpretixsync.db.Receipt;
import eu.pretix.libpretixsync.db.ReceiptLine;
import io.requery.Column;
import io.requery.Entity;
import io.requery.ForeignKey;
import io.requery.Generated;
import io.requery.Index;
import io.requery.Key;
import io.requery.ManyToOne;
import io.requery.Nullable;
import io.requery.OneToMany;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractReceiptLine
implements LocalObject {
    public static String TYPE_PRODUCT_SALE = "PRODUCT_SALE";
    public static String TYPE_PRODUCT_RETURN = "PRODUCT_RETURN";
    public static String TYPE_CHANGE_IN = "CHANGE_IN";
    public static String TYPE_CHANGE_START = "CHANGE_START";
    public static String TYPE_CHANGE_OUT = "CHANGE_OUT";
    public static String TYPE_CHANGE_DIFF = "CHANGE_DIFF";
    public static String TYPE_GIFTCARD_SALE = "GIFTCARD_SALE";
    public static String TYPE_GIFTCARD_REDEMPTION = "GIFTCARD_REDEMPTION";
    public static String TYPE_PAY_ORDER = "PAY_ORDER";
    public static String TYPE_PAY_ORDER_REVERSE = "PAY_ORDER_REVERSE";
    public static String TYPE_REFUND_ORDER = "REFUND_ORDER";
    @Generated
    @Key
    public Long id;
    @ForeignKey
    @ManyToOne
    @Index
    public Receipt receipt;
    public String type;
    public Long positionid;
    public boolean canceled;
    public BigDecimal price;
    public BigDecimal tax_rate;
    @Column(value="false")
    public boolean price_calculated_from_net;
    @Column(value="false")
    public boolean canceled_because_of_receipt;
    public Long tax_rule;
    public BigDecimal tax_value;
    @Nullable
    public BigDecimal listed_price;
    @Nullable
    public BigDecimal price_after_voucher;
    @Nullable
    public BigDecimal custom_price_input;
    @Nullable
    public String secret;
    @Nullable
    public String voucher_code;
    @Nullable
    public Long subevent_id;
    @Nullable
    public String subevent_text;
    @Nullable
    public String event_date_from;
    @Nullable
    public String event_date_to;
    @Nullable
    public String seat_guid;
    @Nullable
    public String seat_name;
    @Nullable
    public Long item_id;
    @Nullable
    public Long variation_id;
    public String sale_text;
    @Nullable
    public Long cart_position_id;
    @Nullable
    public Date created;
    @Nullable
    public String cart_id;
    @Nullable
    public String remote_error;
    @Nullable
    public Date cart_expires;
    @ForeignKey
    @ManyToOne
    @Nullable
    @Index
    public ReceiptLine addon_to;
    @Column(value="false")
    public boolean is_bundled;
    @OneToMany
    public List<ReceiptLine> addons;
    @Nullable
    public String answers;
    @Nullable
    public String attendee_name;
    @Nullable
    public String attendee_email;
    @Nullable
    public String attendee_company;
    @Nullable
    public String attendee_street;
    @Nullable
    public String attendee_zipcode;
    @Nullable
    public String attendee_city;
    @Nullable
    public String attendee_country;

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("id", this.id);
        jo.put("type", this.type);
        jo.put("position_id", this.positionid);
        jo.put("canceled", this.canceled);
        jo.put("canceled_because_of_receipt", this.canceled_because_of_receipt);
        jo.put("price_calculated_from_net", this.price_calculated_from_net);
        jo.put("listed_price", this.listed_price != null ? this.listed_price.setScale(2, RoundingMode.HALF_UP) : null);
        jo.put("price_after_voucher", this.price_after_voucher != null ? this.price_after_voucher.setScale(2, RoundingMode.HALF_UP) : null);
        jo.put("custom_price_input", this.custom_price_input != null ? this.custom_price_input.setScale(2, RoundingMode.HALF_UP) : null);
        jo.put("voucher_code", this.voucher_code);
        jo.put("price", this.price.setScale(2, RoundingMode.HALF_UP));
        jo.put("tax_rate", this.tax_rate != null ? this.tax_rate.setScale(2, RoundingMode.HALF_UP) : "0.00");
        jo.put("tax_value", this.tax_value != null ? this.tax_value.setScale(2, RoundingMode.HALF_UP) : "0.00");
        jo.put("tax_rule", this.tax_rule != null ? this.tax_rule : JSONObject.NULL);
        jo.put("secret", this.secret);
        jo.put("seat", this.seat_guid != null ? this.seat_guid : JSONObject.NULL);
        jo.put("subevent", this.subevent_id);
        jo.put("event_date_from", this.event_date_from != null && this.event_date_from.length() > 5 ? this.event_date_from : JSONObject.NULL);
        jo.put("event_date_to", this.event_date_to != null && this.event_date_to.length() > 5 ? this.event_date_to : JSONObject.NULL);
        jo.put("subevent_text", this.subevent_text != null && this.subevent_text.length() > 0 && !this.subevent_text.equals("null") ? this.subevent_text : JSONObject.NULL);
        jo.put("item", this.item_id != null && this.item_id != 0L ? this.item_id : JSONObject.NULL);
        jo.put("variation", this.variation_id);
        jo.put("answers", this.answers);
        jo.put("sale_text", this.sale_text);
        try {
            AbstractReceiptLine addon_to = (AbstractReceiptLine)this.getClass().getMethod("getAddon_to", null).invoke((Object)this, new Object[0]);
            jo.put("addon_to", addon_to != null ? addon_to.positionid : JSONObject.NULL);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        jo.put("is_bundled", this.is_bundled);
        jo.put("attendee_name", this.attendee_name);
        jo.put("attendee_email", this.attendee_email);
        jo.put("attendee_company", this.attendee_company);
        jo.put("attendee_street", this.attendee_street);
        jo.put("attendee_zipcode", this.attendee_zipcode);
        jo.put("attendee_city", this.attendee_city);
        jo.put("attendee_country", this.attendee_country);
        return jo;
    }
}

