/*
 * Decompiled with CFR 0.152.
 */
package io.requery.cache;

import io.requery.cache.SerializationContext;
import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.proxy.PropertyState;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class SerializedEntity<E>
implements Serializable {
    private final Class<E> entityClass;
    private transient E entity;

    public SerializedEntity(Class<E> entityClass, E entity) {
        this.entityClass = entityClass;
        this.entity = entity;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Type<E> type2 = SerializationContext.getType(this.entityClass);
        this.entity = type2.getFactory().get();
        EntityProxy<E> proxy = type2.getProxyProvider().apply(this.entity);
        for (Attribute<E, ?> attribute : type2.getAttributes()) {
            if (attribute.isAssociation()) {
                proxy.setState(attribute, PropertyState.FETCH);
                continue;
            }
            Object value = stream.readObject();
            proxy.setObject(attribute, value, PropertyState.LOADED);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Type<E> type2 = SerializationContext.getType(this.entityClass);
        EntityProxy<E> proxy = type2.getProxyProvider().apply(this.entity);
        for (Attribute<E, ?> attribute : type2.getAttributes()) {
            if (attribute.isAssociation()) continue;
            Object value = proxy.get(attribute, false);
            stream.writeObject(value);
        }
    }

    public E getEntity() {
        return this.entity;
    }
}

