/*
 * Decompiled with CFR 0.152.
 */
package io.requery.proxy;

import io.requery.meta.Attribute;
import io.requery.proxy.EntityProxy;
import io.requery.proxy.PropertyState;
import io.requery.util.CollectionObserver;
import io.requery.util.Objects;
import java.util.ArrayList;
import java.util.Collection;

public class CollectionChanges<T, E>
implements CollectionObserver<E> {
    private final EntityProxy<T> proxy;
    private final Attribute<T, ?> attribute;
    private final Collection<E> added;
    private final Collection<E> removed;

    CollectionChanges(EntityProxy<T> proxy, Attribute<T, ?> attribute) {
        this.proxy = proxy;
        this.attribute = attribute;
        this.added = new ArrayList();
        this.removed = new ArrayList();
    }

    public Collection<E> addedElements() {
        return this.added;
    }

    public Collection<E> removedElements() {
        return this.removed;
    }

    @Override
    public void elementAdded(E element) {
        Objects.requireNotNull(element);
        boolean wasRemoved = this.removed.remove(element);
        if (!wasRemoved && this.added.add(element)) {
            this.proxy.setState(this.attribute, PropertyState.MODIFIED);
        }
    }

    @Override
    public void elementRemoved(E element) {
        Objects.requireNotNull(element);
        boolean wasAdded = this.added.remove(element);
        if (!wasAdded && this.removed.add(element)) {
            this.proxy.setState(this.attribute, PropertyState.MODIFIED);
        }
    }

    @Override
    public void clear() {
        this.added.clear();
        this.removed.clear();
    }
}

