/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.meta.Type;
import io.requery.query.Expression;
import io.requery.query.MutableTuple;
import io.requery.query.NamedExpression;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.element.InsertType;
import io.requery.query.element.QueryElement;
import io.requery.query.element.QueryOperation;
import io.requery.sql.BoundParameters;
import io.requery.sql.CollectionResult;
import io.requery.sql.CompositeTransactionListener;
import io.requery.sql.GeneratedKeyResult;
import io.requery.sql.GeneratedResultReader;
import io.requery.sql.PreparedQueryOperation;
import io.requery.sql.RuntimeConfiguration;
import io.requery.sql.StatementExecutionException;
import io.requery.sql.StatementListener;
import io.requery.sql.gen.DefaultOutput;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

class InsertReturningOperation
extends PreparedQueryOperation
implements QueryOperation<Result<Tuple>> {
    private final Set<? extends Expression<?>> selection;

    InsertReturningOperation(RuntimeConfiguration configuration, final Set<? extends Expression<?>> selection) {
        super(configuration, new GeneratedResultReader(){

            @Override
            public void read(int index, ResultSet results) throws SQLException {
            }

            @Override
            public String[] generatedColumns() {
                String[] keys2 = new String[selection.size()];
                int index = 0;
                for (Expression expression : selection) {
                    keys2[index] = expression.getName();
                    ++index;
                }
                return keys2;
            }
        });
        this.selection = selection;
    }

    @Override
    public Result<Tuple> evaluate(QueryElement<Result<Tuple>> query) {
        DefaultOutput generator = new DefaultOutput(this.configuration, query);
        String sql = generator.toSql();
        BoundParameters parameters2 = generator.parameters();
        PreparedStatement statement = null;
        Set<Type<?>> types = query.entityTypes();
        CompositeTransactionListener transactionListener = new CompositeTransactionListener(this.configuration.getTransactionListenerFactories());
        try {
            Connection connection = this.configuration.getConnection();
            StatementListener listener = this.configuration.getStatementListener();
            statement = query.insertType() == InsertType.SELECT ? connection.prepareStatement(sql, 2) : this.prepare(sql, connection);
            this.mapParameters(statement, parameters2);
            listener.beforeExecuteUpdate(statement, sql, parameters2);
            transactionListener.beforeCommit(types);
            int count = statement.executeUpdate();
            listener.afterExecuteUpdate(statement, count);
            transactionListener.afterCommit(types);
            if (this.selection == null || this.selection.isEmpty() || query.insertType() == InsertType.SELECT) {
                connection.close();
                MutableTuple tuple = new MutableTuple(1);
                tuple.set(0, NamedExpression.ofInteger("count"), count);
                return new CollectionResult<Tuple>(tuple);
            }
            ResultSet results = statement.getGeneratedKeys();
            return new GeneratedKeyResult(this.configuration, this.selection, connection, results, count);
        }
        catch (Exception e) {
            throw StatementExecutionException.closing(statement, e, sql);
        }
    }
}

