/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java8.lang.Integers;
import java8.lang.Longs;
import java8.util.ArrayPrefixHelpers;
import java8.util.ArraysParallelSortHelpers;
import java8.util.DualPivotQuicksort;
import java8.util.J8Arrays$$Lambda$1;
import java8.util.J8Arrays$$Lambda$2;
import java8.util.J8Arrays$$Lambda$3;
import java8.util.J8Arrays$$Lambda$4;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.TimSort;
import java8.util.concurrent.ForkJoinPool;
import java8.util.function.BinaryOperator;
import java8.util.function.DoubleBinaryOperator;
import java8.util.function.IntBinaryOperator;
import java8.util.function.IntFunction;
import java8.util.function.IntToDoubleFunction;
import java8.util.function.IntToLongFunction;
import java8.util.function.IntUnaryOperator;
import java8.util.function.LongBinaryOperator;
import java8.util.stream.DoubleStream;
import java8.util.stream.IntStream;
import java8.util.stream.IntStreams;
import java8.util.stream.LongStream;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;

public final class J8Arrays {
    private static final int MIN_ARRAY_SORT_GRAN = 8192;

    public static <T> Spliterator<T> spliterator(T[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static <T> Spliterator<T> spliterator(T[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static Spliterator.OfInt spliterator(int[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static Spliterator.OfInt spliterator(int[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static Spliterator.OfLong spliterator(long[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static Spliterator.OfLong spliterator(long[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static Spliterator.OfDouble spliterator(double[] array) {
        return Spliterators.spliterator(array, 1040);
    }

    public static Spliterator.OfDouble spliterator(double[] array, int startInclusive, int endExclusive) {
        return Spliterators.spliterator(array, startInclusive, endExclusive, 1040);
    }

    public static <T> Stream<T> stream(T[] array) {
        return J8Arrays.stream(array, 0, array.length);
    }

    public static <T> Stream<T> stream(T[] array, int startInclusive, int endExclusive) {
        return StreamSupport.stream(J8Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static IntStream stream(int[] array) {
        return J8Arrays.stream(array, 0, array.length);
    }

    public static IntStream stream(int[] array, int startInclusive, int endExclusive) {
        return StreamSupport.intStream(J8Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static LongStream stream(long[] array) {
        return J8Arrays.stream(array, 0, array.length);
    }

    public static LongStream stream(long[] array, int startInclusive, int endExclusive) {
        return StreamSupport.longStream(J8Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static DoubleStream stream(double[] array) {
        return J8Arrays.stream(array, 0, array.length);
    }

    public static DoubleStream stream(double[] array, int startInclusive, int endExclusive) {
        return StreamSupport.doubleStream(J8Arrays.spliterator(array, startInclusive, endExclusive), false);
    }

    public static void parallelSort(byte[] a) {
        DualPivotQuicksort.sort(a, 0, a.length);
    }

    public static void parallelSort(byte[] a, int fromIndex, int toIndex) {
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        DualPivotQuicksort.sort(a, fromIndex, toIndex);
    }

    public static void parallelSort(char[] a) {
        DualPivotQuicksort.sort(a, 0, a.length);
    }

    public static void parallelSort(char[] a, int fromIndex, int toIndex) {
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        DualPivotQuicksort.sort(a, fromIndex, toIndex);
    }

    public static void parallelSort(short[] a) {
        DualPivotQuicksort.sort(a, 0, a.length);
    }

    public static void parallelSort(short[] a, int fromIndex, int toIndex) {
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        DualPivotQuicksort.sort(a, fromIndex, toIndex);
    }

    public static void parallelSort(int[] a) {
        DualPivotQuicksort.sort(a, ForkJoinPool.getCommonPoolParallelism(), 0, a.length);
    }

    public static void parallelSort(int[] a, int fromIndex, int toIndex) {
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        DualPivotQuicksort.sort(a, ForkJoinPool.getCommonPoolParallelism(), fromIndex, toIndex);
    }

    public static void parallelSort(long[] a) {
        DualPivotQuicksort.sort(a, ForkJoinPool.getCommonPoolParallelism(), 0, a.length);
    }

    public static void parallelSort(long[] a, int fromIndex, int toIndex) {
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        DualPivotQuicksort.sort(a, ForkJoinPool.getCommonPoolParallelism(), fromIndex, toIndex);
    }

    public static void parallelSort(float[] a) {
        DualPivotQuicksort.sort(a, ForkJoinPool.getCommonPoolParallelism(), 0, a.length);
    }

    public static void parallelSort(float[] a, int fromIndex, int toIndex) {
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        DualPivotQuicksort.sort(a, ForkJoinPool.getCommonPoolParallelism(), fromIndex, toIndex);
    }

    public static void parallelSort(double[] a) {
        DualPivotQuicksort.sort(a, ForkJoinPool.getCommonPoolParallelism(), 0, a.length);
    }

    public static void parallelSort(double[] a, int fromIndex, int toIndex) {
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        DualPivotQuicksort.sort(a, ForkJoinPool.getCommonPoolParallelism(), fromIndex, toIndex);
    }

    private static void rangeCheck(int arrayLength, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] a) {
        int p;
        int n = a.length;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(a, 0, n, NaturalOrder.INSTANCE, null, 0, 0);
        } else {
            int g;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, a, (Comparable[])Array.newInstance(a.getClass().getComponentType(), n), 0, n, 0, (g = n / (p << 2)) <= 8192 ? 8192 : g, NaturalOrder.INSTANCE).invoke();
        }
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] a, int fromIndex, int toIndex) {
        int p;
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(a, fromIndex, toIndex, NaturalOrder.INSTANCE, null, 0, 0);
        } else {
            int g;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, a, (Comparable[])Array.newInstance(a.getClass().getComponentType(), n), fromIndex, n, 0, (g = n / (p << 2)) <= 8192 ? 8192 : g, NaturalOrder.INSTANCE).invoke();
        }
    }

    public static <T> void parallelSort(T[] a, Comparator<? super T> cmp) {
        int p;
        int n;
        if (cmp == null) {
            cmp = NaturalOrder.INSTANCE;
        }
        if ((n = a.length) <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(a, 0, n, cmp, null, 0, 0);
        } else {
            int g;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, a, (Object[])Array.newInstance(a.getClass().getComponentType(), n), 0, n, 0, (g = n / (p << 2)) <= 8192 ? 8192 : g, cmp).invoke();
        }
    }

    public static <T> void parallelSort(T[] a, int fromIndex, int toIndex, Comparator<? super T> cmp) {
        int p;
        int n;
        J8Arrays.rangeCheck(a.length, fromIndex, toIndex);
        if (cmp == null) {
            cmp = NaturalOrder.INSTANCE;
        }
        if ((n = toIndex - fromIndex) <= 8192 || (p = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(a, fromIndex, toIndex, cmp, null, 0, 0);
        } else {
            int g;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, a, (Object[])Array.newInstance(a.getClass().getComponentType(), n), fromIndex, n, 0, (g = n / (p << 2)) <= 8192 ? 8192 : g, cmp).invoke();
        }
    }

    public static <T> void setAll(T[] array, IntFunction<? extends T> generator) {
        Objects.requireNonNull(generator);
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = generator.apply(i2);
        }
    }

    public static <T> void parallelSetAll(T[] array, IntFunction<? extends T> generator) {
        Objects.requireNonNull(generator);
        IntStreams.range(0, array.length).parallel().forEach(J8Arrays$$Lambda$1.lambdaFactory$(array, generator));
    }

    public static void setAll(int[] array, IntUnaryOperator generator) {
        Objects.requireNonNull(generator);
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = generator.applyAsInt(i2);
        }
    }

    public static void parallelSetAll(int[] array, IntUnaryOperator generator) {
        Objects.requireNonNull(generator);
        IntStreams.range(0, array.length).parallel().forEach(J8Arrays$$Lambda$2.lambdaFactory$(array, generator));
    }

    public static void setAll(long[] array, IntToLongFunction generator) {
        Objects.requireNonNull(generator);
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = generator.applyAsLong(i2);
        }
    }

    public static void parallelSetAll(long[] array, IntToLongFunction generator) {
        Objects.requireNonNull(generator);
        IntStreams.range(0, array.length).parallel().forEach(J8Arrays$$Lambda$3.lambdaFactory$(array, generator));
    }

    public static void setAll(double[] array, IntToDoubleFunction generator) {
        Objects.requireNonNull(generator);
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = generator.applyAsDouble(i2);
        }
    }

    public static void parallelSetAll(double[] array, IntToDoubleFunction generator) {
        Objects.requireNonNull(generator);
        IntStreams.range(0, array.length).parallel().forEach(J8Arrays$$Lambda$4.lambdaFactory$(array, generator));
    }

    public static <T> void parallelPrefix(T[] array, BinaryOperator<T> op) {
        Objects.requireNonNull(op);
        if (array.length > 0) {
            new ArrayPrefixHelpers.CumulateTask<T>(null, op, array, 0, array.length).invoke();
        }
    }

    public static <T> void parallelPrefix(T[] array, int fromIndex, int toIndex, BinaryOperator<T> op) {
        Objects.requireNonNull(op);
        J8Arrays.rangeCheck(array.length, fromIndex, toIndex);
        if (fromIndex < toIndex) {
            new ArrayPrefixHelpers.CumulateTask<T>(null, op, array, fromIndex, toIndex).invoke();
        }
    }

    public static void parallelPrefix(long[] array, LongBinaryOperator op) {
        Objects.requireNonNull(op);
        if (array.length > 0) {
            new ArrayPrefixHelpers.LongCumulateTask(null, op, array, 0, array.length).invoke();
        }
    }

    public static void parallelPrefix(long[] array, int fromIndex, int toIndex, LongBinaryOperator op) {
        Objects.requireNonNull(op);
        J8Arrays.rangeCheck(array.length, fromIndex, toIndex);
        if (fromIndex < toIndex) {
            new ArrayPrefixHelpers.LongCumulateTask(null, op, array, fromIndex, toIndex).invoke();
        }
    }

    public static void parallelPrefix(double[] array, DoubleBinaryOperator op) {
        Objects.requireNonNull(op);
        if (array.length > 0) {
            new ArrayPrefixHelpers.DoubleCumulateTask(null, op, array, 0, array.length).invoke();
        }
    }

    public static void parallelPrefix(double[] array, int fromIndex, int toIndex, DoubleBinaryOperator op) {
        Objects.requireNonNull(op);
        J8Arrays.rangeCheck(array.length, fromIndex, toIndex);
        if (fromIndex < toIndex) {
            new ArrayPrefixHelpers.DoubleCumulateTask(null, op, array, fromIndex, toIndex).invoke();
        }
    }

    public static void parallelPrefix(int[] array, IntBinaryOperator op) {
        Objects.requireNonNull(op);
        if (array.length > 0) {
            new ArrayPrefixHelpers.IntCumulateTask(null, op, array, 0, array.length).invoke();
        }
    }

    public static void parallelPrefix(int[] array, int fromIndex, int toIndex, IntBinaryOperator op) {
        Objects.requireNonNull(op);
        J8Arrays.rangeCheck(array.length, fromIndex, toIndex);
        if (fromIndex < toIndex) {
            new ArrayPrefixHelpers.IntCumulateTask(null, op, array, fromIndex, toIndex).invoke();
        }
    }

    public static boolean equals(Object[] a, int aFromIndex, int aToIndex, Object[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        for (int i2 = 0; i2 < aLength; ++i2) {
            if (Objects.equals(a[aFromIndex++], b[bFromIndex++])) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T[] a, T[] a2, Comparator<? super T> cmp) {
        Objects.requireNonNull(cmp);
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (cmp.compare(a[i2], a2[i2]) == 0) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T[] a, int aFromIndex, int aToIndex, T[] b, int bFromIndex, int bToIndex, Comparator<? super T> cmp) {
        Objects.requireNonNull(cmp);
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        for (int i2 = 0; i2 < aLength; ++i2) {
            if (cmp.compare(a[aFromIndex++], b[bFromIndex++]) == 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> int compare(T[] a, T[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int length = Math.min(a.length, b.length);
        for (int i2 = 0; i2 < length; ++i2) {
            T oa = a[i2];
            T ob = b[i2];
            if (oa == ob) continue;
            if (oa == null || ob == null) {
                return oa == null ? -1 : 1;
            }
            int v = oa.compareTo(ob);
            if (v == 0) continue;
            return v;
        }
        return a.length - b.length;
    }

    public static <T extends Comparable<? super T>> int compare(T[] a, int aFromIndex, int aToIndex, T[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        int length = Math.min(aLength, bLength);
        for (int i2 = 0; i2 < length; ++i2) {
            T ob;
            T oa;
            if ((oa = a[aFromIndex++]) == (ob = b[bFromIndex++])) continue;
            if (oa == null || ob == null) {
                return oa == null ? -1 : 1;
            }
            int v = oa.compareTo(ob);
            if (v == 0) continue;
            return v;
        }
        return aLength - bLength;
    }

    public static <T> int compare(T[] a, T[] b, Comparator<? super T> cmp) {
        Objects.requireNonNull(cmp);
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int length = Math.min(a.length, b.length);
        for (int i2 = 0; i2 < length; ++i2) {
            int v;
            T oa = a[i2];
            T ob = b[i2];
            if (oa == ob || (v = cmp.compare(oa, ob)) == 0) continue;
            return v;
        }
        return a.length - b.length;
    }

    public static <T> int compare(T[] a, int aFromIndex, int aToIndex, T[] b, int bFromIndex, int bToIndex, Comparator<? super T> cmp) {
        Objects.requireNonNull(cmp);
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        int length = Math.min(aLength, bLength);
        for (int i2 = 0; i2 < length; ++i2) {
            int v;
            T ob;
            T oa;
            if ((oa = a[aFromIndex++]) == (ob = b[bFromIndex++]) || (v = cmp.compare(oa, ob)) == 0) continue;
            return v;
        }
        return aLength - bLength;
    }

    public static int mismatch(Object[] a, Object[] b) {
        int length = Math.min(a.length, b.length);
        if (a == b) {
            return -1;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (Objects.equals(a[i2], b[i2])) continue;
            return i2;
        }
        return a.length != b.length ? length : -1;
    }

    public static int mismatch(Object[] a, int aFromIndex, int aToIndex, Object[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        int length = Math.min(aLength, bLength);
        for (int i2 = 0; i2 < length; ++i2) {
            if (Objects.equals(a[aFromIndex++], b[bFromIndex++])) continue;
            return i2;
        }
        return aLength != bLength ? length : -1;
    }

    public static <T> int mismatch(T[] a, T[] b, Comparator<? super T> cmp) {
        Objects.requireNonNull(cmp);
        int length = Math.min(a.length, b.length);
        if (a == b) {
            return -1;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            int v;
            T oa = a[i2];
            T ob = b[i2];
            if (oa == ob || (v = cmp.compare(oa, ob)) == 0) continue;
            return i2;
        }
        return a.length != b.length ? length : -1;
    }

    public static <T> int mismatch(T[] a, int aFromIndex, int aToIndex, T[] b, int bFromIndex, int bToIndex, Comparator<? super T> cmp) {
        Objects.requireNonNull(cmp);
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        int length = Math.min(aLength, bLength);
        for (int i2 = 0; i2 < length; ++i2) {
            int v;
            T ob;
            T oa;
            if ((oa = a[aFromIndex++]) == (ob = b[bFromIndex++]) || (v = cmp.compare(oa, ob)) == 0) continue;
            return i2;
        }
        return aLength != bLength ? length : -1;
    }

    public static boolean equals(long[] a, int aFromIndex, int aToIndex, long[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        for (int i2 = 0; i2 < aLength; ++i2) {
            if (a[aFromIndex++] == b[bFromIndex++]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] a, int aFromIndex, int aToIndex, int[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        for (int i2 = 0; i2 < aLength; ++i2) {
            if (a[aFromIndex++] == b[bFromIndex++]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] a, int aFromIndex, int aToIndex, double[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        for (int i2 = 0; i2 < aLength; ++i2) {
            double va = a[aFromIndex++];
            double vb = b[bFromIndex++];
            if (Double.doubleToRawLongBits(va) == Double.doubleToRawLongBits(vb) || Double.isNaN(va) && Double.isNaN(vb)) continue;
            return false;
        }
        return true;
    }

    public static int compare(int[] a, int[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int length = Math.min(a.length, b.length);
        for (int i2 = 0; i2 < length; ++i2) {
            if (a[i2] == b[i2]) continue;
            return Integers.compare(a[i2], b[i2]);
        }
        return a.length - b.length;
    }

    public static int compare(int[] a, int aFromIndex, int aToIndex, int[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        int length = Math.min(aLength, bLength);
        for (int i2 = 0; i2 < length; ++i2) {
            int vb;
            int va;
            if ((va = a[aFromIndex++]) == (vb = b[bFromIndex++])) continue;
            return Integers.compare(va, vb);
        }
        return aLength - bLength;
    }

    public static int compare(long[] a, long[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int length = Math.min(a.length, b.length);
        for (int i2 = 0; i2 < length; ++i2) {
            if (a[i2] == b[i2]) continue;
            return Longs.compare(a[i2], b[i2]);
        }
        return a.length - b.length;
    }

    public static int compare(long[] a, int aFromIndex, int aToIndex, long[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        int length = Math.min(aLength, bLength);
        for (int i2 = 0; i2 < length; ++i2) {
            long vb;
            long va;
            if ((va = a[aFromIndex++]) == (vb = b[bFromIndex++])) continue;
            return Longs.compare(va, vb);
        }
        return aLength - bLength;
    }

    public static int compare(double[] a, double[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int length = Math.min(a.length, b.length);
        for (int i2 = 0; i2 < length; ++i2) {
            int c;
            double va = a[i2];
            double vb = b[i2];
            if (Double.doubleToRawLongBits(va) == Double.doubleToRawLongBits(vb) || (c = Double.compare(va, vb)) == 0) continue;
            return c;
        }
        return a.length - b.length;
    }

    public static int compare(double[] a, int aFromIndex, int aToIndex, double[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        int length = Math.min(aLength, bLength);
        for (int i2 = 0; i2 < length; ++i2) {
            int c;
            double va = a[aFromIndex++];
            double vb = b[bFromIndex++];
            if (Double.doubleToRawLongBits(va) == Double.doubleToRawLongBits(vb) || (c = Double.compare(va, vb)) == 0) continue;
            return c;
        }
        return aLength - bLength;
    }

    public static int mismatch(int[] a, int[] b) {
        int length = Math.min(a.length, b.length);
        if (a == b) {
            return -1;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (a[i2] == b[i2]) continue;
            return i2;
        }
        return a.length != b.length ? length : -1;
    }

    public static int mismatch(int[] a, int aFromIndex, int aToIndex, int[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        int length = Math.min(aLength, bLength);
        for (int i2 = 0; i2 < length; ++i2) {
            if (a[aFromIndex++] == b[bFromIndex++]) continue;
            return i2;
        }
        return aLength != bLength ? length : -1;
    }

    public static int mismatch(long[] a, long[] b) {
        int length = Math.min(a.length, b.length);
        if (a == b) {
            return -1;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (a[i2] == b[i2]) continue;
            return i2;
        }
        return a.length != b.length ? length : -1;
    }

    public static int mismatch(long[] a, int aFromIndex, int aToIndex, long[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        int length = Math.min(aLength, bLength);
        for (int i2 = 0; i2 < length; ++i2) {
            if (a[aFromIndex++] == b[bFromIndex++]) continue;
            return i2;
        }
        return aLength != bLength ? length : -1;
    }

    public static int mismatch(double[] a, double[] b) {
        int length = Math.min(a.length, b.length);
        if (a == b) {
            return -1;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            double va = a[i2];
            double vb = b[i2];
            if (Double.doubleToRawLongBits(va) == Double.doubleToRawLongBits(vb) || Double.isNaN(va) && Double.isNaN(vb)) continue;
            return i2;
        }
        return a.length != b.length ? length : -1;
    }

    public static int mismatch(double[] a, int aFromIndex, int aToIndex, double[] b, int bFromIndex, int bToIndex) {
        J8Arrays.rangeCheck(a.length, aFromIndex, aToIndex);
        J8Arrays.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        int length = Math.min(aLength, bLength);
        for (int i2 = 0; i2 < length; ++i2) {
            double va = a[aFromIndex++];
            double vb = b[bFromIndex++];
            if (Double.doubleToRawLongBits(va) == Double.doubleToRawLongBits(vb) || Double.isNaN(va) && Double.isNaN(vb)) continue;
            return i2;
        }
        return aLength != bLength ? length : -1;
    }

    public static <T> T[] toArray(Collection<T> col, IntFunction<T[]> generator) {
        return col.toArray(generator.apply(0));
    }

    private J8Arrays() {
    }

    static /* synthetic */ void lambda$parallelSetAll$166(double[] dArray, IntToDoubleFunction intToDoubleFunction, int i2) {
        dArray[i2] = intToDoubleFunction.applyAsDouble(i2);
    }

    static /* synthetic */ void lambda$parallelSetAll$165(long[] lArray, IntToLongFunction intToLongFunction, int i2) {
        lArray[i2] = intToLongFunction.applyAsLong(i2);
    }

    static /* synthetic */ void lambda$parallelSetAll$164(int[] nArray, IntUnaryOperator intUnaryOperator, int i2) {
        nArray[i2] = intUnaryOperator.applyAsInt(i2);
    }

    static /* synthetic */ void lambda$parallelSetAll$163(Object[] objectArray, IntFunction intFunction, int i2) {
        objectArray[i2] = intFunction.apply(i2);
    }

    static final class NaturalOrder
    implements Comparator<Object> {
        static final NaturalOrder INSTANCE = new NaturalOrder();

        NaturalOrder() {
        }

        @Override
        public int compare(Object first, Object second) {
            return ((Comparable)first).compareTo(second);
        }
    }
}

