/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.pretixscan.scanproxy;

import eu.pretix.pretixscan.scanproxy.Models;
import eu.pretix.pretixscan.scanproxy.Server;
import eu.pretix.pretixscan.scanproxy.db.Migrations;
import io.requery.EntityCache;
import io.requery.Persistable;
import io.requery.cache.EntityCacheBuilder;
import io.requery.meta.EntityModel;
import io.requery.sql.Configuration;
import io.requery.sql.ConfigurationBuilder;
import io.requery.sql.EntityDataStore;
import io.requery.sql.KotlinConfiguration;
import io.requery.sql.KotlinEntityDataStore;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import javax.sql.CommonDataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u001a\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"makeProxyDataStore", "Lio/requery/sql/KotlinEntityDataStore;", "Lio/requery/Persistable;", "makeSyncDataStore", "Lio/requery/sql/EntityDataStore;", "server"})
public final class DatabaseKt {
    @NotNull
    public static final EntityDataStore<Persistable> makeSyncDataStore() {
        Logger LOG = LoggerFactory.getLogger(Server.class);
        Connection conn = DriverManager.getConnection(System.getProperty("pretixscan.database"));
        boolean exists = false;
        String[] stringArray = new String[]{"TABLE"};
        ResultSet r = conn.getMetaData().getTables(null, null, "_version", stringArray);
        while (r.next()) {
            if (!Intrinsics.areEqual(r.getString("TABLE_NAME"), "_version")) continue;
            exists = true;
            break;
        }
        if (!exists) {
            LOG.info("Creating new database.");
        }
        PGSimpleDataSource dataSource = new PGSimpleDataSource();
        dataSource.setURL(System.getProperty("pretixscan.database"));
        EntityModel model = eu.pretix.libpretixsync.Models.DEFAULT;
        eu.pretix.libpretixsync.db.Migrations.migrate(dataSource, !exists);
        Configuration configuration = new ConfigurationBuilder(dataSource, model).setEntityCache(new EntityCacheBuilder(model).useReferenceCache(false).useSerializableCache(false).build()).build();
        return new EntityDataStore<Persistable>(configuration);
    }

    @NotNull
    public static final KotlinEntityDataStore<Persistable> makeProxyDataStore() {
        Logger LOG = LoggerFactory.getLogger(Server.class);
        Connection conn = DriverManager.getConnection(System.getProperty("pretixscan.database"));
        boolean exists = false;
        String[] stringArray = new String[]{"TABLE"};
        ResultSet r = conn.getMetaData().getTables(null, null, "_scanproxy_version", stringArray);
        while (r.next()) {
            if (!Intrinsics.areEqual(r.getString("TABLE_NAME"), "_scanproxy_version")) continue;
            exists = true;
            break;
        }
        if (!exists) {
            LOG.info("Creating new database.");
        }
        PGSimpleDataSource dataSource = new PGSimpleDataSource();
        dataSource.setURL(System.getProperty("pretixscan.database"));
        EntityModel model = Models.DEFAULT;
        Migrations.INSTANCE.migrate(dataSource, !exists);
        EntityCache entityCache = new EntityCacheBuilder(model).useReferenceCache(false).useSerializableCache(false).build();
        Intrinsics.checkNotNullExpressionValue(model, "model");
        CommonDataSource commonDataSource = dataSource;
        Intrinsics.checkNotNullExpressionValue(entityCache, "build()");
        KotlinConfiguration configuration = new KotlinConfiguration(model, commonDataSource, null, null, entityCache, false, 0, 0, false, false, null, null, null, null, null, null, null, null, 262124, null);
        return new KotlinEntityDataStore<Persistable>(configuration);
    }
}

