/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.BitSet;

public final class URLFragmentEncoder
implements Cloneable {
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final URLFragmentEncoder STRICT = new URLFragmentEncoder();
    public static final URLFragmentEncoder DEFAULT = new URLFragmentEncoder();
    public static final URLFragmentEncoder QUERY = new URLFragmentEncoder();
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    public URLFragmentEncoder() {
        this(new BitSet(256));
        char i2;
        for (i2 = 'a'; i2 <= 'z'; i2 = (char)((char)(i2 + '\u0001'))) {
            this.addSafeCharacter(i2);
        }
        for (i2 = 'A'; i2 <= 'Z'; i2 = (char)(i2 + '\u0001')) {
            this.addSafeCharacter(i2);
        }
        for (i2 = '0'; i2 <= '9'; i2 = (char)(i2 + '\u0001')) {
            this.addSafeCharacter(i2);
        }
    }

    private URLFragmentEncoder(BitSet safeCharacters) {
        this.safeCharacters = safeCharacters;
    }

    public void addSafeCharacter(char c) {
        this.safeCharacters.set(c);
    }

    public void removeSafeCharacter(char c) {
        this.safeCharacters.clear(c);
    }

    public void setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
    }

    public String encode(String path, Charset charset) {
        int maxBytesPerChar = 10;
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, charset);
        for (int i2 = 0; i2 < path.length(); ++i2) {
            byte[] ba;
            char c = path.charAt(i2);
            if (this.safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            if (this.encodeSpaceAsPlus && c == ' ') {
                rewrittenPath.append('+');
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            for (byte toEncode : ba = buf.toByteArray()) {
                rewrittenPath.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPath.append(hexadecimal[high]);
                rewrittenPath.append(hexadecimal[low]);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }

    public Object clone() {
        URLFragmentEncoder result2 = new URLFragmentEncoder((BitSet)this.safeCharacters.clone());
        result2.setEncodeSpaceAsPlus(this.encodeSpaceAsPlus);
        return result2;
    }

    static {
        DEFAULT.addSafeCharacter('-');
        DEFAULT.addSafeCharacter('.');
        DEFAULT.addSafeCharacter('_');
        DEFAULT.addSafeCharacter('~');
        DEFAULT.addSafeCharacter('!');
        DEFAULT.addSafeCharacter('$');
        DEFAULT.addSafeCharacter('&');
        DEFAULT.addSafeCharacter('\'');
        DEFAULT.addSafeCharacter('(');
        DEFAULT.addSafeCharacter(')');
        DEFAULT.addSafeCharacter('*');
        DEFAULT.addSafeCharacter('+');
        DEFAULT.addSafeCharacter(',');
        DEFAULT.addSafeCharacter(';');
        DEFAULT.addSafeCharacter('=');
        DEFAULT.addSafeCharacter(':');
        DEFAULT.addSafeCharacter('@');
        DEFAULT.addSafeCharacter('/');
        QUERY.setEncodeSpaceAsPlus(true);
        QUERY.addSafeCharacter('*');
        QUERY.addSafeCharacter('-');
        QUERY.addSafeCharacter('.');
        QUERY.addSafeCharacter('_');
        QUERY.addSafeCharacter('=');
        QUERY.addSafeCharacter('&');
    }
}

