/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.api;

import eu.pretix.libpretixsync.DummySentryImplementation;
import eu.pretix.libpretixsync.SentryInterface;
import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.ConflictApiException;
import eu.pretix.libpretixsync.api.DefaultHttpClientFactory;
import eu.pretix.libpretixsync.api.DeviceAccessRevokedException;
import eu.pretix.libpretixsync.api.FinalApiException;
import eu.pretix.libpretixsync.api.HttpClientFactory;
import eu.pretix.libpretixsync.api.NotFoundApiException;
import eu.pretix.libpretixsync.api.ResourceNotModified;
import eu.pretix.libpretixsync.config.ConfigStore;
import eu.pretix.libpretixsync.db.Answer;
import eu.pretix.libpretixsync.db.Question;
import eu.pretix.libpretixsync.db.QueuedCheckIn;
import eu.pretix.libpretixsync.utils.NetUtils;
import eu.pretix.libpretixsync.utils.URLFragmentEncoder;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\b\u0016\u0018\u0000 K2\u00020\u0001:\u0002JKB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001bH\u0002J\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J \u0010\u001f\u001a\u00060\u0017R\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u0016\u0010\"\u001a\b\u0018\u00010\u0017R\u00020\u00002\u0006\u0010 \u001a\u00020\u0003H\u0016J\u0016\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003J\u0012\u0010&\u001a\u00060\u0017R\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J \u0010&\u001a\u00060\u0017R\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0003H\u0016J\u000e\u0010(\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0003J\u001a\u0010)\u001a\u00060\u0017R\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010*\u001a\u00020+J(\u0010)\u001a\u00060\u0017R\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010*\u001a\u00020+2\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010,\u001a\u00060\u0017R\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010,\u001a\u00060\u0017R\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010*\u001a\u00020-J\u001a\u0010,\u001a\u00060\u0017R\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010*\u001a\u00020+J$\u0010,\u001a\u00060\u0017R\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\u0006\u0010*\u001a\u00020+2\b\u0010!\u001a\u0004\u0018\u00010\u0003J(\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0003H\u0016Jr\u00105\u001a\u00060\u0017R\u00020\u00002\u0006\u0010$\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020\u001b2\b\u0010:\u001a\u0004\u0018\u00010\u00032\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010<2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001b2\b\u0010B\u001a\u0004\u0018\u00010\u00032\b\u0010C\u001a\u0004\u0018\u00010\u0003Jt\u00105\u001a\u00060\u0017R\u00020\u00002\u0006\u0010$\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u00010\u00032\u0006\u00109\u001a\u00020\u001b2\b\u0010:\u001a\u0004\u0018\u00010\u00032\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010<2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001b2\b\u0010B\u001a\u0004\u0018\u00010\u00032\b\u0010C\u001a\u0004\u0018\u00010\u0003H\u0016Jf\u00105\u001a\u00060\u0017R\u00020\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020?0<2\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020\u001b2\b\u0010:\u001a\u0004\u0018\u00010\u00032\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010<2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001b2\b\u0010B\u001a\u0004\u0018\u00010\u0003Jh\u00105\u001a\u00060\u0017R\u00020\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020?0<2\u0006\u00106\u001a\u00020\u00032\b\u00107\u001a\u0004\u0018\u00010\u00032\u0006\u00109\u001a\u00020\u001b2\b\u0010:\u001a\u0004\u0018\u00010\u00032\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010<2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001b2\b\u0010B\u001a\u0004\u0018\u00010\u0003H\u0016J.\u0010E\u001a\u00060\u0017R\u00020\u00002\u0006\u0010$\u001a\u00020\u00032\u0006\u0010>\u001a\u00020?2\b\u0010F\u001a\u0004\u0018\u00010\u00032\u0006\u0010G\u001a\u00020\u0007H\u0016J,\u0010E\u001a\u00060\u0017R\u00020\u00002\f\u0010D\u001a\b\u0012\u0004\u0012\u00020?0<2\b\u0010F\u001a\u0004\u0018\u00010\u00032\u0006\u0010G\u001a\u00020\u0007H\u0016J\u001c\u0010H\u001a\u00060\u0017R\u00020\u00002\u0006\u0010$\u001a\u00020\u00032\u0006\u0010>\u001a\u00020?H\u0016J \u0010I\u001a\u00020\u00032\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0003H\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Leu/pretix/libpretixsync/api/PretixApi;", "", "url", "", "key", "orgaSlug", "version", "", "httpClientFactory", "Leu/pretix/libpretixsync/api/HttpClientFactory;", "acceptLanguage", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILeu/pretix/libpretixsync/api/HttpClientFactory;Ljava/lang/String;)V", "getAcceptLanguage", "()Ljava/lang/String;", "client", "Lokhttp3/OkHttpClient;", "sentry", "Leu/pretix/libpretixsync/SentryInterface;", "getSentry", "()Leu/pretix/libpretixsync/SentryInterface;", "setSentry", "(Leu/pretix/libpretixsync/SentryInterface;)V", "apiCall", "Leu/pretix/libpretixsync/api/PretixApi$ApiResponse;", "request", "Lokhttp3/Request;", "json", "", "is_retry", "apiURL", "suffix", "deleteResource", "full_url", "idempotency_key", "downloadFile", "eventResourceUrl", "eventSlug", "resource", "fetchResource", "if_modified_since", "organizerResourceUrl", "patchResource", "data", "Lorg/json/JSONObject;", "postResource", "Lorg/json/JSONArray;", "putFile", "", "file", "Ljava/io/File;", "mediaType", "Lokhttp3/MediaType;", "filename", "redeem", "secret", "datetime", "Ljava/util/Date;", "force", "nonce", "answers", "", "Leu/pretix/libpretixsync/db/Answer;", "listId", "", "ignore_unpaid", "pdf_data", "type", "source_type", "lists", "search", "query", "page", "status", "uploadFile", "ApiResponse", "Companion", "libpretixsync"})
public class PretixApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String acceptLanguage;
    @NotNull
    private final String url;
    @NotNull
    private final String orgaSlug;
    @NotNull
    private final String key;
    private final int version;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private SentryInterface sentry;
    public static final int SUPPORTED_API_VERSION = 4;
    @NotNull
    private static final MediaType JSON = MediaType.Companion.get("application/json; charset=utf-8");

    public PretixApi(@NotNull String url, @NotNull String key, @NotNull String orgaSlug, int version, @NotNull HttpClientFactory httpClientFactory, @Nullable String acceptLanguage) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(orgaSlug, "orgaSlug");
        Intrinsics.checkNotNullParameter(httpClientFactory, "httpClientFactory");
        this.acceptLanguage = acceptLanguage;
        String url2 = url;
        if (!StringsKt.endsWith$default(url2, "/", false, 2, null)) {
            url2 = Intrinsics.stringPlus(url2, "/");
        }
        this.url = url2;
        this.key = key;
        this.orgaSlug = orgaSlug;
        this.version = version;
        OkHttpClient okHttpClient = httpClientFactory.buildClient(NetUtils.ignoreSSLforURL(url2));
        Intrinsics.checkNotNullExpressionValue(okHttpClient, "httpClientFactory.buildC\u2026ils.ignoreSSLforURL(url))");
        this.client = okHttpClient;
        this.sentry = new DummySentryImplementation();
    }

    public /* synthetic */ PretixApi(String string, String string2, String string3, int n, HttpClientFactory httpClientFactory, String string4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            string4 = null;
        }
        this(string, string2, string3, n, httpClientFactory, string4);
    }

    @Nullable
    public final String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    @NotNull
    public final SentryInterface getSentry() {
        return this.sentry;
    }

    public final void setSentry(@NotNull SentryInterface sentryInterface) {
        Intrinsics.checkNotNullParameter(sentryInterface, "<set-?>");
        this.sentry = sentryInterface;
    }

    @NotNull
    public final ApiResponse redeem(@NotNull String eventSlug, @NotNull String secret, @Nullable Date datetime, boolean force, @Nullable String nonce, @Nullable List<Answer> answers, long listId, boolean ignore_unpaid, boolean pdf_data, @Nullable String type2, @Nullable String source_type) throws ApiException, JSONException {
        Intrinsics.checkNotNullParameter(eventSlug, "eventSlug");
        Intrinsics.checkNotNullParameter(secret, "secret");
        String dt = null;
        if (datetime != null) {
            dt = QueuedCheckIn.formatDatetime(datetime);
        }
        return this.redeem(eventSlug, secret, dt, force, nonce, answers, listId, ignore_unpaid, pdf_data, type2, source_type);
    }

    @NotNull
    public ApiResponse redeem(@NotNull String eventSlug, @NotNull String secret, @Nullable String datetime, boolean force, @Nullable String nonce, @Nullable List<Answer> answers, long listId, boolean ignore_unpaid, boolean pdf_data, @Nullable String type2, @Nullable String source_type) throws ApiException, JSONException {
        JSONObject answerbody;
        JSONObject body2;
        block22: {
            Intrinsics.checkNotNullParameter(eventSlug, "eventSlug");
            Intrinsics.checkNotNullParameter(secret, "secret");
            body2 = new JSONObject();
            if (datetime != null) {
                body2.put("datetime", datetime);
            }
            body2.put("force", force);
            body2.put("ignore_unpaid", ignore_unpaid);
            body2.put("nonce", nonce);
            body2.put("type", type2);
            String string = source_type;
            body2.put("source_type", string == null ? "barcode" : string);
            answerbody = new JSONObject();
            if (answers == null) break block22;
            for (Answer a : answers) {
                block23: {
                    MediaType mediaType;
                    if (!StringsKt.startsWith$default(a.getValue(), "file:///", false, 2, null)) break block23;
                    String[] stringArray = a.getValue();
                    int n = 7;
                    boolean bl = false;
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = stringArray.substring(n);
                    Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).substring(startIndex)");
                    File file = new File(string2);
                    String[] stringArray2 = new String[]{"."};
                    switch ((String)CollectionsKt.last(StringsKt.split$default((CharSequence)a.getValue(), stringArray2, false, 0, 6, null))) {
                        case "jpg": 
                        case "jpeg": {
                            MediaType mediaType2 = MediaType.Companion.parse("image/jpeg");
                            mediaType = mediaType2;
                            Intrinsics.checkNotNull(mediaType2);
                            break;
                        }
                        case "png": {
                            MediaType mediaType3 = MediaType.Companion.parse("image/png");
                            mediaType = mediaType3;
                            Intrinsics.checkNotNull(mediaType3);
                            break;
                        }
                        case "gif": {
                            MediaType mediaType4 = MediaType.Companion.parse("image/gif");
                            mediaType = mediaType4;
                            Intrinsics.checkNotNull(mediaType4);
                            break;
                        }
                        case "pdf": {
                            MediaType mediaType5 = MediaType.Companion.parse("application/pdf");
                            mediaType = mediaType5;
                            Intrinsics.checkNotNull(mediaType5);
                            break;
                        }
                        default: {
                            MediaType mediaType6 = MediaType.Companion.parse("application/unknown");
                            mediaType = mediaType6;
                            Intrinsics.checkNotNull(mediaType6);
                        }
                    }
                    stringArray = new String[]{"/"};
                    String fileid = this.uploadFile(file, mediaType, (String)CollectionsKt.last(StringsKt.split$default((CharSequence)a.getValue(), stringArray, false, 0, 6, null)));
                    answerbody.put(Intrinsics.stringPlus("", ((Question)a.getQuestion()).getServer_id()), fileid);
                    continue;
                }
                answerbody.put(Intrinsics.stringPlus("", ((Question)a.getQuestion()).getServer_id()), a.getValue());
            }
        }
        body2.put("answers", answerbody);
        body2.put("questions_supported", true);
        body2.put("canceled_supported", true);
        String pd = "";
        if (pdf_data) {
            pd = "?pdf_data=true";
        }
        return this.postResource(Intrinsics.stringPlus(this.eventResourceUrl(eventSlug, "checkinlists/" + listId + "/positions/" + URLFragmentEncoder.STRICT.encode(secret, Charset.forName("UTF-8")) + "/redeem"), pd), body2);
    }

    @NotNull
    public final ApiResponse redeem(@NotNull List<Long> lists, @NotNull String secret, @Nullable Date datetime, boolean force, @Nullable String nonce, @Nullable List<Answer> answers, boolean ignore_unpaid, boolean pdf_data, @Nullable String type2) throws ApiException, JSONException {
        Intrinsics.checkNotNullParameter(lists, "lists");
        Intrinsics.checkNotNullParameter(secret, "secret");
        String dt = null;
        if (datetime != null) {
            dt = QueuedCheckIn.formatDatetime(datetime);
        }
        return this.redeem(lists, secret, dt, force, nonce, answers, ignore_unpaid, pdf_data, type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiResponse redeem(@NotNull List<Long> lists, @NotNull String secret, @Nullable String datetime, boolean force, @Nullable String nonce, @Nullable List<Answer> answers, boolean ignore_unpaid, boolean pdf_data, @Nullable String type2) throws ApiException, JSONException {
        void var13_17;
        JSONObject answerbody;
        JSONObject body2;
        block23: {
            Intrinsics.checkNotNullParameter(lists, "lists");
            Intrinsics.checkNotNullParameter(secret, "secret");
            body2 = new JSONObject();
            if (datetime != null) {
                body2.put("datetime", datetime);
            }
            body2.put("force", force);
            body2.put("ignore_unpaid", ignore_unpaid);
            body2.put("nonce", nonce);
            body2.put("type", type2);
            answerbody = new JSONObject();
            if (answers == null) break block23;
            for (Answer answer : answers) {
                block24: {
                    MediaType mediaType;
                    if (!StringsKt.startsWith$default(answer.getValue(), "file:///", false, 2, null)) break block24;
                    String[] stringArray = answer.getValue();
                    int n = 7;
                    boolean bl = false;
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string = stringArray.substring(n);
                    Intrinsics.checkNotNullExpressionValue(string, "(this as java.lang.String).substring(startIndex)");
                    File file = new File(string);
                    String[] stringArray2 = new String[]{"."};
                    switch ((String)CollectionsKt.last(StringsKt.split$default((CharSequence)answer.getValue(), stringArray2, false, 0, 6, null))) {
                        case "jpg": 
                        case "jpeg": {
                            MediaType mediaType2 = MediaType.Companion.parse("image/jpeg");
                            mediaType = mediaType2;
                            Intrinsics.checkNotNull(mediaType2);
                            break;
                        }
                        case "png": {
                            MediaType mediaType3 = MediaType.Companion.parse("image/png");
                            mediaType = mediaType3;
                            Intrinsics.checkNotNull(mediaType3);
                            break;
                        }
                        case "gif": {
                            MediaType mediaType4 = MediaType.Companion.parse("image/gif");
                            mediaType = mediaType4;
                            Intrinsics.checkNotNull(mediaType4);
                            break;
                        }
                        case "pdf": {
                            MediaType mediaType5 = MediaType.Companion.parse("application/pdf");
                            mediaType = mediaType5;
                            Intrinsics.checkNotNull(mediaType5);
                            break;
                        }
                        default: {
                            MediaType mediaType6 = MediaType.Companion.parse("application/unknown");
                            mediaType = mediaType6;
                            Intrinsics.checkNotNull(mediaType6);
                        }
                    }
                    stringArray = new String[]{"/"};
                    String fileid = this.uploadFile(file, mediaType, (String)CollectionsKt.last(StringsKt.split$default((CharSequence)answer.getValue(), stringArray, false, 0, 6, null)));
                    answerbody.put(Intrinsics.stringPlus("", ((Question)answer.getQuestion()).getServer_id()), fileid);
                    continue;
                }
                answerbody.put(Intrinsics.stringPlus("", ((Question)answer.getQuestion()).getServer_id()), answer.getValue());
            }
        }
        body2.put("answers", answerbody);
        body2.put("questions_supported", true);
        body2.put("canceled_supported", true);
        body2.put("secret", secret);
        JSONArray jlists = new JSONArray();
        Iterator<Long> iterator2 = lists.iterator();
        while (iterator2.hasNext()) {
            long l = ((Number)iterator2.next()).longValue();
            jlists.put(l);
        }
        body2.put("lists", jlists);
        String string = "";
        if (pdf_data) {
            String string2 = "?pdf_data=true";
        }
        return this.postResource(Intrinsics.stringPlus(this.organizerResourceUrl("checkinrpc/redeem"), var13_17), body2);
    }

    @NotNull
    public ApiResponse status(@NotNull String eventSlug, long listId) throws ApiException {
        ApiResponse apiResponse;
        Intrinsics.checkNotNullParameter(eventSlug, "eventSlug");
        try {
            apiResponse = this.fetchResource(this.eventResourceUrl(eventSlug, "checkinlists/" + listId + "/status"));
        }
        catch (ResourceNotModified resourceNotModified) {
            throw new FinalApiException("invalid error");
        }
        return apiResponse;
    }

    @NotNull
    public ApiResponse search(@NotNull String eventSlug, long listId, @Nullable String query, int page) throws ApiException {
        ApiResponse apiResponse;
        Intrinsics.checkNotNullParameter(eventSlug, "eventSlug");
        try {
            apiResponse = this.fetchResource(this.eventResourceUrl(eventSlug, "checkinlists/" + listId + "/positions") + "?ignore_status=true&page=" + page + "&search=" + URLEncoder.encode(query, "UTF-8"));
        }
        catch (ResourceNotModified resourceNotModified) {
            throw new FinalApiException("invalid error");
        }
        catch (UnsupportedEncodingException resourceNotModified) {
            throw new FinalApiException("invalid error");
        }
        return apiResponse;
    }

    @NotNull
    public ApiResponse search(@NotNull List<Long> lists, @Nullable String query, int page) throws ApiException {
        ApiResponse apiResponse;
        Intrinsics.checkNotNullParameter(lists, "lists");
        try {
            String url = this.organizerResourceUrl("checkinrpc/search") + "?ignore_status=true&page=" + page + "&search=" + URLEncoder.encode(query, "UTF-8");
            Iterator<Long> iterator2 = lists.iterator();
            while (iterator2.hasNext()) {
                long l = ((Number)iterator2.next()).longValue();
                url = url + "&list=" + l;
            }
            apiResponse = this.fetchResource(url);
        }
        catch (ResourceNotModified resourceNotModified) {
            throw new FinalApiException("invalid error");
        }
        catch (UnsupportedEncodingException resourceNotModified) {
            throw new FinalApiException("invalid error");
        }
        return apiResponse;
    }

    @NotNull
    public final String apiURL(@NotNull String suffix) {
        String string;
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        try {
            string = new URL(new URL(this.url), Intrinsics.stringPlus("/api/v1/", suffix)).toString();
            Intrinsics.checkNotNullExpressionValue(string, "{\n            URL(URL(ur\u2026ix\").toString()\n        }");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }

    @NotNull
    public final String organizerResourceUrl(@NotNull String resource) {
        String string;
        Intrinsics.checkNotNullParameter(resource, "resource");
        try {
            string = new URL(new URL(this.url), "/api/v1/organizers/" + this.orgaSlug + '/' + resource + '/').toString();
            Intrinsics.checkNotNullExpressionValue(string, "{\n            URL(URL(ur\u2026e/\").toString()\n        }");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }

    @NotNull
    public final String eventResourceUrl(@NotNull String eventSlug, @NotNull String resource) {
        String string;
        Intrinsics.checkNotNullParameter(eventSlug, "eventSlug");
        Intrinsics.checkNotNullParameter(resource, "resource");
        try {
            string = new URL(new URL(this.url), "/api/v1/organizers/" + this.orgaSlug + "/events/" + eventSlug + '/' + resource + '/').toString();
            Intrinsics.checkNotNullExpressionValue(string, "{\n            URL(URL(ur\u2026e/\").toString()\n        }");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }

    @NotNull
    public ApiResponse deleteResource(@NotNull String full_url, @Nullable String idempotency_key) throws ApiException {
        ApiResponse apiResponse;
        Intrinsics.checkNotNullParameter(full_url, "full_url");
        Request.Builder request = Request.Builder.delete$default(new Request.Builder().url(full_url), null, 1, null).header("Authorization", Intrinsics.stringPlus("Device ", this.key));
        if (this.acceptLanguage != null) {
            request = request.header("Accept-Language", this.acceptLanguage);
        }
        if (idempotency_key != null) {
            request = request.header("X-Idempotency-Key", idempotency_key);
        }
        try {
            apiResponse = PretixApi.apiCall$default(this, request.build(), false, false, 4, null);
        }
        catch (ResourceNotModified resourceNotModified) {
            resourceNotModified.printStackTrace();
            throw new FinalApiException("Resource not modified");
        }
        return apiResponse;
    }

    public static /* synthetic */ ApiResponse deleteResource$default(PretixApi pretixApi, String string, String string2, int n, Object object) throws ApiException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deleteResource");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return pretixApi.deleteResource(string, string2);
    }

    @NotNull
    public final ApiResponse patchResource(@NotNull String full_url, @NotNull JSONObject data2) throws ApiException {
        Intrinsics.checkNotNullParameter(full_url, "full_url");
        Intrinsics.checkNotNullParameter(data2, "data");
        return this.patchResource(full_url, data2, null);
    }

    @NotNull
    public ApiResponse patchResource(@Nullable String full_url, @NotNull JSONObject data2, @Nullable String idempotency_key) throws ApiException {
        Intrinsics.checkNotNullParameter(data2, "data");
        Request.Builder builder = new Request.Builder();
        String string = full_url;
        Intrinsics.checkNotNull(string);
        Request.Builder builder2 = builder.url(string);
        Object object = data2.toString();
        Intrinsics.checkNotNullExpressionValue(object, "data.toString()");
        Request.Builder request = builder2.patch(RequestBody.Companion.create((String)object, MediaType.Companion.get("application/json"))).header("Authorization", Intrinsics.stringPlus("Device ", this.key));
        if (this.acceptLanguage != null) {
            request = request.header("Accept-Language", this.acceptLanguage);
        }
        if (idempotency_key != null) {
            request = request.header("X-Idempotency-Key", idempotency_key);
        }
        try {
            object = PretixApi.apiCall$default(this, request.build(), false, false, 6, null);
        }
        catch (ResourceNotModified resourceNotModified) {
            resourceNotModified.printStackTrace();
            throw new FinalApiException("Resource not modified");
        }
        return object;
    }

    @NotNull
    public final ApiResponse postResource(@NotNull String full_url, @NotNull JSONObject data2) throws ApiException {
        Intrinsics.checkNotNullParameter(full_url, "full_url");
        Intrinsics.checkNotNullParameter(data2, "data");
        String string = data2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "data.toString()");
        return this.postResource(full_url, string, null);
    }

    @NotNull
    public final ApiResponse postResource(@NotNull String full_url, @NotNull JSONArray data2) throws ApiException {
        Intrinsics.checkNotNullParameter(full_url, "full_url");
        Intrinsics.checkNotNullParameter(data2, "data");
        String string = data2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "data.toString()");
        return this.postResource(full_url, string, null);
    }

    @NotNull
    public final ApiResponse postResource(@NotNull String full_url, @NotNull JSONObject data2, @Nullable String idempotency_key) throws ApiException {
        Intrinsics.checkNotNullParameter(full_url, "full_url");
        Intrinsics.checkNotNullParameter(data2, "data");
        String string = data2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "data.toString()");
        return this.postResource(full_url, string, idempotency_key);
    }

    @NotNull
    public ApiResponse postResource(@NotNull String full_url, @NotNull String data2, @Nullable String idempotency_key) throws ApiException {
        ApiResponse apiResponse;
        Intrinsics.checkNotNullParameter(full_url, "full_url");
        Intrinsics.checkNotNullParameter(data2, "data");
        Request.Builder request = new Request.Builder().url(full_url).post(RequestBody.Companion.create(data2, MediaType.Companion.get("application/json"))).header("Authorization", Intrinsics.stringPlus("Device ", this.key));
        if (this.acceptLanguage != null) {
            request = request.header("Accept-Language", this.acceptLanguage);
        }
        if (idempotency_key != null) {
            request = request.header("X-Idempotency-Key", idempotency_key);
        }
        try {
            apiResponse = PretixApi.apiCall$default(this, request.build(), false, false, 6, null);
        }
        catch (ResourceNotModified resourceNotModified) {
            resourceNotModified.printStackTrace();
            throw new FinalApiException("Resource not modified");
        }
        return apiResponse;
    }

    @NotNull
    public ApiResponse fetchResource(@NotNull String full_url, @Nullable String if_modified_since) throws ApiException, ResourceNotModified {
        Intrinsics.checkNotNullParameter(full_url, "full_url");
        Request.Builder request = new Request.Builder().url(full_url).header("Authorization", Intrinsics.stringPlus("Device ", this.key));
        if (this.acceptLanguage != null) {
            request = request.header("Accept-Language", this.acceptLanguage);
        }
        if (if_modified_since != null) {
            request = request.header("If-Modified-Since", if_modified_since);
        }
        return PretixApi.apiCall$default(this, request.get().build(), false, false, 6, null);
    }

    public static /* synthetic */ ApiResponse fetchResource$default(PretixApi pretixApi, String string, String string2, int n, Object object) throws ApiException, ResourceNotModified {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetchResource");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return pretixApi.fetchResource(string, string2);
    }

    @NotNull
    public final ApiResponse fetchResource(@NotNull String full_url) throws ApiException, ResourceNotModified {
        Intrinsics.checkNotNullParameter(full_url, "full_url");
        return this.fetchResource(full_url, null);
    }

    @Nullable
    public ApiResponse downloadFile(@NotNull String full_url) throws ApiException {
        ApiResponse apiResponse;
        Intrinsics.checkNotNullParameter(full_url, "full_url");
        Request.Builder request = new Request.Builder().url(full_url).header("Authorization", Intrinsics.stringPlus("Device ", this.key));
        if (this.acceptLanguage != null) {
            request = request.header("Accept-Language", this.acceptLanguage);
        }
        try {
            apiResponse = PretixApi.apiCall$default(this, request.build(), false, false, 4, null);
        }
        catch (ResourceNotModified resourceNotModified) {
            resourceNotModified.printStackTrace();
            throw new FinalApiException("Resource not modified");
        }
        return apiResponse;
    }

    private final ApiResponse apiCall(Request request, boolean json2, boolean is_retry) throws ApiException, ResourceNotModified {
        Response response;
        Response response2 = null;
        try {
            response = this.client.newCall(request).execute();
        }
        catch (SSLPeerUnverifiedException e) {
            if (!is_retry) {
                this.client.connectionPool().evictAll();
                return this.apiCall(request, json2, is_retry);
            }
            e.printStackTrace();
            throw new ApiException("Error while creating a secure connection.", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ApiException(Intrinsics.stringPlus("Connection error: ", e.getMessage()), e);
        }
        response2 = response;
        CharSequence e = request.url().toString();
        Object object = "^(.*)key=([0-9A-Za-z]+)([^0-9A-Za-z]*)";
        boolean bl = false;
        object = new Regex((String)object);
        String string = "$1key=redacted$3";
        boolean bl2 = false;
        String safe_url = ((Regex)object).replace(e, string);
        this.sentry.addHttpBreadcrumb(safe_url, request.method(), response2.code());
        Object body2 = "";
        if (json2) {
            try {
                ResponseBody responseBody = response2.body();
                Intrinsics.checkNotNull(responseBody);
                object = responseBody.string();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                throw new ApiException(Intrinsics.stringPlus("Connection error: ", e2.getMessage()), e2);
            }
            body2 = object;
        }
        if (response2.code() >= 500) {
            response2.close();
            throw new ApiException(Intrinsics.stringPlus("Server error: ", response2.code()));
        }
        if (!(response2.code() != 404 || json2 && StringsKt.startsWith$default((String)body2, "{", false, 2, null))) {
            response2.close();
            throw new NotFoundApiException("Server error: Resource not found.");
        }
        if (response2.code() == 304) {
            throw new ResourceNotModified();
        }
        if (response2.code() == 403) {
            response2.close();
            throw new FinalApiException("Server error: Permission denied.");
        }
        if (response2.code() == 409) {
            response2.close();
            throw new ConflictApiException("Server error: " + response2.code() + ": " + (String)body2);
        }
        if (response2.code() >= 405) {
            response2.close();
            throw new FinalApiException("Server error: " + response2.code() + '.');
        }
        if (response2.code() == 401 && StringsKt.startsWith$default((String)body2, "{", false, 2, null)) {
            try {
                JSONObject err = new JSONObject((String)body2);
                if (Intrinsics.areEqual(err.optString("detail", ""), "Device access has been revoked.")) {
                    throw new DeviceAccessRevokedException("Device access has been revoked.");
                }
            }
            catch (JSONException e3) {
                e3.printStackTrace();
            }
        }
        try {
            ApiResponse apiResponse;
            if (json2) {
                if (StringsKt.startsWith$default((String)body2, "[", false, 2, null)) {
                    body2 = "{\"content\": " + (String)body2 + '}';
                }
                apiResponse = new ApiResponse(new JSONObject((String)body2), response2);
            } else {
                apiResponse = new ApiResponse(null, response2);
            }
            object = apiResponse;
        }
        catch (JSONException e4) {
            e4.printStackTrace();
            this.sentry.captureException(e4);
            Object object2 = body2;
            int n = 0;
            int n2 = 100;
            boolean bl3 = false;
            Object object3 = object2;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)object3).substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            throw new ApiException(Intrinsics.stringPlus("Invalid JSON received: ", string2), e4);
        }
        return object;
    }

    static /* synthetic */ ApiResponse apiCall$default(PretixApi pretixApi, Request request, boolean bl, boolean bl2, int n, Object object) throws ApiException, ResourceNotModified {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: apiCall");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return pretixApi.apiCall(request, bl, bl2);
    }

    public void putFile(@NotNull String url, @NotNull File file, @NotNull MediaType mediaType, @NotNull String filename) throws ApiException {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(mediaType, "mediaType");
        Intrinsics.checkNotNullParameter(filename, "filename");
        Request.Builder request = new Request.Builder().url(url).put(RequestBody.Companion.create(file, mediaType)).header("Content-Disposition", "attachment; filename=\"" + filename + '\"').header("Authorization", Intrinsics.stringPlus("Device ", this.key));
        if (this.acceptLanguage != null) {
            request = request.header("Accept-Language", this.acceptLanguage);
        }
        try {
            ApiResponse resp = PretixApi.apiCall$default(this, request.build(), false, false, 6, null);
            if (resp.getResponse().code() != 201 && resp.getResponse().code() != 200) {
                throw new FinalApiException(Intrinsics.stringPlus("Could not upload file: ", resp.getData()));
            }
        }
        catch (ResourceNotModified exc) {
            throw new FinalApiException("resource not modified");
        }
        catch (JSONException exc) {
            throw new FinalApiException("JSONException");
        }
    }

    @NotNull
    public String uploadFile(@NotNull File file, @NotNull MediaType mediaType, @NotNull String filename) throws ApiException {
        String string;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(mediaType, "mediaType");
        Intrinsics.checkNotNullParameter(filename, "filename");
        Request.Builder request = new Request.Builder().url(this.apiURL("upload")).post(RequestBody.Companion.create(file, mediaType)).header("Content-Disposition", "attachment; filename=\"" + filename + '\"').header("Authorization", Intrinsics.stringPlus("Device ", this.key));
        if (this.acceptLanguage != null) {
            request = request.header("Accept-Language", this.acceptLanguage);
        }
        try {
            ApiResponse resp = PretixApi.apiCall$default(this, request.build(), false, false, 6, null);
            if (resp.getResponse().code() != 201) {
                throw new FinalApiException(Intrinsics.stringPlus("Could not upload file: ", resp.getData()));
            }
            JSONObject jSONObject = resp.getData();
            Intrinsics.checkNotNull(jSONObject);
            string = jSONObject.getString("id");
            Intrinsics.checkNotNullExpressionValue(string, "{\n            val resp =\u2026getString(\"id\")\n        }");
        }
        catch (ResourceNotModified exc) {
            throw new FinalApiException("resource not modified");
        }
        catch (JSONException exc) {
            throw new FinalApiException("JSONException");
        }
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Leu/pretix/libpretixsync/api/PretixApi$ApiResponse;", "", "data", "Lorg/json/JSONObject;", "response", "Lokhttp3/Response;", "(Leu/pretix/libpretixsync/api/PretixApi;Lorg/json/JSONObject;Lokhttp3/Response;)V", "getData", "()Lorg/json/JSONObject;", "getResponse", "()Lokhttp3/Response;", "libpretixsync"})
    public final class ApiResponse {
        @Nullable
        private final JSONObject data;
        @NotNull
        private final Response response;

        public ApiResponse(@NotNull JSONObject data2, Response response) {
            Intrinsics.checkNotNullParameter(PretixApi.this, "this$0");
            Intrinsics.checkNotNullParameter(response, "response");
            this.data = data2;
            this.response = response;
        }

        @Nullable
        public final JSONObject getData() {
            return this.data;
        }

        @NotNull
        public final Response getResponse() {
            return this.response;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Leu/pretix/libpretixsync/api/PretixApi$Companion;", "", "()V", "JSON", "Lokhttp3/MediaType;", "getJSON", "()Lokhttp3/MediaType;", "SUPPORTED_API_VERSION", "", "fromConfig", "Leu/pretix/libpretixsync/api/PretixApi;", "config", "Leu/pretix/libpretixsync/config/ConfigStore;", "httpClientFactory", "Leu/pretix/libpretixsync/api/HttpClientFactory;", "acceptLanguage", "", "libpretixsync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MediaType getJSON() {
            return JSON;
        }

        @NotNull
        public final PretixApi fromConfig(@NotNull ConfigStore config, @Nullable HttpClientFactory httpClientFactory, @Nullable String acceptLanguage) {
            Intrinsics.checkNotNullParameter(config, "config");
            Object object = config.getApiUrl();
            Intrinsics.checkNotNullExpressionValue(object, "config.apiUrl");
            String string = object;
            object = config.getApiKey();
            Intrinsics.checkNotNullExpressionValue(object, "config.apiKey");
            String string2 = object;
            object = config.getOrganizerSlug();
            Intrinsics.checkNotNullExpressionValue(object, "config.organizerSlug");
            String string3 = object;
            object = httpClientFactory;
            return new PretixApi(string, string2, string3, config.getApiVersion(), (HttpClientFactory)(object == null ? (HttpClientFactory)new DefaultHttpClientFactory() : object), acceptLanguage);
        }

        public static /* synthetic */ PretixApi fromConfig$default(Companion companion, ConfigStore configStore, HttpClientFactory httpClientFactory, String string, int n, Object object) {
            if ((n & 2) != 0) {
                httpClientFactory = null;
            }
            if ((n & 4) != 0) {
                string = null;
            }
            return companion.fromConfig(configStore, httpClientFactory, string);
        }

        @NotNull
        public final PretixApi fromConfig(@NotNull ConfigStore config) {
            Intrinsics.checkNotNullParameter(config, "config");
            return eu.pretix.libpretixsync.api.PretixApi$Companion.fromConfig$default(this, config, null, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

