/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.pretixscan.scanproxy;

import eu.pretix.libpretixsync.config.ConfigStore;
import eu.pretix.pretixscan.scanproxy.Server;
import eu.pretix.pretixscan.scanproxy.db.SyncedEventEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\r\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0003H\u0016J\b\u0010$\u001a\u00020\u001cH\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0016J\r\u0010'\u001a\u00020(H\u0016\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020(H\u0016J\b\u0010+\u001a\u00020(H\u0016J\b\u0010,\u001a\u00020(H\u0016J\b\u0010-\u001a\u00020\u0003H\u0016J\b\u0010.\u001a\u00020(H\u0016J\b\u0010/\u001a\u00020\u0003H\u0016J\r\u00100\u001a\u00020(H\u0016\u00a2\u0006\u0002\u0010)J\u0019\u00101\u001a\u0004\u0018\u00010(2\b\u00102\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00103J\u0019\u00104\u001a\u0004\u0018\u00010(2\b\u00102\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00103J\b\u00105\u001a\u00020\u0003H\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u000307H\u0016J\b\u00108\u001a\u00020\u001eH\u0016J\b\u00109\u001a\u00020\u001eH\u0016J&\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020(J\u0012\u0010@\u001a\u00020;2\b\u0010A\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010B\u001a\u00020;2\b\u0010A\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u0010C\u001a\u00020;2\b\u0010A\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010D\u001a\u00020;2\u0006\u0010A\u001a\u00020\u001cH\u0016J\u0016\u0010E\u001a\u00020;2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0016J\u0010\u0010G\u001a\u00020;2\u0006\u0010A\u001a\u00020(H\u0016J\u0010\u0010H\u001a\u00020;2\u0006\u0010I\u001a\u00020(H\u0016J\u0010\u0010J\u001a\u00020;2\u0006\u0010A\u001a\u00020(H\u0016J\u0010\u0010K\u001a\u00020;2\u0006\u0010A\u001a\u00020(H\u0016J\u0012\u0010L\u001a\u00020;2\b\u0010A\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010M\u001a\u00020;2\u0006\u0010A\u001a\u00020(H\u0016J\u000e\u0010N\u001a\u00020;2\u0006\u0010A\u001a\u00020\u0003J\u0006\u0010O\u001a\u00020;R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Leu/pretix/pretixscan/scanproxy/PretixScanConfig;", "Leu/pretix/libpretixsync/config/ConfigStore;", "data_dir", "", "(Ljava/lang/String;)V", "PREFS_KEY_API_DEVICE_ID", "PREFS_KEY_API_KEY", "PREFS_KEY_API_URL", "PREFS_KEY_API_VERSION", "PREFS_KEY_DEVICE_NAME", "PREFS_KEY_KNOWN_DEVICE_INFO", "PREFS_KEY_KNOWN_DEVICE_VERSION", "PREFS_KEY_KNOWN_GATE_NAME", "PREFS_KEY_KNOWN_LIVE_EVENT_SLUGS", "PREFS_KEY_KNOWN_PRETIX_VERSION", "PREFS_KEY_LAST_CLEANUP", "PREFS_KEY_LAST_DOWNLOAD", "PREFS_KEY_LAST_FAILED_SYNC", "PREFS_KEY_LAST_FAILED_SYNC_MSG", "PREFS_KEY_LAST_STATUS_DATA", "PREFS_KEY_LAST_SYNC", "PREFS_KEY_ORGANIZER_SLUG", "prefs", "Ljava/util/prefs/Preferences;", "kotlin.jvm.PlatformType", "getApiKey", "getApiUrl", "getApiVersion", "", "getAutoSwitchRequested", "", "()Ljava/lang/Boolean;", "getDeviceKnownGateName", "getDeviceKnownInfo", "Lorg/json/JSONObject;", "getDeviceKnownName", "getDeviceKnownVersion", "getKnownLiveEventSlugs", "", "getKnownPretixVersion", "", "()Ljava/lang/Long;", "getLastCleanup", "getLastDownload", "getLastFailedSync", "getLastFailedSyncMsg", "getLastSync", "getOrganizerSlug", "getPosId", "getSelectedCheckinListForEvent", "event", "(Ljava/lang/String;)Ljava/lang/Long;", "getSelectedSubeventForEvent", "getSyncCycleId", "getSynchronizedEvents", "", "isConfigured", "isDebug", "setDeviceConfig", "", "url", "key", "orga_slug", "device_id", "setDeviceKnownGateName", "value", "setDeviceKnownInfo", "setDeviceKnownName", "setDeviceKnownVersion", "setKnownLiveEventSlugs", "slugs", "setKnownPretixVersion", "setLastCleanup", "val", "setLastDownload", "setLastFailedSync", "setLastFailedSyncMsg", "setLastSync", "setOrganizerSlug", "wipe", "server"})
public final class PretixScanConfig
implements ConfigStore {
    @NotNull
    private String data_dir;
    private final Preferences prefs;
    @NotNull
    private final String PREFS_KEY_API_URL;
    @NotNull
    private final String PREFS_KEY_API_KEY;
    @NotNull
    private final String PREFS_KEY_API_DEVICE_ID;
    @NotNull
    private final String PREFS_KEY_ORGANIZER_SLUG;
    @NotNull
    private final String PREFS_KEY_API_VERSION;
    @NotNull
    private final String PREFS_KEY_DEVICE_NAME;
    @NotNull
    private final String PREFS_KEY_LAST_SYNC;
    @NotNull
    private final String PREFS_KEY_LAST_FAILED_SYNC;
    @NotNull
    private final String PREFS_KEY_LAST_FAILED_SYNC_MSG;
    @NotNull
    private final String PREFS_KEY_LAST_DOWNLOAD;
    @NotNull
    private final String PREFS_KEY_LAST_STATUS_DATA;
    @NotNull
    private final String PREFS_KEY_LAST_CLEANUP;
    @NotNull
    private final String PREFS_KEY_KNOWN_DEVICE_VERSION;
    @NotNull
    private final String PREFS_KEY_KNOWN_DEVICE_INFO;
    @NotNull
    private final String PREFS_KEY_KNOWN_PRETIX_VERSION;
    @NotNull
    private final String PREFS_KEY_KNOWN_GATE_NAME;
    @NotNull
    private final String PREFS_KEY_KNOWN_LIVE_EVENT_SLUGS;

    public PretixScanConfig(@NotNull String data_dir) {
        Intrinsics.checkNotNullParameter(data_dir, "data_dir");
        this.data_dir = data_dir;
        this.prefs = Preferences.userNodeForPackage(PretixScanConfig.class);
        this.PREFS_KEY_API_URL = "pretix_api_url";
        this.PREFS_KEY_API_KEY = "pretix_api_key";
        this.PREFS_KEY_API_DEVICE_ID = "pretix_api_device_id";
        this.PREFS_KEY_ORGANIZER_SLUG = "pretix_api_organizer_slug";
        this.PREFS_KEY_API_VERSION = "pretix_api_version";
        this.PREFS_KEY_DEVICE_NAME = "device_name";
        this.PREFS_KEY_LAST_SYNC = "last_sync";
        this.PREFS_KEY_LAST_FAILED_SYNC = "last_failed_sync";
        this.PREFS_KEY_LAST_FAILED_SYNC_MSG = "last_failed_sync_msg";
        this.PREFS_KEY_LAST_DOWNLOAD = "last_download";
        this.PREFS_KEY_LAST_STATUS_DATA = "last_status_data";
        this.PREFS_KEY_LAST_CLEANUP = "last_cleanup";
        this.PREFS_KEY_KNOWN_DEVICE_VERSION = "known_device_version";
        this.PREFS_KEY_KNOWN_DEVICE_INFO = "known_device_info";
        this.PREFS_KEY_KNOWN_PRETIX_VERSION = "known_pretix_version";
        this.PREFS_KEY_KNOWN_GATE_NAME = "known_gate_name";
        this.PREFS_KEY_KNOWN_LIVE_EVENT_SLUGS = "cache_known_live_event_slugs";
    }

    public final void setDeviceConfig(@NotNull String url, @NotNull String key, @NotNull String orga_slug, long device_id) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(orga_slug, "orga_slug");
        this.prefs.put(this.PREFS_KEY_API_URL, url);
        this.prefs.put(this.PREFS_KEY_API_KEY, key);
        this.prefs.putLong(this.PREFS_KEY_API_DEVICE_ID, device_id);
        this.prefs.put(this.PREFS_KEY_ORGANIZER_SLUG, orga_slug);
        this.prefs.remove(this.PREFS_KEY_LAST_DOWNLOAD);
        this.prefs.remove(this.PREFS_KEY_LAST_SYNC);
        this.prefs.remove(this.PREFS_KEY_LAST_FAILED_SYNC);
        this.prefs.remove(this.PREFS_KEY_LAST_CLEANUP);
        this.prefs.remove(this.PREFS_KEY_LAST_STATUS_DATA);
        this.prefs.remove(this.PREFS_KEY_DEVICE_NAME);
        this.prefs.flush();
    }

    public final void wipe() {
        this.prefs.clear();
        File f = new File(this.data_dir, Intrinsics.stringPlus(this.PREFS_KEY_LAST_STATUS_DATA, ".json"));
        if (f.exists()) {
            f.delete();
        }
        this.prefs.flush();
    }

    @Override
    public boolean isDebug() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isConfigured() {
        if (this.prefs.get(this.PREFS_KEY_API_URL, null) == null) return false;
        CharSequence charSequence = this.getApiUrl();
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        return true;
    }

    @Override
    @NotNull
    public String getApiUrl() {
        String string = this.prefs.get(this.PREFS_KEY_API_URL, "");
        Intrinsics.checkNotNullExpressionValue(string, "prefs.get(PREFS_KEY_API_URL, \"\")");
        return string;
    }

    @Override
    @NotNull
    public String getApiKey() {
        String string = this.prefs.get(this.PREFS_KEY_API_KEY, "");
        Intrinsics.checkNotNullExpressionValue(string, "prefs.get(PREFS_KEY_API_KEY, \"\")");
        return string;
    }

    @Override
    public long getLastDownload() {
        return this.prefs.getLong(this.PREFS_KEY_LAST_DOWNLOAD, 0L);
    }

    @Override
    @NotNull
    public Boolean getAutoSwitchRequested() {
        return false;
    }

    @Override
    public void setLastDownload(long value) {
        this.prefs.putLong(this.PREFS_KEY_LAST_DOWNLOAD, value);
        this.prefs.flush();
    }

    @Override
    public long getLastSync() {
        return this.prefs.getLong(this.PREFS_KEY_LAST_SYNC, 0L);
    }

    @Override
    public void setLastSync(long value) {
        this.prefs.putLong(this.PREFS_KEY_LAST_SYNC, value);
        this.prefs.flush();
    }

    @Override
    public long getLastFailedSync() {
        return this.prefs.getLong(this.PREFS_KEY_LAST_FAILED_SYNC, 0L);
    }

    @Override
    public void setLastFailedSync(long value) {
        this.prefs.putLong(this.PREFS_KEY_LAST_FAILED_SYNC, value);
        this.prefs.flush();
    }

    @Override
    @NotNull
    public String getLastFailedSyncMsg() {
        String string = this.prefs.get(this.PREFS_KEY_LAST_FAILED_SYNC_MSG, "");
        Intrinsics.checkNotNullExpressionValue(string, "prefs.get(PREFS_KEY_LAST_FAILED_SYNC_MSG, \"\")");
        return string;
    }

    @Override
    @NotNull
    public String getDeviceKnownGateName() {
        String string = this.prefs.get(this.PREFS_KEY_KNOWN_GATE_NAME, "");
        Intrinsics.checkNotNullExpressionValue(string, "prefs.get(PREFS_KEY_KNOWN_GATE_NAME, \"\")");
        return string;
    }

    @Override
    public void setDeviceKnownGateName(@Nullable String value) {
        if (value == null) {
            this.prefs.remove(this.PREFS_KEY_KNOWN_GATE_NAME);
        } else {
            this.prefs.put(this.PREFS_KEY_KNOWN_GATE_NAME, value);
        }
        this.prefs.flush();
    }

    @Override
    public void setLastFailedSyncMsg(@Nullable String value) {
        this.prefs.put(this.PREFS_KEY_LAST_FAILED_SYNC_MSG, value);
        this.prefs.flush();
    }

    @Override
    @NotNull
    public String getOrganizerSlug() {
        String string = this.prefs.get(this.PREFS_KEY_ORGANIZER_SLUG, "");
        Intrinsics.checkNotNullExpressionValue(string, "prefs.get(PREFS_KEY_ORGANIZER_SLUG, \"\")");
        return string;
    }

    public final void setOrganizerSlug(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.prefs.put(this.PREFS_KEY_ORGANIZER_SLUG, value);
        this.prefs.flush();
    }

    @Override
    @NotNull
    public Long getPosId() {
        return 0L;
    }

    @Override
    public int getApiVersion() {
        return this.prefs.getInt(this.PREFS_KEY_API_VERSION, 4);
    }

    @Override
    @NotNull
    public String getSyncCycleId() {
        return "cycle";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getSynchronizedEvents() {
        void $this$mapTo$iv$iv;
        Object r = Server.INSTANCE.getProxyData().select(Reflection.getOrCreateKotlinClass(SyncedEventEntity.class)).get();
        Intrinsics.checkNotNullExpressionValue(r, "Server.proxyData select \u2026ventEntity::class)).get()");
        Iterable $this$map$iv = (Iterable)r;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SyncedEventEntity syncedEventEntity = (SyncedEventEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getSlug();
            collection.add(string);
        }
        return CollectionsKt.toList((List)destination$iv$iv);
    }

    @Override
    @Nullable
    public Long getSelectedSubeventForEvent(@Nullable String event) {
        return null;
    }

    @Override
    @Nullable
    public Long getSelectedCheckinListForEvent(@Nullable String event) {
        return null;
    }

    @Override
    public int getDeviceKnownVersion() {
        return this.prefs.getInt(this.PREFS_KEY_KNOWN_DEVICE_VERSION, 0);
    }

    @Override
    public void setDeviceKnownVersion(int value) {
        this.prefs.putInt(this.PREFS_KEY_KNOWN_DEVICE_VERSION, value);
        this.prefs.flush();
    }

    @Override
    @NotNull
    public JSONObject getDeviceKnownInfo() {
        String string = this.prefs.get(this.PREFS_KEY_KNOWN_DEVICE_INFO, "{}");
        return new JSONObject(string == null ? "{}" : string);
    }

    @Override
    public void setDeviceKnownInfo(@Nullable JSONObject value) {
        String string;
        JSONObject jSONObject = value;
        this.prefs.put(this.PREFS_KEY_KNOWN_DEVICE_INFO, jSONObject == null ? "{}" : ((string = jSONObject.toString()) == null ? "{}" : string));
        this.prefs.flush();
    }

    public void setKnownPretixVersion(long value) {
        this.prefs.putLong(this.PREFS_KEY_KNOWN_PRETIX_VERSION, value);
        this.prefs.flush();
    }

    @Override
    @NotNull
    public Long getKnownPretixVersion() {
        return this.prefs.getLong(this.PREFS_KEY_KNOWN_PRETIX_VERSION, 0L);
    }

    @Override
    @NotNull
    public String getDeviceKnownName() {
        String string = this.prefs.get(this.PREFS_KEY_DEVICE_NAME, "");
        Intrinsics.checkNotNullExpressionValue(string, "prefs.get(PREFS_KEY_DEVICE_NAME, \"\")");
        return string;
    }

    @Override
    public void setDeviceKnownName(@Nullable String value) {
        this.prefs.put(this.PREFS_KEY_DEVICE_NAME, value);
        this.prefs.flush();
    }

    @Override
    public long getLastCleanup() {
        return this.prefs.getLong(this.PREFS_KEY_LAST_CLEANUP, 0L);
    }

    @Override
    public void setLastCleanup(long val) {
        this.prefs.putLong(this.PREFS_KEY_LAST_CLEANUP, val);
        this.prefs.flush();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getKnownLiveEventSlugs() {
        void $this$filterTo$iv$iv;
        String[] stringArray = this.prefs.get(this.PREFS_KEY_KNOWN_LIVE_EVENT_SLUGS, "");
        Intrinsics.checkNotNullExpressionValue(stringArray, "prefs.get(PREFS_KEY_KNOWN_LIVE_EVENT_SLUGS, \"\")");
        CharSequence charSequence = (CharSequence)stringArray;
        stringArray = new String[]{","};
        Iterable $this$filter$iv = StringsKt.split$default(charSequence, stringArray, false, 0, 6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence2 = it;
            boolean bl2 = false;
            boolean bl3 = charSequence2.length() > 0;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Override
    public void setKnownLiveEventSlugs(@NotNull Set<String> slugs) {
        Intrinsics.checkNotNullParameter(slugs, "slugs");
        this.prefs.put(this.PREFS_KEY_KNOWN_LIVE_EVENT_SLUGS, CollectionsKt.joinToString$default(slugs, ",", null, null, 0, null, null, 62, null));
        this.prefs.flush();
    }
}

