/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http.staticfiles;

import io.javalin.Javalin;
import io.javalin.core.util.OptionalDependency;
import io.javalin.core.util.Util;
import io.javalin.http.LeveledBrotliStream;
import io.javalin.http.LeveledGzipStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lio/javalin/http/staticfiles/PrecompressingResourceHandler;", "", "()V", "compressedFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getCompressedFiles", "()Ljava/util/concurrent/ConcurrentHashMap;", "excludedMimeTypes", "", "getExcludedMimeTypes", "()Ljava/util/Set;", "resourceMaxSize", "", "getResourceMaxSize", "()I", "setResourceMaxSize", "(I)V", "excludedMimeType", "", "mimeType", "getCompressedByteArray", "resource", "Lorg/eclipse/jetty/util/resource/Resource;", "type", "Lio/javalin/http/staticfiles/PrecompressingResourceHandler$CompressType;", "getStaticResourceByteArray", "target", "handle", "req", "Ljavax/servlet/http/HttpServletRequest;", "res", "Ljavax/servlet/http/HttpServletResponse;", "CompressType", "javalin"})
public final class PrecompressingResourceHandler {
    @NotNull
    private static final ConcurrentHashMap<String, byte[]> compressedFiles;
    private static int resourceMaxSize;
    @NotNull
    private static final Set<String> excludedMimeTypes;
    public static final PrecompressingResourceHandler INSTANCE;

    @NotNull
    public final ConcurrentHashMap<String, byte[]> getCompressedFiles() {
        return compressedFiles;
    }

    public final int getResourceMaxSize() {
        return resourceMaxSize;
    }

    public final void setResourceMaxSize(int n) {
        resourceMaxSize = n;
    }

    @NotNull
    public final Set<String> getExcludedMimeTypes() {
        return excludedMimeTypes;
    }

    public final boolean handle(@NotNull Resource resource, @NotNull HttpServletRequest req, @NotNull HttpServletResponse res) {
        Intrinsics.checkParameterIsNotNull(resource, "resource");
        Intrinsics.checkParameterIsNotNull(req, "req");
        Intrinsics.checkParameterIsNotNull(res, "res");
        if (resource.exists() && !resource.isDirectory()) {
            boolean bl;
            Object object;
            String contentType;
            Object object2 = req.getAttribute("jetty-target");
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            String target = (String)object2;
            String string = req.getHeader("Accept-Encoding");
            if (string == null) {
                string = "";
            }
            CompressType acceptCompressType = CompressType.Companion.getByAcceptEncoding(string);
            String string2 = contentType = MimeTypes.getDefaultMimeByExtension(target);
            Intrinsics.checkExpressionValueIsNotNull(string2, "contentType");
            if (this.excludedMimeType(string2)) {
                acceptCompressType = CompressType.NONE;
            }
            byte[] byArray = this.getStaticResourceByteArray(resource, target, acceptCompressType);
            if (byArray == null) {
                return false;
            }
            byte[] resultByteArray = byArray;
            res.setContentLength(resultByteArray.length);
            res.setHeader("Content-Type", contentType);
            if (acceptCompressType != CompressType.NONE) {
                res.setHeader("Content-Encoding", acceptCompressType.getTypeName());
            }
            String weakETag = resource.getWeakETag();
            String string3 = req.getHeader("If-None-Match");
            if (string3 != null) {
                object = string3;
                bl = false;
                boolean bl2 = false;
                String etag = object;
                boolean bl3 = false;
                if (Intrinsics.areEqual(etag, weakETag)) {
                    res.setStatus(304);
                    return true;
                }
            }
            res.setHeader("ETag", weakETag);
            object = resultByteArray;
            bl = false;
            InputStream inputStream2 = new ByteArrayInputStream((byte[])object);
            ServletOutputStream servletOutputStream = res.getOutputStream();
            Intrinsics.checkExpressionValueIsNotNull(servletOutputStream, "res.outputStream");
            ByteStreamsKt.copyTo$default(inputStream2, servletOutputStream, 0, 2, null);
            res.getOutputStream().close();
            return true;
        }
        return false;
    }

    private final byte[] getStaticResourceByteArray(Resource resource, String target, CompressType type2) {
        if (resource.length() > (long)resourceMaxSize) {
            Logger logger = Javalin.log;
            if (logger != null) {
                logger.warn("Static file '" + target + "' is larger than configured max size for pre-compression (" + resourceMaxSize + " bytes).\n" + "You can configure the max size with `PrecompressingResourceHandler.resourceMaxSize = newMaxSize`.");
            }
            return null;
        }
        return compressedFiles.computeIfAbsent(target + type2.getExtension(), new Function<String, byte[]>(resource, type2){
            final /* synthetic */ Resource $resource;
            final /* synthetic */ CompressType $type;

            @NotNull
            public final byte[] apply(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return PrecompressingResourceHandler.access$getCompressedByteArray(PrecompressingResourceHandler.INSTANCE, this.$resource, this.$type);
            }
            {
                this.$resource = resource;
                this.$type = compressType;
            }
        });
    }

    private final byte[] getCompressedByteArray(Resource resource, CompressType type2) {
        InputStream fileInput = resource.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream2 = type2 == CompressType.GZIP ? (OutputStream)new LeveledGzipStream((OutputStream)byteArrayOutputStream, 9) : (type2 == CompressType.BR && Util.INSTANCE.dependencyIsPresent(OptionalDependency.JVMBROTLI) ? (OutputStream)((Object)new LeveledBrotliStream(byteArrayOutputStream, 11)) : (OutputStream)byteArrayOutputStream);
        InputStream inputStream2 = fileInput;
        Intrinsics.checkExpressionValueIsNotNull(inputStream2, "fileInput");
        ByteStreamsKt.copyTo$default(inputStream2, outputStream2, 0, 2, null);
        fileInput.close();
        outputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "byteArrayOutputStream.toByteArray()");
        return byArray;
    }

    private final boolean excludedMimeType(String mimeType) {
        boolean bl;
        block5: {
            if (Intrinsics.areEqual(mimeType, "")) {
                bl = false;
            } else {
                Iterable $this$any$iv = excludedMimeTypes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String excluded = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains((CharSequence)mimeType, excluded, true)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    private PrecompressingResourceHandler() {
    }

    static {
        PrecompressingResourceHandler precompressingResourceHandler;
        INSTANCE = precompressingResourceHandler = new PrecompressingResourceHandler();
        compressedFiles = new ConcurrentHashMap();
        resourceMaxSize = 0x200000;
        excludedMimeTypes = SetsKt.setOf("image/", "audio/", "video/", "application/compress", "application/zip", "application/gzip", "application/bzip2", "application/brotli", "application/x-xz", "application/x-rar-compressed");
    }

    public static final /* synthetic */ byte[] access$getCompressedByteArray(PrecompressingResourceHandler $this, Resource resource, CompressType type2) {
        return $this.getCompressedByteArray(resource, type2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0001\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lio/javalin/http/staticfiles/PrecompressingResourceHandler$CompressType;", "", "typeName", "", "extension", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "getTypeName", "acceptEncoding", "", "GZIP", "BR", "NONE", "Companion", "javalin"})
    public static final class CompressType
    extends Enum<CompressType> {
        public static final /* enum */ CompressType GZIP;
        public static final /* enum */ CompressType BR;
        public static final /* enum */ CompressType NONE;
        private static final /* synthetic */ CompressType[] $VALUES;
        @NotNull
        private final String typeName;
        @NotNull
        private final String extension;
        public static final Companion Companion;

        static {
            CompressType[] compressTypeArray = new CompressType[3];
            CompressType[] compressTypeArray2 = compressTypeArray;
            compressTypeArray[0] = GZIP = new CompressType("gzip", ".gz");
            compressTypeArray[1] = BR = new CompressType("br", ".br");
            compressTypeArray[2] = NONE = new CompressType("", "");
            $VALUES = compressTypeArray;
            Companion = new Companion(null);
        }

        public final boolean acceptEncoding(@NotNull String acceptEncoding) {
            Intrinsics.checkParameterIsNotNull(acceptEncoding, "acceptEncoding");
            return StringsKt.contains((CharSequence)acceptEncoding, this.typeName, true);
        }

        @NotNull
        public final String getTypeName() {
            return this.typeName;
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        private CompressType(String typeName, String extension) {
            this.typeName = typeName;
            this.extension = extension;
        }

        public static CompressType[] values() {
            return (CompressType[])$VALUES.clone();
        }

        public static CompressType valueOf(String string) {
            return Enum.valueOf(CompressType.class, string);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/javalin/http/staticfiles/PrecompressingResourceHandler$CompressType$Companion;", "", "()V", "getByAcceptEncoding", "Lio/javalin/http/staticfiles/PrecompressingResourceHandler$CompressType;", "acceptEncoding", "", "javalin"})
        public static final class Companion {
            @NotNull
            public final CompressType getByAcceptEncoding(@NotNull String acceptEncoding) {
                CompressType compressType;
                CompressType compressType2;
                block2: {
                    Intrinsics.checkParameterIsNotNull(acceptEncoding, "acceptEncoding");
                    CompressType[] compressTypeArray = CompressType.values();
                    boolean bl = false;
                    CompressType[] compressTypeArray2 = compressTypeArray;
                    boolean bl2 = false;
                    CompressType[] compressTypeArray3 = compressTypeArray2;
                    int n = compressTypeArray3.length;
                    for (int j = 0; j < n; ++j) {
                        CompressType compressType3;
                        CompressType it = compressType3 = compressTypeArray3[j];
                        boolean bl3 = false;
                        if (!it.acceptEncoding(acceptEncoding)) continue;
                        compressType2 = compressType3;
                        break block2;
                    }
                    compressType2 = compressType = null;
                }
                if (compressType2 == null) {
                    compressType = NONE;
                }
                return compressType;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

