/*
 * Decompiled with CFR 0.152.
 */
package io.requery.reactivex;

import io.requery.query.Result;
import io.requery.util.CloseableIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class QuerySubscription<T>
implements Subscription {
    private final Result<T> result;
    private final Subscriber<? super T> subscriber;
    private final AtomicBoolean canceled;
    private final AtomicLong emitted;
    private final AtomicLong requested;

    public QuerySubscription(Result<T> result2, Subscriber<? super T> subscriber) {
        this.result = result2;
        this.subscriber = subscriber;
        this.canceled = new AtomicBoolean();
        this.emitted = new AtomicLong();
        this.requested = new AtomicLong();
    }

    public void request(long n) {
        try {
            if (n == Long.MAX_VALUE && this.requested.compareAndSet(0L, Long.MAX_VALUE)) {
                this.requestAll();
            } else if (n > 0L && QuerySubscription.add(this.requested, n) == 0L) {
                this.requestN(n);
            }
        }
        catch (Throwable e) {
            this.subscriber.onError(e);
        }
    }

    private void requestAll() {
        try (CloseableIterator<T> iterator2 = this.result.iterator();){
            while (!this.canceled.get()) {
                if (iterator2.hasNext()) {
                    this.subscriber.onNext(iterator2.next());
                    this.emitted.incrementAndGet();
                    continue;
                }
                this.subscriber.onComplete();
                break;
            }
        }
    }

    private void requestN(long n) {
        long count = n;
        while (count > 0L) {
            CloseableIterator<T> iterator2 = this.result.iterator(this.emitted.intValue(), (int)n);
            Throwable throwable = null;
            try {
                long i2 = 0L;
                while (!this.canceled.get() && iterator2.hasNext() && i2++ < count) {
                    this.subscriber.onNext(iterator2.next());
                }
                this.emitted.addAndGet(i2);
                if (!this.canceled.get() && i2 < count) {
                    this.subscriber.onComplete();
                    break;
                }
                count = this.requested.addAndGet(-count);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (iterator2 == null) continue;
                if (throwable != null) {
                    try {
                        iterator2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                iterator2.close();
            }
        }
    }

    public void cancel() {
        this.canceled.compareAndSet(false, true);
    }

    private static long add(AtomicLong requested, long n) {
        long update2;
        long value;
        do {
            if ((value = requested.get()) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update2 = value + n;
            if (update2 >= 0L) continue;
            update2 = Long.MAX_VALUE;
        } while (!requested.compareAndSet(value, update2));
        return value;
    }
}

