/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.query.BaseScalar;
import io.requery.query.Scalar;
import io.requery.query.element.QueryElement;
import io.requery.sql.GeneratedResultReader;
import io.requery.sql.QueryBuilder;
import io.requery.sql.RuntimeConfiguration;
import io.requery.sql.StatementExecutionException;
import io.requery.sql.StatementListener;
import io.requery.sql.UpdateOperation;
import io.requery.sql.gen.DefaultOutput;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

abstract class EntityUpdateOperation
extends UpdateOperation {
    EntityUpdateOperation(RuntimeConfiguration configuration, GeneratedResultReader resultReader) {
        super(configuration, resultReader);
    }

    @Override
    public Scalar<Integer> evaluate(final QueryElement<Scalar<Integer>> query) {
        return new BaseScalar<Integer>(this.configuration.getWriteExecutor()){

            @Override
            public Integer evaluate() {
                int result2;
                QueryBuilder qb = new QueryBuilder(EntityUpdateOperation.this.configuration.getQueryBuilderOptions());
                DefaultOutput output = new DefaultOutput(EntityUpdateOperation.this.configuration, query, qb, null, false);
                String sql = output.toSql();
                try (Connection connection = EntityUpdateOperation.this.configuration.getConnection();){
                    StatementListener listener = EntityUpdateOperation.this.configuration.getStatementListener();
                    try (PreparedStatement statement = EntityUpdateOperation.this.prepare(sql, connection);){
                        EntityUpdateOperation.this.bindParameters(statement);
                        listener.beforeExecuteUpdate(statement, sql, null);
                        result2 = statement.executeUpdate();
                        listener.afterExecuteUpdate(statement, result2);
                        EntityUpdateOperation.this.readGeneratedKeys(0, statement);
                    }
                }
                catch (SQLException e) {
                    throw new StatementExecutionException(e, sql);
                }
                return result2;
            }
        };
    }

    public abstract int bindParameters(PreparedStatement var1) throws SQLException;
}

