/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.query.Expression;
import io.requery.sql.ResultReader;
import io.requery.util.CloseableIterator;
import io.requery.util.IndexAccessible;
import io.requery.util.Objects;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.NoSuchElementException;
import java.util.Set;

public class ResultSetIterator<E>
implements CloseableIterator<E>,
IndexAccessible<E>,
Wrapper {
    private final Set<? extends Expression<?>> selection;
    private final ResultSet results;
    private final ResultReader<E> reader;
    private final boolean closeStatement;
    private final boolean closeConnection;
    private int position;
    private boolean closed;
    private boolean advanced;

    ResultSetIterator(ResultReader<E> reader, ResultSet results, Set<? extends Expression<?>> selection, boolean closeStatement, boolean closeConnection) {
        this.reader = Objects.requireNotNull(reader);
        this.results = Objects.requireNotNull(results);
        this.selection = selection;
        this.closeStatement = closeStatement;
        this.closeConnection = closeConnection;
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        if (this.advanced) {
            return true;
        }
        try {
            if (this.results.next()) {
                this.advanced = true;
                return true;
            }
            this.close();
            return false;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public E next() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        try {
            if (!this.advanced && !this.results.next()) {
                this.advanced = false;
                this.close();
                throw new NoSuchElementException();
            }
            E value = this.reader.read(this.results, this.selection);
            ++this.position;
            this.advanced = false;
            return value;
        }
        catch (SQLException e) {
            NoSuchElementException exception = new NoSuchElementException();
            exception.initCause(e);
            throw exception;
        }
    }

    @Override
    public E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        try {
            if (this.results.absolute(index + 1)) {
                this.position = index;
                if (this.results.rowDeleted()) {
                    return null;
                }
                return this.reader.read(this.results, this.selection);
            }
            throw new UnsupportedOperationException();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void remove() {
        try {
            if (this.results.isBeforeFirst()) {
                throw new IllegalStateException();
            }
            if (this.results.getConcurrency() != 1008) {
                throw new UnsupportedOperationException();
            }
            this.results.deleteRow();
        }
        catch (SQLFeatureNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ResultSet resultSet = this.results;
        synchronized (resultSet) {
            if (!this.closed) {
                Statement statement = null;
                if (this.closeStatement) {
                    try {
                        statement = this.results.getStatement();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                ResultSetIterator.closeSuppressed(this.results);
                if (statement != null) {
                    Connection connection = null;
                    try {
                        connection = statement.getConnection();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ResultSetIterator.closeSuppressed(statement);
                    if (this.closeConnection) {
                        ResultSetIterator.closeSuppressed(connection);
                    }
                }
                this.closed = true;
            }
        }
    }

    private static void closeSuppressed(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.results.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.results.isWrapperFor(iface);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResultSetIterator) {
            ResultSetIterator iterator2 = (ResultSetIterator)obj;
            return iterator2.results == this.results;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.results);
    }
}

