/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.check.QuestionType;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.QuestionLike;
import eu.pretix.libpretixsync.db.QuestionOption;
import eu.pretix.libpretixsync.db.RemoteObject;
import eu.pretix.libpretixsync.utils.I18nString;
import io.requery.CascadeAction;
import io.requery.Column;
import io.requery.Entity;
import io.requery.Generated;
import io.requery.JunctionTable;
import io.requery.Key;
import io.requery.ManyToMany;
import io.requery.Transient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractQuestion
extends QuestionLike
implements RemoteObject {
    @Generated
    @Key
    public Long id;
    public String event_slug;
    public Long server_id;
    public boolean required;
    public Long position;
    @Column(definition="TEXT")
    public String json_data;
    @ManyToMany(cascade={CascadeAction.NONE})
    @JunctionTable
    List<Item> items;
    @Transient
    QuestionLike _resolvedDependency;
    @Transient
    boolean _resolveDependencyCalled;

    @Override
    public JSONObject getJSON() throws JSONException {
        return new JSONObject(this.json_data);
    }

    @Override
    public boolean requiresAnswer() {
        return this.required;
    }

    @Override
    public String getIdentifier() {
        try {
            return this.getJSON().getString("identifier");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "<invalid>";
        }
    }

    @Override
    public String getQuestion() {
        try {
            return I18nString.toString(this.getJSON().getJSONObject("question"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "<invalid>";
        }
    }

    public boolean isAskDuringCheckin() {
        try {
            return this.getJSON().getBoolean("ask_during_checkin");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isHidden() {
        try {
            return this.getJSON().getBoolean("hidden");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isDependentOnOtherQuestion() {
        try {
            return this.getJSON().has("dependency_question") && !this.getJSON().isNull("dependency_question");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Long getDependencyQuestionId() {
        try {
            return this.getJSON().optLong("dependency_question");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void resolveDependency(List<AbstractQuestion> all) {
        Long id = this.getDependencyQuestionId();
        this._resolveDependencyCalled = true;
        if (id == null) {
            this._resolvedDependency = null;
            return;
        }
        for (AbstractQuestion q : all) {
            if (!Objects.equals(q.server_id, id)) continue;
            this._resolvedDependency = q;
            break;
        }
    }

    @Override
    public QuestionLike getDependency() {
        if (!this._resolveDependencyCalled) {
            throw new IllegalStateException("Question dependencies not resolved");
        }
        return this._resolvedDependency;
    }

    @Override
    public List<String> getDependencyValues() {
        try {
            ArrayList<String> l = new ArrayList<String>();
            JSONArray a = this.getJSON().optJSONArray("dependency_values");
            if (a != null) {
                for (int i2 = 0; i2 < a.length(); ++i2) {
                    l.add(a.getString(i2));
                }
            }
            return l;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    @Override
    public Long getValid_date_min() {
        try {
            if (!this.getJSON().isNull("valid_date_min")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                dateFormat.setLenient(false);
                return dateFormat.parse(this.getJSON().getString("valid_date_min")).getTime();
            }
        }
        catch (ParseException | JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Long getValid_date_max() {
        try {
            if (!this.getJSON().isNull("valid_date_max")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                dateFormat.setLenient(false);
                return dateFormat.parse(this.getJSON().getString("valid_date_max")).getTime();
            }
        }
        catch (ParseException | JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Long getValid_datetime_min() {
        try {
            if (!this.getJSON().isNull("valid_datetime_min")) {
                return ISODateTimeFormat.dateTimeNoMillis().parseDateTime(this.getJSON().getString("valid_datetime_min")).toDateTime().toDate().getTime();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Long getValid_datetime_max() {
        try {
            if (!this.getJSON().isNull("valid_datetime_max")) {
                return ISODateTimeFormat.dateTimeNoMillis().parseDateTime(this.getJSON().getString("valid_datetime_max")).toDateTime().toDate().getTime();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public QuestionType getType() {
        try {
            return QuestionType.valueOf(this.getJSON().getString("type"));
        }
        catch (IllegalArgumentException | JSONException e) {
            return QuestionType.T;
        }
    }

    @Override
    public List<QuestionOption> getOptions() {
        ArrayList<QuestionOption> opts = new ArrayList<QuestionOption>();
        try {
            JSONArray arr = this.getJSON().getJSONArray("options");
            for (int i2 = 0; i2 < arr.length(); ++i2) {
                String answ;
                JSONObject oobj = arr.getJSONObject(i2);
                try {
                    answ = I18nString.toString(oobj.getJSONObject("answer"));
                }
                catch (JSONException e) {
                    answ = oobj.getString("answer");
                }
                opts.add(new QuestionOption(oobj.getLong("id"), oobj.getLong("position"), oobj.getString("identifier"), answ));
            }
            return opts;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

