/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.api.ResourceNotModified;
import eu.pretix.libpretixsync.db.BlockedTicketSecret;
import eu.pretix.libpretixsync.db.ResourceSyncStatus;
import eu.pretix.libpretixsync.sync.BaseDownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BlockedTicketSecretSyncAdapter
extends BaseDownloadSyncAdapter<BlockedTicketSecret, Long> {
    private String firstResponseTimestamp;
    private ResourceSyncStatus rlm;

    public BlockedTicketSecretSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage, String eventSlug, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage, eventSlug, api, syncCycleId, feedback);
    }

    @Override
    protected boolean autoPersist() {
        return false;
    }

    @Override
    public void download() throws JSONException, ApiException, ExecutionException, InterruptedException {
        boolean completed = false;
        try {
            super.download();
            completed = true;
        }
        finally {
            ResourceSyncStatus resourceSyncStatus = (ResourceSyncStatus)((Result)((WhereAndOr)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)this.getResourceName())).and(ResourceSyncStatus.EVENT_SLUG.eq((Object)this.eventSlug))).limit(1).get()).firstOrNull();
            if (this.firstResponseTimestamp != null) {
                if (resourceSyncStatus == null) {
                    resourceSyncStatus = new ResourceSyncStatus();
                    resourceSyncStatus.setResource(this.getResourceName());
                    resourceSyncStatus.setEvent_slug(this.eventSlug);
                    if (completed) {
                        resourceSyncStatus.setStatus("complete");
                        resourceSyncStatus.setLast_modified(this.firstResponseTimestamp);
                        this.store.upsert(resourceSyncStatus);
                    }
                } else if (completed) {
                    resourceSyncStatus.setLast_modified(this.firstResponseTimestamp);
                    this.store.upsert(resourceSyncStatus);
                }
            } else if (completed && resourceSyncStatus != null) {
                resourceSyncStatus.setStatus("complete");
                this.store.update(resourceSyncStatus);
            }
            this.firstResponseTimestamp = null;
        }
        this.store.delete(BlockedTicketSecret.class).where(BlockedTicketSecret.BLOCKED.eq((Object)false));
    }

    @Override
    protected boolean deleteUnseen() {
        return this.rlm == null;
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(BlockedTicketSecret.SERVER_ID).where(BlockedTicketSecret.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    public void updateObject(BlockedTicketSecret obj, JSONObject jsonobj) throws JSONException {
        obj.setEvent_slug(this.eventSlug);
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setUpdated(jsonobj.getString("updated"));
        obj.setBlocked(jsonobj.getBoolean("blocked"));
        obj.setSecret(jsonobj.getString("secret"));
        obj.setJson_data(jsonobj.toString());
        if (obj.getId() == null && obj.isBlocked()) {
            this.store.insert(obj);
        }
    }

    @Override
    protected String getUrl() {
        return this.api.eventResourceUrl(this.eventSlug, this.getResourceName());
    }

    @Override
    String getResourceName() {
        return "blockedsecrets";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(BlockedTicketSecret obj) {
        return obj.getServer_id();
    }

    @Override
    BlockedTicketSecret newEmptyObject() {
        return new BlockedTicketSecret();
    }

    @Override
    public CloseableIterator<BlockedTicketSecret> runBatch(List<Long> parameterBatch) {
        return ((Result)((WhereAndOr)this.store.select(BlockedTicketSecret.class, new QueryAttribute[0]).where(BlockedTicketSecret.SERVER_ID.in(parameterBatch)).and(BlockedTicketSecret.EVENT_SLUG.eq((Object)this.eventSlug))).get()).iterator();
    }

    @Override
    protected JSONObject downloadPage(String url, boolean isFirstPage) throws ApiException, ResourceNotModified {
        if (isFirstPage) {
            this.rlm = (ResourceSyncStatus)((Result)((WhereAndOr)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)this.getResourceName())).and(ResourceSyncStatus.EVENT_SLUG.eq((Object)this.eventSlug))).limit(1).get()).firstOrNull();
        }
        if (this.rlm != null) {
            try {
                if (!url.contains("updated_since")) {
                    url = url.contains("?") ? url + "&" : url + "?";
                    url = url + "ordering=-updated&updated_since=" + URLEncoder.encode(this.rlm.getLast_modified(), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        PretixApi.ApiResponse apiResponse = this.api.fetchResource(url);
        if (isFirstPage) {
            try {
                JSONArray results = apiResponse.getData().getJSONArray("results");
                if (results.length() > 0) {
                    this.firstResponseTimestamp = results.getJSONObject(0).getString("updated");
                }
            }
            catch (NullPointerException | JSONException e) {
                e.printStackTrace();
            }
        }
        return apiResponse.getData();
    }
}

