/*
 * Decompiled with CFR 0.152.
 */
package io.requery.async;

import io.requery.BlockingEntityStore;
import io.requery.async.CompletionStageEntityStore;
import io.requery.meta.Attribute;
import io.requery.meta.QueryAttribute;
import io.requery.query.Deletion;
import io.requery.query.Expression;
import io.requery.query.InsertInto;
import io.requery.query.Insertion;
import io.requery.query.Result;
import io.requery.query.Scalar;
import io.requery.query.Selection;
import io.requery.query.Tuple;
import io.requery.query.Update;
import io.requery.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CompletableEntityStore<T>
implements CompletionStageEntityStore<T> {
    private final BlockingEntityStore<T> delegate;
    private final Executor executor;
    private final boolean createdExecutor;

    public CompletableEntityStore(BlockingEntityStore<T> delegate) {
        this.delegate = Objects.requireNotNull(delegate);
        this.executor = Executors.newSingleThreadExecutor();
        this.createdExecutor = true;
    }

    public CompletableEntityStore(BlockingEntityStore<T> delegate, Executor executor) {
        this.delegate = Objects.requireNotNull(delegate);
        this.executor = Objects.requireNotNull(executor);
        this.createdExecutor = false;
    }

    @Override
    public <E extends T> CompletableFuture<E> insert(final E entity) {
        return CompletableFuture.supplyAsync(new Supplier<E>(){

            @Override
            public E get() {
                return CompletableEntityStore.this.delegate.insert(entity);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletableFuture<Iterable<E>> insert(final Iterable<E> entities) {
        return CompletableFuture.supplyAsync(new Supplier<Iterable<E>>(){

            @Override
            public Iterable<E> get() {
                return CompletableEntityStore.this.delegate.insert(entities);
            }
        }, this.executor);
    }

    @Override
    public <K, E extends T> CompletionStage<K> insert(final E entity, final Class<K> keyClass) {
        return CompletableFuture.supplyAsync(new Supplier<K>(){

            @Override
            public K get() {
                return CompletableEntityStore.this.delegate.insert(entity, keyClass);
            }
        }, this.executor);
    }

    @Override
    public <K, E extends T> CompletionStage<Iterable<K>> insert(final Iterable<E> entities, final Class<K> keyClass) {
        return CompletableFuture.supplyAsync(new Supplier<Iterable<K>>(){

            @Override
            public Iterable<K> get() {
                return CompletableEntityStore.this.delegate.insert(entities, keyClass);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletableFuture<E> update(final E entity) {
        return CompletableFuture.supplyAsync(new Supplier<E>(){

            @Override
            public E get() {
                return CompletableEntityStore.this.delegate.update(entity);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletionStage<E> update(final E entity, final Attribute<?, ?> ... attributes) {
        return CompletableFuture.supplyAsync(new Supplier<E>(){

            @Override
            public E get() {
                return CompletableEntityStore.this.delegate.update(entity, attributes);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletableFuture<Iterable<E>> update(final Iterable<E> entities) {
        return CompletableFuture.supplyAsync(new Supplier<Iterable<E>>(){

            @Override
            public Iterable<E> get() {
                return CompletableEntityStore.this.delegate.update(entities);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletionStage<E> upsert(final E entity) {
        return CompletableFuture.supplyAsync(new Supplier<E>(){

            @Override
            public E get() {
                return CompletableEntityStore.this.delegate.upsert(entity);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletableFuture<Iterable<E>> upsert(final Iterable<E> entities) {
        return CompletableFuture.supplyAsync(new Supplier<Iterable<E>>(){

            @Override
            public Iterable<E> get() {
                return CompletableEntityStore.this.delegate.upsert(entities);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletableFuture<E> refresh(final E entity) {
        return CompletableFuture.supplyAsync(new Supplier<E>(){

            @Override
            public E get() {
                return CompletableEntityStore.this.delegate.refresh(entity);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletableFuture<E> refresh(final E entity, final Attribute<?, ?> ... attributes) {
        return CompletableFuture.supplyAsync(new Supplier<E>(){

            @Override
            public E get() {
                return CompletableEntityStore.this.delegate.refresh(entity, attributes);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletionStage<Iterable<E>> refresh(final Iterable<E> entities, final Attribute<?, ?> ... attributes) {
        return CompletableFuture.supplyAsync(new Supplier<Iterable<E>>(){

            @Override
            public Iterable<E> get() {
                return CompletableEntityStore.this.delegate.refresh(entities, attributes);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletableFuture<E> refreshAll(final E entity) {
        return CompletableFuture.supplyAsync(new Supplier<E>(){

            @Override
            public E get() {
                return CompletableEntityStore.this.delegate.refreshAll(entity);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletableFuture<Void> delete(final E entity) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                CompletableEntityStore.this.delegate.delete(entity);
            }
        }, this.executor);
    }

    @Override
    public <E extends T> CompletableFuture<Void> delete(final Iterable<E> entities) {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                CompletableEntityStore.this.delegate.delete(entities);
            }
        }, this.executor);
    }

    @Override
    public <E extends T, K> CompletableFuture<E> findByKey(final Class<E> type2, final K key) {
        return CompletableFuture.supplyAsync(new Supplier<E>(){

            @Override
            public E get() {
                return CompletableEntityStore.this.delegate.findByKey(type2, key);
            }
        }, this.executor);
    }

    @Override
    public void close() {
        try {
            if (this.createdExecutor) {
                ExecutorService executorService = (ExecutorService)this.executor;
                executorService.shutdown();
            }
        }
        finally {
            this.delegate.close();
        }
    }

    @Override
    public Selection<? extends Result<Tuple>> select(Expression<?> ... expressions) {
        return this.delegate.select(expressions);
    }

    @Override
    public Selection<? extends Result<Tuple>> select(Set<? extends Expression<?>> expressions) {
        return this.delegate.select(expressions);
    }

    @Override
    public Update<? extends Scalar<Integer>> update() {
        return this.delegate.update();
    }

    @Override
    public Deletion<? extends Scalar<Integer>> delete() {
        return this.delegate.delete();
    }

    @Override
    public <E extends T> Selection<? extends Result<E>> select(Class<E> type2, QueryAttribute<?, ?> ... attributes) {
        return this.delegate.select(type2, attributes);
    }

    @Override
    public <E extends T> Selection<? extends Result<E>> select(Class<E> type2, Set<? extends QueryAttribute<E, ?>> attributes) {
        return this.delegate.select(type2, attributes);
    }

    @Override
    public <E extends T> Insertion<? extends Result<Tuple>> insert(Class<E> type2) {
        return this.delegate.insert(type2);
    }

    @Override
    public <E extends T> InsertInto<? extends Result<Tuple>> insert(Class<E> type2, QueryAttribute<?, ?> ... attributes) {
        return this.delegate.insert(type2, attributes);
    }

    @Override
    public <E extends T> Update<? extends Scalar<Integer>> update(Class<E> type2) {
        return this.delegate.update(type2);
    }

    @Override
    public <E extends T> Deletion<? extends Scalar<Integer>> delete(Class<E> type2) {
        return this.delegate.delete(type2);
    }

    @Override
    public <E extends T> Selection<? extends Scalar<Integer>> count(Class<E> type2) {
        return this.delegate.count(type2);
    }

    @Override
    public Selection<? extends Scalar<Integer>> count(QueryAttribute<?, ?> ... attributes) {
        return this.delegate.count(attributes);
    }

    @Override
    public Result<Tuple> raw(String query, Object ... parameters2) {
        return this.delegate.raw(query, parameters2);
    }

    @Override
    public <E extends T> Result<E> raw(Class<E> type2, String query, Object ... parameters2) {
        return this.delegate.raw(type2, query, parameters2);
    }

    @Override
    public BlockingEntityStore<T> toBlocking() {
        return this.delegate;
    }
}

