/*
 * Decompiled with CFR 0.152.
 */
package io.requery.meta;

import io.requery.CascadeAction;
import io.requery.Converter;
import io.requery.ReferentialAction;
import io.requery.meta.Attribute;
import io.requery.meta.BaseAttribute;
import io.requery.meta.Cardinality;
import io.requery.meta.ImmutableAttribute;
import io.requery.meta.ImmutableNumericAttribute;
import io.requery.meta.ImmutableStringAttribute;
import io.requery.meta.NumericAttribute;
import io.requery.meta.PrimitiveKind;
import io.requery.meta.QueryAttribute;
import io.requery.meta.StringAttribute;
import io.requery.proxy.Initializer;
import io.requery.proxy.Property;
import io.requery.proxy.PropertyState;
import io.requery.query.Order;
import io.requery.util.Objects;
import io.requery.util.function.Supplier;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;

public class AttributeBuilder<T, V>
extends BaseAttribute<T, V> {
    public AttributeBuilder(String name, Class<V> type2) {
        this.name = Objects.requireNotNull(name);
        this.classType = Objects.requireNotNull(type2);
        this.primitiveKind = PrimitiveKind.fromClass(this.classType);
    }

    public <B> AttributeBuilder<T, V> setBuilderProperty(Property<B, V> property) {
        this.builderProperty = property;
        return this;
    }

    public AttributeBuilder<T, V> setCardinality(Cardinality cardinality) {
        this.cardinality = cardinality;
        return this;
    }

    public AttributeBuilder<T, V> setCascadeAction(CascadeAction ... actions) {
        this.cascadeActions = EnumSet.copyOf(Arrays.asList(actions));
        return this;
    }

    public AttributeBuilder<T, V> setCollate(String collate) {
        this.collate = collate;
        return this;
    }

    public AttributeBuilder<T, V> setConverter(Converter<V, ?> converter) {
        this.converter = converter;
        return this;
    }

    public AttributeBuilder<T, V> setDefaultValue(String value) {
        this.defaultValue = value;
        return this;
    }

    public AttributeBuilder<T, V> setDefinition(String definition) {
        this.definition = definition;
        return this;
    }

    public AttributeBuilder<T, V> setDeleteAction(ReferentialAction action) {
        this.deleteAction = action;
        return this;
    }

    public AttributeBuilder<T, V> setForeignKey(boolean foreignKey) {
        this.isForeignKey = foreignKey;
        return this;
    }

    public AttributeBuilder<T, V> setGenerated(boolean generated) {
        this.isGenerated = generated;
        return this;
    }

    public AttributeBuilder<T, V> setIndexed(boolean indexed) {
        this.isIndex = indexed;
        return this;
    }

    public AttributeBuilder<T, V> setIndexNames(String ... names) {
        this.indexNames = new LinkedHashSet();
        Collections.addAll(this.indexNames, names);
        return this;
    }

    public AttributeBuilder<T, V> setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        return this;
    }

    public AttributeBuilder<T, V> setInitializer(Initializer<T, V> initializer) {
        this.initializer = initializer;
        return this;
    }

    public AttributeBuilder<T, V> setKey(boolean key) {
        this.isKey = key;
        return this;
    }

    public AttributeBuilder<T, V> setLazy(boolean lazy) {
        this.isLazy = lazy;
        return this;
    }

    public AttributeBuilder<T, V> setLength(Integer length) {
        this.length = length;
        return this;
    }

    public AttributeBuilder<T, V> setMappedAttribute(Supplier<Attribute> attribute) {
        this.mappedAttribute = attribute;
        return this;
    }

    public AttributeBuilder<T, V> setNullable(boolean nullable) {
        this.isNullable = nullable;
        return this;
    }

    public AttributeBuilder<T, V> setOrderByAttribute(Supplier<Attribute> attribute) {
        this.orderByAttribute = attribute;
        return this;
    }

    public AttributeBuilder<T, V> setOrderByDirection(Order order) {
        this.orderByDirection = order;
        return this;
    }

    public AttributeBuilder<T, V> setProperty(Property<T, V> property) {
        this.property = property;
        return this;
    }

    public AttributeBuilder<T, V> setPropertyName(String name) {
        this.propertyName = name;
        return this;
    }

    public AttributeBuilder<T, V> setPropertyState(Property<T, PropertyState> property) {
        this.propertyState = property;
        return this;
    }

    public AttributeBuilder<T, V> setReferencedAttribute(Supplier<Attribute> attribute) {
        this.referencedAttribute = attribute;
        return this;
    }

    public AttributeBuilder<T, V> setReferencedClass(Class<?> type2) {
        this.referencedClass = type2;
        return this;
    }

    public AttributeBuilder<T, V> setUnique(boolean unique) {
        this.isUnique = unique;
        return this;
    }

    public AttributeBuilder<T, V> setUpdateAction(ReferentialAction action) {
        this.updateAction = action;
        return this;
    }

    public AttributeBuilder<T, V> setVersion(boolean version) {
        this.isVersion = version;
        return this;
    }

    public QueryAttribute<T, V> build() {
        return new ImmutableAttribute(this);
    }

    public StringAttribute<T, V> buildString() {
        return new ImmutableStringAttribute(this);
    }

    public NumericAttribute<T, V> buildNumeric() {
        return new ImmutableNumericAttribute(this);
    }
}

