/*
 * Decompiled with CFR 0.152.
 */
package io.requery.query;

import io.requery.query.Scalar;
import io.requery.util.function.Consumer;
import io.requery.util.function.Supplier;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public abstract class BaseScalar<E>
implements Scalar<E> {
    private final Executor executor;
    private boolean computed;
    private E value;

    protected BaseScalar(Executor executor) {
        this.executor = executor;
    }

    protected abstract E evaluate();

    @Override
    public synchronized E value() {
        if (!this.computed) {
            this.computed = true;
            this.value = this.evaluate();
        }
        return this.value;
    }

    @Override
    public E call() throws Exception {
        return this.value();
    }

    @Override
    public void consume(Consumer<? super E> action) {
        action.accept(this.value());
    }

    @Override
    public CompletableFuture<E> toCompletableFuture() {
        return this.toCompletableFuture(this.executor);
    }

    @Override
    public CompletableFuture<E> toCompletableFuture(Executor executor) {
        java.util.function.Supplier supplier = new java.util.function.Supplier<E>(){

            @Override
            public E get() {
                return BaseScalar.this.value();
            }
        };
        return executor == null ? CompletableFuture.supplyAsync(supplier) : CompletableFuture.supplyAsync(supplier, executor);
    }

    @Override
    public Supplier<E> toSupplier() {
        return new Supplier<E>(){

            @Override
            public E get() {
                return BaseScalar.this.value();
            }
        };
    }
}

