/*
 * Decompiled with CFR 0.152.
 */
package io.requery.query;

import io.requery.meta.QueryExpression;
import io.requery.query.AliasedExpression;
import io.requery.query.Condition;
import io.requery.query.Expression;
import io.requery.query.ExpressionType;
import io.requery.query.LogicalCondition;
import io.requery.query.NullOperand;
import io.requery.query.Operator;
import io.requery.query.Order;
import io.requery.query.OrderingExpression;
import io.requery.query.Return;
import io.requery.query.function.Function;
import io.requery.query.function.Max;
import io.requery.query.function.Min;
import io.requery.util.Objects;
import java.util.ArrayList;
import java.util.Collection;

public abstract class FieldExpression<V>
implements QueryExpression<V> {
    protected FieldExpression() {
    }

    @Override
    public abstract String getName();

    @Override
    public abstract ExpressionType getExpressionType();

    @Override
    public abstract Class<V> getClassType();

    @Override
    public Expression<V> getInnerExpression() {
        return null;
    }

    @Override
    public FieldExpression<V> as(String alias) {
        return new AliasedExpression(this, alias);
    }

    @Override
    public String getAlias() {
        return null;
    }

    @Override
    public OrderingExpression<V> asc() {
        return new OrderExpression(this, Order.ASC);
    }

    @Override
    public OrderingExpression<V> desc() {
        return new OrderExpression(this, Order.DESC);
    }

    @Override
    public Max<V> max() {
        return Max.max(this);
    }

    @Override
    public Min<V> min() {
        return Min.min(this);
    }

    @Override
    public Function<V> function(String name) {
        return new Function<V>(name, this.getClassType()){

            @Override
            public Object[] arguments() {
                return new Object[]{FieldExpression.this};
            }
        };
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> equal(V value) {
        if (value == null) {
            return this.isNull();
        }
        return new ExpressionCondition<FieldExpression, V>(this, Operator.EQUAL, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> notEqual(V value) {
        Objects.requireNotNull(value);
        return new ExpressionCondition<FieldExpression, V>(this, Operator.NOT_EQUAL, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> lessThan(V value) {
        Objects.requireNotNull(value);
        return new ExpressionCondition<FieldExpression, V>(this, Operator.LESS_THAN, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> greaterThan(V value) {
        Objects.requireNotNull(value);
        return new ExpressionCondition<FieldExpression, V>(this, Operator.GREATER_THAN, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> lessThanOrEqual(V value) {
        Objects.requireNotNull(value);
        return new ExpressionCondition<FieldExpression, V>(this, Operator.LESS_THAN_OR_EQUAL, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> greaterThanOrEqual(V value) {
        Objects.requireNotNull(value);
        return new ExpressionCondition<FieldExpression, V>(this, Operator.GREATER_THAN_OR_EQUAL, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> equal(Expression<V> value) {
        return new ExpressionCondition<FieldExpression, Expression<V>>(this, Operator.EQUAL, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> notEqual(Expression<V> value) {
        return new ExpressionCondition<FieldExpression, Expression<V>>(this, Operator.NOT_EQUAL, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> lessThan(Expression<V> value) {
        return new ExpressionCondition<FieldExpression, Expression<V>>(this, Operator.LESS_THAN, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> greaterThan(Expression<V> value) {
        return new ExpressionCondition<FieldExpression, Expression<V>>(this, Operator.GREATER_THAN, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> lessThanOrEqual(Expression<V> value) {
        return new ExpressionCondition<FieldExpression, Expression<V>>(this, Operator.LESS_THAN_OR_EQUAL, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> greaterThanOrEqual(Expression<V> value) {
        return new ExpressionCondition<FieldExpression, Expression<V>>(this, Operator.GREATER_THAN_OR_EQUAL, value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> eq(V value) {
        return this.equal((Object)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> ne(V value) {
        return this.notEqual((Object)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> lt(V value) {
        return this.lessThan((Object)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> gt(V value) {
        return this.greaterThan((Object)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> lte(V value) {
        return this.lessThanOrEqual((Object)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> gte(V value) {
        return this.greaterThanOrEqual((Object)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> eq(Expression<V> value) {
        return this.equal((Expression)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> ne(Expression<V> value) {
        return this.notEqual((Expression)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> lt(Expression<V> value) {
        return this.lessThan((Expression)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> gt(Expression<V> value) {
        return this.greaterThan((Expression)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> lte(Expression<V> value) {
        return this.lessThanOrEqual((Expression)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> gte(Expression<V> value) {
        return this.greaterThanOrEqual((Expression)value);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, Collection<V>> in(Collection<V> values2) {
        Objects.requireNotNull(values2);
        return new ExpressionCondition<FieldExpression, Collection<V>>(this, Operator.IN, values2);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ?> in(V first, Object ... values2) {
        ArrayList<Object> collection = new ArrayList<Object>(1 + values2.length);
        collection.add(first);
        for (Object o : values2) {
            collection.add(o);
        }
        return this.in(collection);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, Collection<V>> notIn(Collection<V> values2) {
        Objects.requireNotNull(values2);
        return new ExpressionCondition<FieldExpression, Collection<V>>(this, Operator.NOT_IN, values2);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ?> notIn(V first, Object ... values2) {
        ArrayList<Object> collection = new ArrayList<Object>(1 + values2.length);
        collection.add(first);
        for (Object o : values2) {
            collection.add(o);
        }
        return this.notIn(collection);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Return<?>> in(Return<?> query) {
        Objects.requireNotNull(query);
        return new ExpressionCondition(this, Operator.IN, query);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Return<?>> notIn(Return<?> query) {
        Objects.requireNotNull(query);
        return new ExpressionCondition(this, Operator.NOT_IN, query);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> isNull() {
        return new ExpressionCondition<FieldExpression, Object>(this, Operator.IS_NULL, null);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, V> notNull() {
        return new ExpressionCondition<FieldExpression, Object>(this, Operator.NOT_NULL, null);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, String> like(String expression) {
        Objects.requireNotNull(expression);
        return new ExpressionCondition<FieldExpression, String>(this, Operator.LIKE, expression);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, String> notLike(String expression) {
        Objects.requireNotNull(expression);
        return new ExpressionCondition<FieldExpression, String>(this, Operator.NOT_LIKE, expression);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, Object> between(V start2, V end) {
        Objects.requireNotNull(start2);
        Objects.requireNotNull(end);
        Object[] value = new Object[]{start2, end};
        return new ExpressionCondition<FieldExpression, Object[]>(this, Operator.BETWEEN, value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FieldExpression) {
            FieldExpression other = (FieldExpression)obj;
            return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getClassType(), other.getClassType()) && Objects.equals(this.getAlias(), other.getAlias());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getClassType(), this.getAlias());
    }

    private static class OrderExpression<X>
    implements OrderingExpression<X> {
        private final Expression<X> expression;
        private final Order order;
        private OrderingExpression.NullOrder nullOrder;

        OrderExpression(Expression<X> expression, Order order) {
            this.expression = expression;
            this.order = order;
        }

        @Override
        public OrderingExpression<X> nullsFirst() {
            this.nullOrder = OrderingExpression.NullOrder.FIRST;
            return this;
        }

        @Override
        public OrderingExpression<X> nullsLast() {
            this.nullOrder = OrderingExpression.NullOrder.LAST;
            return this;
        }

        @Override
        public Order getOrder() {
            return this.order;
        }

        @Override
        public OrderingExpression.NullOrder getNullOrder() {
            return this.nullOrder;
        }

        @Override
        public String getName() {
            return this.expression.getName();
        }

        @Override
        public Class<X> getClassType() {
            return this.expression.getClassType();
        }

        @Override
        public ExpressionType getExpressionType() {
            return ExpressionType.ORDERING;
        }

        @Override
        public Expression<X> getInnerExpression() {
            return this.expression;
        }
    }

    private static class ExpressionCondition<L, R>
    implements LogicalCondition<L, R> {
        private final Operator operator;
        private final L leftOperand;
        private final R rightOperand;

        ExpressionCondition(L leftOperand, Operator operator, R rightOperand) {
            this.leftOperand = leftOperand;
            this.operator = operator;
            this.rightOperand = rightOperand;
        }

        @Override
        public <V> LogicalCondition<LogicalCondition<L, R>, Condition<?, ?>> and(Condition<V, ?> condition) {
            return new ExpressionCondition(this, Operator.AND, condition);
        }

        @Override
        public <V> LogicalCondition<LogicalCondition<L, R>, Condition<?, ?>> or(Condition<V, ?> condition) {
            return new ExpressionCondition(this, Operator.OR, condition);
        }

        @Override
        public LogicalCondition<LogicalCondition<L, R>, Condition<?, ?>> not() {
            return new ExpressionCondition(this, Operator.NOT, new NullOperand());
        }

        @Override
        public Operator getOperator() {
            return this.operator;
        }

        @Override
        public R getRightOperand() {
            return this.rightOperand;
        }

        @Override
        public L getLeftOperand() {
            return this.leftOperand;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExpressionCondition) {
                ExpressionCondition other = (ExpressionCondition)obj;
                return Objects.equals(this.leftOperand, other.leftOperand) && Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.rightOperand, other.rightOperand);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.leftOperand, this.rightOperand, this.operator});
        }
    }
}

