/*
 * Decompiled with CFR 0.152.
 */
package io.requery.query;

import io.requery.query.Aliasable;
import io.requery.query.Expression;
import io.requery.query.Tuple;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MutableTuple
implements Tuple,
Serializable {
    private static final Map<Class<?>, Class<?>> boxedTypes = new HashMap();
    private final Map<String, Object> map;
    private final Object[] values;

    public MutableTuple(int size) {
        if (size <= 0) {
            throw new IllegalStateException();
        }
        this.map = new HashMap<String, Object>(size);
        this.values = new Object[size];
    }

    private String keyOf(Expression<?> expression) {
        String alias;
        String key = expression.getName();
        if (expression instanceof Aliasable && (alias = ((Aliasable)((Object)expression)).getAlias()) != null) {
            key = alias;
        }
        return key == null ? null : key.toLowerCase(Locale.ROOT);
    }

    public void set(int index, Expression<?> expression, Object value) {
        this.map.put(this.keyOf(expression), value);
        this.values[index] = value;
    }

    @Override
    public <V> V get(Expression<V> key) {
        Object value = this.map.get(this.keyOf(key));
        if (value == null) {
            return null;
        }
        Class<V> type2 = key.getClassType();
        if (type2.isPrimitive()) {
            Object result2 = boxedTypes.get(type2).cast(value);
            return (V)result2;
        }
        return type2.cast(value);
    }

    @Override
    public <V> V get(int index) {
        return (V)this.values[index];
    }

    @Override
    public <V> V get(String key) {
        return (V)this.map.get(key.toLowerCase(Locale.ROOT));
    }

    @Override
    public int count() {
        return this.values.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableTuple) {
            MutableTuple other = (MutableTuple)obj;
            return Arrays.equals(this.values, other.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        sb.append(" [ ");
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Object value;
            if (index > 0) {
                sb.append(", ");
            }
            sb.append((value = entry.getValue()) == null ? "null" : entry.getValue().toString());
            ++index;
        }
        sb.append(" ]");
        return sb.toString();
    }

    static {
        boxedTypes.put(Boolean.TYPE, Boolean.class);
        boxedTypes.put(Integer.TYPE, Integer.class);
        boxedTypes.put(Long.TYPE, Long.class);
        boxedTypes.put(Short.TYPE, Short.class);
        boxedTypes.put(Float.TYPE, Float.class);
        boxedTypes.put(Double.TYPE, Double.class);
        boxedTypes.put(Character.TYPE, Character.class);
        boxedTypes.put(Byte.TYPE, Byte.class);
    }
}

