/*
 * Decompiled with CFR 0.152.
 */
package io.requery.reactivex;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.requery.BlockingEntityStore;
import io.requery.meta.Attribute;
import io.requery.meta.QueryAttribute;
import io.requery.query.Deletion;
import io.requery.query.Expression;
import io.requery.query.InsertInto;
import io.requery.query.Insertion;
import io.requery.query.Result;
import io.requery.query.Return;
import io.requery.query.Scalar;
import io.requery.query.Selection;
import io.requery.query.Tuple;
import io.requery.query.Update;
import io.requery.query.element.QueryElement;
import io.requery.reactivex.ReactiveEntityStore;
import io.requery.reactivex.ReactiveResult;
import io.requery.reactivex.ReactiveScalar;
import io.requery.util.Objects;
import io.requery.util.function.Function;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class WrappedEntityStore<T>
extends ReactiveEntityStore<T> {
    private final BlockingEntityStore<T> delegate;

    WrappedEntityStore(BlockingEntityStore<T> delegate) {
        this.delegate = Objects.requireNotNull(delegate);
    }

    @Override
    public <E extends T> Single<E> insert(final E entity) {
        return Single.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return WrappedEntityStore.this.delegate.insert(entity);
            }
        });
    }

    @Override
    public <E extends T> Single<Iterable<E>> insert(final Iterable<E> entities) {
        return Single.fromCallable((Callable)new Callable<Iterable<E>>(){

            @Override
            public Iterable<E> call() throws Exception {
                return WrappedEntityStore.this.delegate.insert(entities);
            }
        });
    }

    @Override
    public <K, E extends T> Single<K> insert(final E entity, final Class<K> keyClass) {
        return Single.fromCallable((Callable)new Callable<K>(){

            @Override
            public K call() throws Exception {
                return WrappedEntityStore.this.delegate.insert(entity, keyClass);
            }
        });
    }

    @Override
    public <K, E extends T> Single<Iterable<K>> insert(final Iterable<E> entities, final Class<K> keyClass) {
        return Single.fromCallable((Callable)new Callable<Iterable<K>>(){

            @Override
            public Iterable<K> call() throws Exception {
                return WrappedEntityStore.this.delegate.insert(entities, keyClass);
            }
        });
    }

    @Override
    public <E extends T> Single<E> update(final E entity) {
        return Single.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return WrappedEntityStore.this.delegate.update(entity);
            }
        });
    }

    @Override
    public <E extends T> Single<E> update(final E entity, final Attribute<?, ?> ... attributes) {
        return Single.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return WrappedEntityStore.this.delegate.update(entity, attributes);
            }
        });
    }

    @Override
    public <E extends T> Single<Iterable<E>> update(final Iterable<E> entities) {
        return Single.fromCallable((Callable)new Callable<Iterable<E>>(){

            @Override
            public Iterable<E> call() throws Exception {
                return WrappedEntityStore.this.delegate.update(entities);
            }
        });
    }

    @Override
    public <E extends T> Single<E> upsert(final E entity) {
        return Single.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return WrappedEntityStore.this.delegate.upsert(entity);
            }
        });
    }

    @Override
    public <E extends T> Single<Iterable<E>> upsert(final Iterable<E> entities) {
        return Single.fromCallable((Callable)new Callable<Iterable<E>>(){

            @Override
            public Iterable<E> call() throws Exception {
                return WrappedEntityStore.this.delegate.upsert(entities);
            }
        });
    }

    @Override
    public <E extends T> Single<E> refresh(final E entity) {
        return Single.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return WrappedEntityStore.this.delegate.refresh(entity);
            }
        });
    }

    @Override
    public <E extends T> Single<E> refresh(final E entity, final Attribute<?, ?> ... attributes) {
        return Single.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return WrappedEntityStore.this.delegate.refresh(entity, attributes);
            }
        });
    }

    @Override
    public <E extends T> Single<Iterable<E>> refresh(final Iterable<E> entities, final Attribute<?, ?> ... attributes) {
        return Single.fromCallable((Callable)new Callable<Iterable<E>>(){

            @Override
            public Iterable<E> call() throws Exception {
                return WrappedEntityStore.this.delegate.refresh(entities, attributes);
            }
        });
    }

    @Override
    public <E extends T> Single<E> refreshAll(final E entity) {
        return Single.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return WrappedEntityStore.this.delegate.refreshAll(entity);
            }
        });
    }

    @Override
    public <E extends T> Completable delete(final E entity) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WrappedEntityStore.this.delegate.delete(entity);
                return null;
            }
        });
    }

    @Override
    public <E extends T> Completable delete(final Iterable<E> entities) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WrappedEntityStore.this.delegate.delete(entities);
                return null;
            }
        });
    }

    @Override
    public <E extends T, K> Maybe<E> findByKey(final Class<E> type2, final K key) {
        return Maybe.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return WrappedEntityStore.this.delegate.findByKey(type2, key);
            }
        });
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Selection<ReactiveResult<Tuple>> select(Expression<?> ... attributes) {
        return WrappedEntityStore.result(this.delegate.select(attributes));
    }

    @Override
    public Selection<ReactiveResult<Tuple>> select(Set<? extends Expression<?>> expressions) {
        return WrappedEntityStore.result(this.delegate.select(expressions));
    }

    @Override
    public Update<ReactiveScalar<Integer>> update() {
        return WrappedEntityStore.scalar(this.delegate.update());
    }

    @Override
    public Deletion<ReactiveScalar<Integer>> delete() {
        return WrappedEntityStore.scalar(this.delegate.delete());
    }

    @Override
    public <E extends T> Selection<ReactiveResult<E>> select(Class<E> type2, QueryAttribute<?, ?> ... attributes) {
        return WrappedEntityStore.result(this.delegate.select(type2, attributes));
    }

    @Override
    public <E extends T> Selection<ReactiveResult<E>> select(Class<E> type2, Set<? extends QueryAttribute<E, ?>> attributes) {
        return WrappedEntityStore.result(this.delegate.select(type2, attributes));
    }

    @Override
    public <E extends T> Insertion<ReactiveResult<Tuple>> insert(Class<E> type2) {
        return WrappedEntityStore.result(this.delegate.insert(type2));
    }

    @Override
    public <E extends T> InsertInto<ReactiveResult<Tuple>> insert(Class<E> type2, QueryAttribute<?, ?> ... attributes) {
        return WrappedEntityStore.result(this.delegate.insert(type2, attributes));
    }

    @Override
    public <E extends T> Update<ReactiveScalar<Integer>> update(Class<E> type2) {
        return WrappedEntityStore.scalar(this.delegate.update(type2));
    }

    @Override
    public <E extends T> Deletion<ReactiveScalar<Integer>> delete(Class<E> type2) {
        return WrappedEntityStore.scalar(this.delegate.delete(type2));
    }

    @Override
    public <E extends T> Selection<ReactiveScalar<Integer>> count(Class<E> type2) {
        return WrappedEntityStore.scalar(this.delegate.count(type2));
    }

    @Override
    public Selection<ReactiveScalar<Integer>> count(QueryAttribute<?, ?> ... attributes) {
        return WrappedEntityStore.scalar(this.delegate.count(attributes));
    }

    @Override
    public ReactiveResult<Tuple> raw(String query, Object ... parameters2) {
        return new ReactiveResult<Tuple>(this.delegate.raw(query, parameters2));
    }

    @Override
    public <E extends T> ReactiveResult<E> raw(Class<E> type2, String query, Object ... parameters2) {
        return new ReactiveResult<E>(this.delegate.raw(type2, query, parameters2));
    }

    @Override
    public BlockingEntityStore<T> toBlocking() {
        return this.delegate;
    }

    @Override
    @CheckReturnValue
    public <R> Single<R> runInTransaction(final Function<BlockingEntityStore<T>, R> function2) {
        return Single.fromCallable((Callable)new Callable<R>(){

            @Override
            public R call() throws Exception {
                return function2.apply(WrappedEntityStore.this.toBlocking());
            }
        });
    }

    private static <E> QueryElement<ReactiveResult<E>> result(Return<? extends Result<E>> query) {
        QueryElement element = (QueryElement)query;
        return element.extend(new Function<Result<E>, ReactiveResult<E>>(){

            @Override
            public ReactiveResult<E> apply(Result<E> result2) {
                return new ReactiveResult(result2);
            }
        });
    }

    private static <E> QueryElement<ReactiveScalar<E>> scalar(Return<? extends Scalar<E>> query) {
        QueryElement element = (QueryElement)query;
        return element.extend(new Function<Scalar<E>, ReactiveScalar<E>>(){

            @Override
            public ReactiveScalar<E> apply(Scalar<E> result2) {
                return new ReactiveScalar(result2);
            }
        });
    }
}

