/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.PersistenceException;
import io.requery.query.element.QueryElement;
import io.requery.query.element.QueryOperation;
import io.requery.sql.GeneratedResultReader;
import io.requery.sql.ParameterBinder;
import io.requery.sql.PreparedQueryOperation;
import io.requery.sql.RuntimeConfiguration;
import io.requery.sql.StatementListener;
import io.requery.sql.gen.DefaultOutput;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class BatchUpdateOperation<E>
extends PreparedQueryOperation
implements QueryOperation<int[]> {
    private final E[] elements;
    private final int length;
    private final ParameterBinder<E> parameterBinder;
    private final boolean batchInStatement;

    BatchUpdateOperation(RuntimeConfiguration configuration, E[] elements, int length, ParameterBinder<E> parameterBinder, GeneratedResultReader generatedResultReader, boolean batchInStatement) {
        super(configuration, generatedResultReader);
        this.elements = elements;
        this.length = length;
        this.parameterBinder = parameterBinder;
        this.batchInStatement = batchInStatement;
    }

    @Override
    public int[] evaluate(QueryElement<int[]> query) {
        int[] result2 = this.batchInStatement ? null : new int[this.length];
        try (Connection connection = this.configuration.getConnection();){
            DefaultOutput generator = new DefaultOutput(this.configuration, query);
            String sql = generator.toSql();
            StatementListener listener = this.configuration.getStatementListener();
            try (PreparedStatement statement = this.prepare(sql, connection);){
                for (int i2 = 0; i2 < this.length; ++i2) {
                    E element = this.elements[i2];
                    this.parameterBinder.bindParameters(statement, element, null);
                    if (this.batchInStatement) {
                        statement.addBatch();
                        continue;
                    }
                    listener.beforeExecuteBatchUpdate(statement, sql);
                    result2[i2] = statement.executeUpdate();
                    listener.afterExecuteBatchUpdate(statement, result2);
                    this.readGeneratedKeys(i2, statement);
                }
                if (this.batchInStatement) {
                    listener.beforeExecuteBatchUpdate(statement, sql);
                    result2 = statement.executeBatch();
                    listener.afterExecuteBatchUpdate(statement, result2);
                    this.readGeneratedKeys(0, statement);
                }
            }
        }
        catch (BatchUpdateException e) {
            result2 = e.getUpdateCounts();
            if (result2 == null) {
                throw new PersistenceException(e);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        return result2;
    }
}

