/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.sql.BoundParameters;
import io.requery.sql.EntityStateListener;
import io.requery.sql.StatementListener;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

class LoggingListener<T>
implements EntityStateListener<T>,
StatementListener {
    private final Logger log;
    private final Level level;

    public LoggingListener() {
        this(Logger.getLogger("requery"), Level.INFO);
    }

    public LoggingListener(Logger log, Level level) {
        this.log = log;
        this.level = level;
    }

    @Override
    public void postLoad(T entity) {
        this.log.log(this.level, "postLoad {0}", entity);
    }

    @Override
    public void postInsert(T entity) {
        this.log.log(this.level, "postInsert {0}", entity);
    }

    @Override
    public void postDelete(T entity) {
        this.log.log(this.level, "postDelete {0}", entity);
    }

    @Override
    public void postUpdate(T entity) {
        this.log.log(this.level, "postUpdate {0}", entity);
    }

    @Override
    public void preInsert(T entity) {
        this.log.log(this.level, "preInsert {0}", entity);
    }

    @Override
    public void preDelete(T entity) {
        this.log.log(this.level, "preDelete {0}", entity);
    }

    @Override
    public void preUpdate(T entity) {
        this.log.log(this.level, "preUpdate {0}", entity);
    }

    @Override
    public void beforeExecuteUpdate(Statement statement, String sql, BoundParameters parameters2) {
        if (parameters2 != null && !parameters2.isEmpty()) {
            this.log.log(this.level, "beforeExecuteUpdate {0} sql:\n{1} \n({2})", new Object[]{statement, sql, parameters2});
        } else {
            this.log.log(this.level, "beforeExecuteUpdate {0} sql:\n{1}", new Object[]{statement, sql});
        }
    }

    @Override
    public void afterExecuteUpdate(Statement statement, int count) {
        this.log.log(this.level, "afterExecuteUpdate {0}", new Object[]{count});
    }

    @Override
    public void beforeExecuteBatchUpdate(Statement statement, String sql) {
        this.log.log(this.level, "beforeExecuteUpdate {0} sql:\n{1})", new Object[]{statement, sql});
    }

    @Override
    public void afterExecuteBatchUpdate(Statement statement, int[] count) {
        this.log.log(this.level, "afterExecuteBatchUpdate");
    }

    @Override
    public void beforeExecuteQuery(Statement statement, String sql, BoundParameters parameters2) {
        if (parameters2 != null && !parameters2.isEmpty()) {
            this.log.log(this.level, "beforeExecuteQuery {0} sql:\n{1} \n({2})", new Object[]{statement, sql, parameters2});
        } else {
            this.log.log(this.level, "beforeExecuteQuery {0} sql:\n{1}", new Object[]{statement, sql});
        }
    }

    @Override
    public void afterExecuteQuery(Statement statement) {
        this.log.log(this.level, "afterExecuteQuery");
    }
}

