/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.sql.PreparedStatementDelegate;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

class PreparedStatementCache
implements AutoCloseable {
    private final LinkedHashMap<String, PreparedStatement> elements;
    private boolean closed;

    PreparedStatementCache(final int count) {
        this.elements = new LinkedHashMap<String, PreparedStatement>(count, 0.75f, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                LinkedHashMap linkedHashMap = PreparedStatementCache.this.elements;
                synchronized (linkedHashMap) {
                    if (PreparedStatementCache.this.elements.size() > count) {
                        PreparedStatement statement = (PreparedStatement)eldest.getValue();
                        PreparedStatementCache.this.closeStatement(statement);
                        return true;
                    }
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement get(String sql) throws SQLException {
        LinkedHashMap<String, PreparedStatement> linkedHashMap = this.elements;
        synchronized (linkedHashMap) {
            if (this.closed) {
                return null;
            }
            PreparedStatement statement = (PreparedStatement)this.elements.remove(sql);
            if (statement != null && statement.isClosed()) {
                return null;
            }
            return statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement put(String sql, PreparedStatement statement) {
        if (!(statement instanceof CachedStatement)) {
            statement = new CachedStatement(this, sql, statement);
        }
        LinkedHashMap<String, PreparedStatement> linkedHashMap = this.elements;
        synchronized (linkedHashMap) {
            if (this.closed) {
                return null;
            }
            this.elements.put(sql, statement);
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LinkedHashMap<String, PreparedStatement> linkedHashMap = this.elements;
        synchronized (linkedHashMap) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (PreparedStatement statement : this.elements.values()) {
                this.closeStatement(statement);
            }
            this.elements.clear();
        }
    }

    private void closeStatement(PreparedStatement statement) {
        try {
            if (!statement.isClosed() && statement instanceof CachedStatement) {
                CachedStatement delegate = (CachedStatement)statement;
                delegate.closeDelegate();
            }
        }
        catch (SQLException ignored) {
            ignored.printStackTrace();
        }
    }

    private static class CachedStatement
    extends PreparedStatementDelegate {
        private final String sql;
        private final PreparedStatementCache cache;
        private final PreparedStatement statement;

        CachedStatement(PreparedStatementCache cache2, String sql, PreparedStatement statement) {
            super(statement);
            this.cache = cache2;
            this.sql = sql;
            this.statement = statement;
        }

        void closeDelegate() throws SQLException {
            this.statement.close();
        }

        @Override
        public void close() throws SQLException {
            this.cache.put(this.sql, this);
        }
    }
}

