/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.query.BaseResult;
import io.requery.query.Expression;
import io.requery.query.MutableTuple;
import io.requery.query.NamedExpression;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.element.QueryType;
import io.requery.sql.BoundParameters;
import io.requery.sql.CollectionResult;
import io.requery.sql.Mapping;
import io.requery.sql.ParameterInliner;
import io.requery.sql.PreparedQueryOperation;
import io.requery.sql.ResultReader;
import io.requery.sql.ResultSetIterator;
import io.requery.sql.RuntimeConfiguration;
import io.requery.sql.StatementExecutionException;
import io.requery.sql.StatementListener;
import io.requery.util.CloseableIterator;
import io.requery.util.function.Supplier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;

class RawTupleQuery
extends PreparedQueryOperation
implements Supplier<Result<Tuple>> {
    private final BoundParameters boundParameters;
    private final String sql;
    private final QueryType queryType;

    RawTupleQuery(RuntimeConfiguration configuration, String sql, Object[] parameters2) {
        super(configuration, null);
        ParameterInliner inlined2 = new ParameterInliner(sql, parameters2).apply();
        this.sql = inlined2.sql();
        this.queryType = RawTupleQuery.queryTypeOf(sql);
        this.boundParameters = new BoundParameters(inlined2.parameters());
    }

    private static QueryType queryTypeOf(String sql) {
        int end = sql.indexOf(" ");
        if (end < 0) {
            throw new IllegalArgumentException("Invalid query " + sql);
        }
        String keyword = sql.substring(0, end).trim().toUpperCase(Locale.ROOT);
        try {
            return QueryType.valueOf(keyword);
        }
        catch (IllegalArgumentException e) {
            return QueryType.SELECT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<Tuple> get() {
        PreparedStatement statement = null;
        try {
            Connection connection = this.configuration.getConnection();
            statement = this.prepare(this.sql, connection);
            this.mapParameters(statement, this.boundParameters);
            switch (this.queryType) {
                default: {
                    return new TupleResult(statement);
                }
                case INSERT: 
                case UPDATE: 
                case UPSERT: 
                case DELETE: 
                case TRUNCATE: 
                case MERGE: 
            }
            StatementListener listener = this.configuration.getStatementListener();
            listener.beforeExecuteUpdate(statement, this.sql, this.boundParameters);
            int count = statement.executeUpdate();
            listener.afterExecuteUpdate(statement, count);
            MutableTuple tuple = new MutableTuple(1);
            tuple.set(0, NamedExpression.ofInteger("count"), count);
            try {
                statement.close();
            }
            finally {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            return new CollectionResult<Tuple>(tuple);
        }
        catch (Exception e) {
            throw StatementExecutionException.closing(statement, e, this.sql);
        }
    }

    private class TupleResult
    extends BaseResult<Tuple>
    implements ResultReader<Tuple> {
        private final PreparedStatement statement;
        private Expression[] expressions;

        private TupleResult(PreparedStatement statement) {
            this.statement = statement;
        }

        @Override
        public Tuple read(ResultSet results, Set<? extends Expression<?>> selection) throws SQLException {
            Mapping mapping = RawTupleQuery.this.configuration.getMapping();
            MutableTuple tuple = new MutableTuple(this.expressions.length);
            for (int i2 = 0; i2 < tuple.count(); ++i2) {
                Object value = mapping.read(this.expressions[i2], results, i2 + 1);
                tuple.set(i2, this.expressions[i2], value);
            }
            return tuple;
        }

        @Override
        public CloseableIterator<Tuple> createIterator(int skip, int take) {
            try {
                StatementListener listener = RawTupleQuery.this.configuration.getStatementListener();
                listener.beforeExecuteQuery(this.statement, RawTupleQuery.this.sql, RawTupleQuery.this.boundParameters);
                ResultSet results = this.statement.executeQuery();
                listener.afterExecuteQuery(this.statement);
                ResultSetMetaData metadata2 = results.getMetaData();
                int columns = metadata2.getColumnCount();
                this.expressions = new Expression[columns];
                Mapping mapping = RawTupleQuery.this.configuration.getMapping();
                ResultSetIterator<Tuple> iterator2 = new ResultSetIterator<Tuple>(this, results, null, true, true);
                if (iterator2.hasNext()) {
                    for (int i2 = 0; i2 < columns; ++i2) {
                        String name = metadata2.getColumnName(i2 + 1);
                        int sqlType = metadata2.getColumnType(i2 + 1);
                        if (sqlType == 2) {
                            sqlType = 4;
                        }
                        Set<Class<?>> types = mapping.typesOf(sqlType);
                        this.expressions[i2] = NamedExpression.of(name, types.iterator().next());
                    }
                }
                return iterator2;
            }
            catch (SQLException e) {
                throw StatementExecutionException.closing(this.statement, e, RawTupleQuery.this.sql);
            }
        }

        @Override
        public void close() {
            try {
                Connection connection;
                if (this.statement != null && (connection = this.statement.getConnection()) != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                super.close();
            }
        }
    }
}

