/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.query.Expression;
import io.requery.query.MutableTuple;
import io.requery.query.Tuple;
import io.requery.sql.Mapping;
import io.requery.sql.ResultReader;
import io.requery.sql.RuntimeConfiguration;
import io.requery.util.Objects;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

class TupleResultReader
implements ResultReader<Tuple> {
    private final RuntimeConfiguration configuration;

    TupleResultReader(RuntimeConfiguration configuration) {
        this.configuration = Objects.requireNotNull(configuration);
    }

    @Override
    public Tuple read(ResultSet results, Set<? extends Expression<?>> selection) throws SQLException {
        MutableTuple tuple = new MutableTuple(selection.size());
        int index = 1;
        Mapping mapping = this.configuration.getMapping();
        for (Expression<?> expression : selection) {
            Object value = mapping.read(expression, results, index);
            tuple.set(index - 1, expression, value);
            ++index;
        }
        return tuple;
    }
}

