/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.gen;

import io.requery.query.element.LimitedElement;
import io.requery.sql.Keyword;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.LimitGenerator;
import io.requery.sql.gen.Output;

public class OffsetFetchGenerator
extends LimitGenerator {
    @Override
    public void write(Output output, LimitedElement query) {
        QueryBuilder qb = output.builder();
        Integer limit = query.getLimit();
        if (limit != null && limit > 0) {
            Integer offset = query.getOffset();
            this.write(qb, limit, offset);
        }
    }

    protected void write(QueryBuilder qb, Integer limit, Integer offset) {
        if (offset != null) {
            qb.keyword(Keyword.OFFSET).value(offset).keyword(offset > 1 ? Keyword.ROWS : Keyword.ROW).keyword(Keyword.FETCH, Keyword.NEXT).value(limit).keyword(limit > 1 ? Keyword.ROWS : Keyword.ROW).keyword(Keyword.ONLY);
        } else if (limit != null) {
            qb.keyword(Keyword.FETCH, Keyword.FIRST).value(limit).keyword(limit > 1 ? Keyword.ROWS : Keyword.ROW).keyword(Keyword.ONLY);
        }
    }
}

