/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.platform;

import io.requery.query.function.Function;
import io.requery.query.function.Now;
import io.requery.sql.BaseType;
import io.requery.sql.Keyword;
import io.requery.sql.Mapping;
import io.requery.sql.platform.Generic;
import io.requery.sql.type.VarCharType;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Derby
extends Generic {
    @Override
    public void addMappings(Mapping mapping) {
        super.addMappings(mapping);
        mapping.replaceType(-3, new CharBitData(-3));
        mapping.replaceType(-2, new CharBitData(-2));
        mapping.replaceType(-9, new VarCharType());
        mapping.aliasFunction(new Function.Name("current_date", true), Now.class);
    }

    @Override
    public boolean supportsIfExists() {
        return false;
    }

    @Override
    public boolean supportsGeneratedColumnsInPrepareStatement() {
        return false;
    }

    @Override
    public boolean supportsUpsert() {
        return true;
    }

    @Override
    public boolean supportsOnUpdateCascade() {
        return false;
    }

    private static class CharBitData
    extends BaseType<byte[]> {
        CharBitData(int jdbcType) {
            super(byte[].class, jdbcType);
        }

        @Override
        public boolean hasLength() {
            return true;
        }

        @Override
        public Integer getDefaultLength() {
            return 32;
        }

        @Override
        public Object getIdentifier() {
            switch (this.getSqlType()) {
                case -2: {
                    return "char";
                }
                case -3: {
                    return Keyword.VARCHAR;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getIdentifierSuffix() {
            return "for bit data";
        }

        @Override
        public byte[] read(ResultSet results, int column) throws SQLException {
            byte[] value = results.getBytes(column);
            return results.wasNull() ? null : value;
        }
    }
}

