/*
 * Decompiled with CFR 0.152.
 */
package io.requery.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class CompositeIterator<E>
implements Iterator<E> {
    private final Queue<Iterator<E>> queue = new LinkedList<Iterator<E>>();
    private Iterator<E> current;

    @SafeVarargs
    public CompositeIterator(Iterator<E> ... iterators) {
        this.queue.addAll(Arrays.asList(iterators));
        if (!this.queue.isEmpty()) {
            this.current = this.queue.poll();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            return false;
        }
        boolean hasNext = this.current.hasNext();
        while (!hasNext) {
            if (this.queue.isEmpty()) {
                return false;
            }
            this.current = this.queue.poll();
            hasNext = this.current.hasNext();
            if (!hasNext) continue;
            return true;
        }
        return true;
    }

    @Override
    public E next() {
        if (this.current != null) {
            if (this.current.hasNext()) {
                return this.current.next();
            }
            while (!this.queue.isEmpty()) {
                this.current = this.queue.poll();
                if (!this.current.hasNext()) continue;
                return this.current.next();
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.current.remove();
    }
}

