/*
 * Decompiled with CFR 0.152.
 */
package io.requery.util;

import io.requery.util.Objects;
import io.requery.util.function.Predicate;
import java.util.Iterator;

public class FilteringIterator<E>
implements Iterator<E> {
    private final Predicate<? super E> filter;
    private final Iterator<E> iterator;
    private E pending;
    private boolean hasNext;

    public FilteringIterator(Iterator<E> iterator2, Predicate<? super E> filter) {
        this.iterator = Objects.requireNotNull(iterator2);
        this.filter = Objects.requireNotNull(filter);
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            return true;
        }
        while (this.iterator.hasNext()) {
            E element = this.iterator.next();
            if (!this.filter.test(element)) continue;
            this.pending = element;
            this.hasNext = true;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        if (this.hasNext) {
            E element = this.pending;
            this.pending = null;
            this.hasNext = false;
            return element;
        }
        E element = this.iterator.next();
        if (this.filter.test(element)) {
            return element;
        }
        return this.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

