/*
 * Decompiled with CFR 0.152.
 */
package io.requery.util;

import io.requery.util.CollectionObserver;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ObservableCollectionIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final CollectionObserver<T> observer;
    private T lastObject;

    public ObservableCollectionIterator(@Nonnull Collection<T> collection, @Nullable CollectionObserver<T> observer) {
        this.iterator = collection.iterator();
        this.observer = observer;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        this.lastObject = this.iterator.next();
        return this.lastObject;
    }

    @Override
    public void remove() {
        this.iterator.remove();
        if (this.observer != null && this.lastObject != null) {
            this.observer.elementRemoved(this.lastObject);
        }
    }
}

