/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Comparator;
import java8.util.TimSort;
import java8.util.concurrent.CountedCompleter;

final class ArraysParallelSortHelpers {
    ArraysParallelSortHelpers() {
    }

    static final class FJObject {
        FJObject() {
        }

        static final class Merger<T>
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final T[] a;
            final T[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;
            Comparator<? super T> comparator;

            Merger(CountedCompleter<?> par, T[] a, T[] w, int lbase, int lsize, int rbase, int rsize, int wbase, int gran, Comparator<? super T> comparator) {
                super(par);
                this.a = a;
                this.w = w;
                this.lbase = lbase;
                this.lsize = lsize;
                this.rbase = rbase;
                this.rsize = rsize;
                this.wbase = wbase;
                this.gran = gran;
                this.comparator = comparator;
            }

            @Override
            public final void compute() {
                Comparator<T> c = this.comparator;
                T[] a = this.a;
                T[] w = this.w;
                int lb = this.lbase;
                int ln = this.lsize;
                int rb = this.rbase;
                int rn = this.rsize;
                int k = this.wbase;
                int g = this.gran;
                if (a == null || w == null || lb < 0 || rb < 0 || k < 0 || c == null) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int lo;
                    T split;
                    int lh;
                    int rh;
                    if (ln >= rn) {
                        if (ln <= g) break;
                        rh = rn;
                        lh = ln >>> 1;
                        split = a[lh + lb];
                        lo = 0;
                        while (lo < rh) {
                            int rm = lo + rh >>> 1;
                            if (c.compare(split, a[rm + rb]) <= 0) {
                                rh = rm;
                                continue;
                            }
                            lo = rm + 1;
                        }
                    } else {
                        if (rn <= g) break;
                        lh = ln;
                        rh = rn >>> 1;
                        split = a[rh + rb];
                        lo = 0;
                        while (lo < lh) {
                            int lm = lo + lh >>> 1;
                            if (c.compare(split, a[lm + lb]) <= 0) {
                                lh = lm;
                                continue;
                            }
                            lo = lm + 1;
                        }
                    }
                    Merger<T> m = new Merger<T>(this, a, w, lb + lh, ln - lh, rb + rh, rn - rh, k + lh + rh, g, c);
                    rn = rh;
                    ln = lh;
                    this.addToPendingCount(1);
                    m.fork();
                }
                int lf = lb + ln;
                int rf = rb + rn;
                while (lb < lf && rb < rf) {
                    T t;
                    T al = a[lb];
                    T ar = a[rb];
                    if (c.compare(al, ar) <= 0) {
                        ++lb;
                        t = al;
                    } else {
                        ++rb;
                        t = ar;
                    }
                    w[k++] = t;
                }
                if (rb < rf) {
                    System.arraycopy(a, rb, w, k, rf - rb);
                } else if (lb < lf) {
                    System.arraycopy(a, lb, w, k, lf - lb);
                }
                this.tryComplete();
            }
        }

        static final class Sorter<T>
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final T[] a;
            final T[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;
            Comparator<? super T> comparator;

            Sorter(CountedCompleter<?> par, T[] a, T[] w, int base, int size, int wbase, int gran, Comparator<? super T> comparator) {
                super(par);
                this.a = a;
                this.w = w;
                this.base = base;
                this.size = size;
                this.wbase = wbase;
                this.gran = gran;
                this.comparator = comparator;
            }

            @Override
            public final void compute() {
                CountedCompleter s = this;
                Comparator<? super T> c = this.comparator;
                T[] a = this.a;
                T[] w = this.w;
                int b = this.base;
                int n = this.size;
                int wb = this.wbase;
                int g = this.gran;
                while (n > g) {
                    int h = n >>> 1;
                    int q = h >>> 1;
                    int u = h + q;
                    Relay fc = new Relay(new Merger<T>(s, w, a, wb, h, wb + h, n - h, b, g, c));
                    Relay rc = new Relay(new Merger<T>(fc, a, w, b + h, q, b + u, n - u, wb + h, g, c));
                    new Sorter<T>(rc, a, w, b + u, n - u, wb + u, g, c).fork();
                    new Sorter<T>(rc, a, w, b + h, q, wb + h, g, c).fork();
                    Relay bc = new Relay(new Merger<T>(fc, a, w, b, q, b + q, h - q, wb, g, c));
                    new Sorter<T>(bc, a, w, b + q, h - q, wb + q, g, c).fork();
                    s = new EmptyCompleter(bc);
                    n = q;
                }
                TimSort.sort(a, b, b + n, c, w, wb, n);
                s.tryComplete();
            }
        }
    }

    static final class Relay
    extends CountedCompleter<Void> {
        static final long serialVersionUID = 2446542900576103244L;
        final CountedCompleter<?> task;

        Relay(CountedCompleter<?> task) {
            super(null, 1);
            this.task = task;
        }

        @Override
        public final void compute() {
        }

        @Override
        public final void onCompletion(CountedCompleter<?> t) {
            this.task.compute();
        }
    }

    static final class EmptyCompleter
    extends CountedCompleter<Void> {
        static final long serialVersionUID = 2446542900576103244L;

        EmptyCompleter(CountedCompleter<?> p) {
            super(p);
        }

        @Override
        public final void compute() {
        }
    }
}

