/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java.util.concurrent.atomic.AtomicReference;
import java8.util.Spliterator;
import java8.util.stream.AbstractTask;
import java8.util.stream.PipelineHelper;

abstract class AbstractShortCircuitTask<P_IN, P_OUT, R, K extends AbstractShortCircuitTask<P_IN, P_OUT, R, K>>
extends AbstractTask<P_IN, P_OUT, R, K> {
    protected final AtomicReference<R> sharedResult;
    protected volatile boolean canceled;

    protected AbstractShortCircuitTask(PipelineHelper<P_OUT> helper, Spliterator<P_IN> spliterator) {
        super(helper, spliterator);
        this.sharedResult = new AtomicReference<Object>(null);
    }

    protected AbstractShortCircuitTask(K parent, Spliterator<P_IN> spliterator) {
        super(parent, spliterator);
        this.sharedResult = ((AbstractShortCircuitTask)parent).sharedResult;
    }

    protected abstract R getEmptyResult();

    @Override
    public void compute() {
        R result2;
        Spliterator rs = this.spliterator;
        long sizeEstimate = rs.estimateSize();
        long sizeThreshold = this.getTargetSize(sizeEstimate);
        boolean forkRight = false;
        AbstractShortCircuitTask task = this;
        AtomicReference<R> sr = this.sharedResult;
        while ((result2 = sr.get()) == null) {
            AbstractShortCircuitTask taskToFork;
            Spliterator ls;
            if (task.taskCanceled()) {
                result2 = task.getEmptyResult();
                break;
            }
            if (sizeEstimate <= sizeThreshold || (ls = rs.trySplit()) == null) {
                result2 = task.doLeaf();
                break;
            }
            AbstractShortCircuitTask leftChild = (AbstractShortCircuitTask)task.makeChild(ls);
            task.leftChild = leftChild;
            AbstractShortCircuitTask rightChild = (AbstractShortCircuitTask)task.makeChild(rs);
            task.rightChild = rightChild;
            task.setPendingCount(1);
            if (forkRight) {
                forkRight = false;
                rs = ls;
                task = leftChild;
                taskToFork = rightChild;
            } else {
                forkRight = true;
                task = rightChild;
                taskToFork = leftChild;
            }
            taskToFork.fork();
            sizeEstimate = rs.estimateSize();
        }
        task.setLocalResult(result2);
        task.tryComplete();
    }

    protected void shortCircuit(R result2) {
        if (result2 != null) {
            this.sharedResult.compareAndSet(null, result2);
        }
    }

    @Override
    protected void setLocalResult(R localResult) {
        if (this.isRoot()) {
            if (localResult != null) {
                this.sharedResult.compareAndSet(null, localResult);
            }
        } else {
            super.setLocalResult(localResult);
        }
    }

    @Override
    public R getRawResult() {
        return this.getLocalResult();
    }

    @Override
    public R getLocalResult() {
        if (this.isRoot()) {
            R answer = this.sharedResult.get();
            return answer == null ? this.getEmptyResult() : answer;
        }
        return super.getLocalResult();
    }

    protected void cancel() {
        this.canceled = true;
    }

    protected boolean taskCanceled() {
        boolean cancel = this.canceled;
        if (!cancel) {
            for (AbstractShortCircuitTask parent = (AbstractShortCircuitTask)this.getParent(); !cancel && parent != null; parent = (AbstractShortCircuitTask)parent.getParent()) {
                cancel = parent.canceled;
            }
        }
        return cancel;
    }

    protected void cancelLaterNodes() {
        AbstractShortCircuitTask node = this;
        for (AbstractShortCircuitTask parent = (AbstractShortCircuitTask)this.getParent(); parent != null; parent = (AbstractShortCircuitTask)parent.getParent()) {
            if (parent.leftChild == node) {
                AbstractShortCircuitTask rightSibling = (AbstractShortCircuitTask)parent.rightChild;
                if (!rightSibling.canceled) {
                    rightSibling.cancel();
                }
            }
            node = parent;
        }
    }
}

