/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.J8Arrays;
import java8.util.Objects;
import java8.util.Spliterators;
import java8.util.function.Consumer;
import java8.util.function.Predicate;
import java8.util.function.Supplier;
import java8.util.function.UnaryOperator;
import java8.util.stream.Stream;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.StreamSupport;
import java8.util.stream.Streams;

public final class RefStreams {
    public static <T> Stream.Builder<T> builder() {
        return new Streams.StreamBuilderImpl();
    }

    public static <T> Stream<T> empty() {
        return StreamSupport.stream(Spliterators.emptySpliterator(), false);
    }

    public static <T> Stream<T> of(T t) {
        return StreamSupport.stream(new Streams.StreamBuilderImpl<T>(t), false);
    }

    public static <T> Stream<T> ofNullable(T t) {
        return t == null ? RefStreams.empty() : StreamSupport.stream(new Streams.StreamBuilderImpl<T>(t), false);
    }

    public static <T> Stream<T> of(T ... values2) {
        return J8Arrays.stream(values2);
    }

    public static <T, S extends T> Stream<T> iterate(final S seed, final UnaryOperator<S> f) {
        Objects.requireNonNull(f);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            S prev;
            boolean started;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object s;
                Objects.requireNonNull(action);
                if (this.started) {
                    s = f.apply(this.prev);
                } else {
                    s = seed;
                    this.started = true;
                }
                this.prev = s;
                action.accept(this.prev);
                return true;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public static <T, S extends T> Stream<T> iterate(final S seed, final Predicate<? super S> hasNext, final UnaryOperator<S> next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            S prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object s;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    s = next.apply(this.prev);
                } else {
                    s = seed;
                    this.started = true;
                }
                if (!hasNext.test(s)) {
                    this.prev = null;
                    this.finished = true;
                    return false;
                }
                this.prev = s;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                Object s = this.started ? next.apply(this.prev) : seed;
                this.prev = null;
                while (hasNext.test(s)) {
                    action.accept(s);
                    s = next.apply(s);
                }
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> generate(Supplier<? extends T> s) {
        Objects.requireNonNull(s);
        return StreamSupport.stream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfRef<T>(Long.MAX_VALUE, s), false);
    }

    public static <T> Stream<T> concat(Stream<? extends T> a, Stream<? extends T> b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfRef split = new Streams.ConcatSpliterator.OfRef(a.spliterator(), b.spliterator());
        Stream stream = StreamSupport.stream(split, a.isParallel() || b.isParallel());
        return (Stream)stream.onClose(Streams.composedClose(a, b));
    }

    private RefStreams() {
    }
}

