/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.KotlinTarget;
import kotlin.reflect.jvm.internal.impl.load.java.AnnotationQualifierApplicabilityType;
import kotlin.reflect.jvm.internal.impl.load.java.AnnotationQualifiersFqNamesKt;
import kotlin.reflect.jvm.internal.impl.load.java.AnnotationTypeQualifierResolver;
import kotlin.reflect.jvm.internal.impl.load.java.AnnotationTypeQualifierResolverKt;
import kotlin.reflect.jvm.internal.impl.load.java.JavaDefaultQualifiers;
import kotlin.reflect.jvm.internal.impl.load.java.JavaTypeEnhancementState;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.ReportLevel;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaAnnotationTargetMapper;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NullabilityQualifierWithMigrationStatus;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotationTypeQualifierResolver {
    @NotNull
    private final JavaTypeEnhancementState javaTypeEnhancementState;
    @NotNull
    private final MemoizedFunctionToNullable<ClassDescriptor, AnnotationDescriptor> resolvedNicknames;

    public AnnotationTypeQualifierResolver(@NotNull StorageManager storageManager, @NotNull JavaTypeEnhancementState javaTypeEnhancementState) {
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(javaTypeEnhancementState, "javaTypeEnhancementState");
        this.javaTypeEnhancementState = javaTypeEnhancementState;
        this.resolvedNicknames = storageManager.createMemoizedFunctionWithNullableValues((Function1)new Function1<ClassDescriptor, AnnotationDescriptor>((Object)this){

            @Nullable
            public final AnnotationDescriptor invoke(@NotNull ClassDescriptor p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return AnnotationTypeQualifierResolver.access$computeTypeQualifierNickname((AnnotationTypeQualifierResolver)this.receiver, p0);
            }

            @NotNull
            public final String getSignature() {
                return "computeTypeQualifierNickname(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;";
            }

            @NotNull
            public final String getName() {
                return "computeTypeQualifierNickname";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(AnnotationTypeQualifierResolver.class);
            }
        });
    }

    private final AnnotationDescriptor computeTypeQualifierNickname(ClassDescriptor classDescriptor) {
        AnnotationDescriptor annotationDescriptor;
        block2: {
            if (!classDescriptor.getAnnotations().hasAnnotation(AnnotationQualifiersFqNamesKt.getTYPE_QUALIFIER_NICKNAME_FQNAME())) {
                return null;
            }
            Iterable iterable = classDescriptor.getAnnotations();
            boolean bl = false;
            for (Object t : iterable) {
                AnnotationDescriptor p0 = (AnnotationDescriptor)t;
                boolean bl2 = false;
                AnnotationDescriptor annotationDescriptor2 = this.resolveTypeQualifierAnnotation(p0);
                if (annotationDescriptor2 == null) continue;
                annotationDescriptor = annotationDescriptor2;
                break block2;
            }
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    private final AnnotationDescriptor resolveTypeQualifierNickname(ClassDescriptor classDescriptor) {
        if (classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS) {
            return null;
        }
        return (AnnotationDescriptor)this.resolvedNicknames.invoke(classDescriptor);
    }

    @Nullable
    public final AnnotationDescriptor resolveTypeQualifierAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkNotNullParameter(annotationDescriptor, "annotationDescriptor");
        if (this.javaTypeEnhancementState.getJsr305().isDisabled()) {
            return null;
        }
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor annotationClass = classDescriptor;
        if (AnnotationTypeQualifierResolverKt.access$isAnnotatedWithTypeQualifier(annotationClass)) {
            return annotationDescriptor;
        }
        return this.resolveTypeQualifierNickname(annotationClass);
    }

    @Nullable
    public final JavaDefaultQualifiers resolveQualifierBuiltInDefaultAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        JavaDefaultQualifiers javaDefaultQualifiers;
        Intrinsics.checkNotNullParameter(annotationDescriptor, "annotationDescriptor");
        if (this.javaTypeEnhancementState.getDisabledDefaultAnnotations()) {
            return null;
        }
        Object object = AnnotationQualifiersFqNamesKt.getBUILT_IN_TYPE_QUALIFIER_DEFAULT_ANNOTATIONS();
        FqName fqName2 = annotationDescriptor.getFqName();
        boolean bl = false;
        JavaDefaultQualifiers javaDefaultQualifiers2 = object.get(fqName2);
        if (javaDefaultQualifiers2 == null) {
            javaDefaultQualifiers = null;
        } else {
            ReportLevel reportLevel;
            object = javaDefaultQualifiers2;
            boolean bl2 = false;
            bl = false;
            Object qualifierForDefaultingAnnotation = object;
            boolean bl3 = false;
            ReportLevel reportLevel2 = this.resolveDefaultAnnotationState(annotationDescriptor);
            boolean bl4 = false;
            boolean bl5 = false;
            ReportLevel it = reportLevel2;
            boolean bl6 = false;
            ReportLevel reportLevel3 = reportLevel = it != ReportLevel.IGNORE ? reportLevel2 : null;
            if (reportLevel == null) {
                return null;
            }
            ReportLevel state = reportLevel;
            javaDefaultQualifiers = JavaDefaultQualifiers.copy$default((JavaDefaultQualifiers)qualifierForDefaultingAnnotation, NullabilityQualifierWithMigrationStatus.copy$default(((JavaDefaultQualifiers)qualifierForDefaultingAnnotation).getNullabilityQualifier(), null, state.isWarning(), 1, null), null, false, false, 14, null);
        }
        return javaDefaultQualifiers;
    }

    private final ReportLevel resolveDefaultAnnotationState(AnnotationDescriptor annotationDescriptor) {
        FqName annotationFqname = annotationDescriptor.getFqName();
        if (annotationFqname != null) {
            Map<FqName, JavaDefaultQualifiers> map = AnnotationQualifiersFqNamesKt.getJSPECIFY_DEFAULT_ANNOTATIONS();
            boolean bl = false;
            Map<FqName, JavaDefaultQualifiers> map2 = map;
            boolean bl2 = false;
            if (map2.containsKey(annotationFqname)) {
                return this.javaTypeEnhancementState.getGetReportLevelForAnnotation().invoke(annotationFqname);
            }
        }
        return this.resolveJsr305AnnotationState(annotationDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TypeQualifierWithApplicability resolveTypeQualifierDefaultAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        Object v3;
        int elementTypesMask;
        block8: {
            void $this$fold$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            ClassDescriptor classDescriptor;
            ClassDescriptor classDescriptor2;
            Intrinsics.checkNotNullParameter(annotationDescriptor, "annotationDescriptor");
            if (this.javaTypeEnhancementState.getJsr305().isDisabled()) {
                return null;
            }
            Object object = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
            if (object == null) {
                classDescriptor2 = null;
            } else {
                ClassDescriptor classDescriptor3 = object;
                boolean bl = false;
                boolean bl2 = false;
                ClassDescriptor it = classDescriptor3;
                boolean bl3 = false;
                classDescriptor2 = classDescriptor = it.getAnnotations().hasAnnotation(AnnotationQualifiersFqNamesKt.getTYPE_QUALIFIER_DEFAULT_FQNAME()) ? classDescriptor3 : null;
            }
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor typeQualifierDefaultAnnotatedClass = classDescriptor;
            ClassDescriptor classDescriptor4 = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
            Intrinsics.checkNotNull(classDescriptor4);
            AnnotationDescriptor annotationDescriptor2 = classDescriptor4.getAnnotations().findAnnotation(AnnotationQualifiersFqNamesKt.getTYPE_QUALIFIER_DEFAULT_FQNAME());
            Intrinsics.checkNotNull(annotationDescriptor2);
            object = annotationDescriptor2.getAllValueArguments();
            boolean $i$f$flatMap = false;
            void var6_7 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            void bl3 = $this$flatMapTo$iv$iv;
            boolean bl = false;
            Iterator iterator2 = bl3.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry $dstr$parameter$argument = element$iv$iv = iterator2.next();
                boolean bl4 = false;
                Map.Entry entry = $dstr$parameter$argument;
                boolean bl5 = false;
                Name parameter = (Name)entry.getKey();
                Map.Entry entry2 = $dstr$parameter$argument;
                boolean bl6 = false;
                ConstantValue argument = (ConstantValue)entry2.getValue();
                Iterable list$iv$iv = Intrinsics.areEqual(parameter, JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME) ? this.mapJavaConstantToQualifierApplicabilityTypes(argument) : CollectionsKt.emptyList();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            int initial$iv = 0;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void applicabilityType;
                AnnotationQualifierApplicabilityType annotationQualifierApplicabilityType = (AnnotationQualifierApplicabilityType)((Object)element$iv);
                int acc = accumulator$iv;
                boolean bl7 = false;
                accumulator$iv = acc | 1 << applicabilityType.ordinal();
            }
            elementTypesMask = accumulator$iv;
            Iterable $this$firstOrNull$iv = typeQualifierDefaultAnnotatedClass.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                boolean bl8 = false;
                if (!(this.resolveTypeQualifierAnnotation(it) != null)) continue;
                v3 = element$iv;
                break block8;
            }
            v3 = null;
        }
        AnnotationDescriptor annotationDescriptor3 = v3;
        if (annotationDescriptor3 == null) {
            return null;
        }
        AnnotationDescriptor typeQualifier = annotationDescriptor3;
        return new TypeQualifierWithApplicability(typeQualifier, elementTypesMask);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TypeQualifierWithApplicability resolveAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        void $this$fold$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(annotationDescriptor, "annotationDescriptor");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor annotatedClass = classDescriptor;
        Annotations annotations2 = annotatedClass.getAnnotations();
        Object object = JvmAnnotationNames.TARGET_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue(object, "TARGET_ANNOTATION");
        AnnotationDescriptor annotationDescriptor2 = annotations2.findAnnotation((FqName)object);
        if (annotationDescriptor2 == null) {
            return null;
        }
        AnnotationDescriptor target = annotationDescriptor2;
        object = target.getAllValueArguments();
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var10_14 = $this$flatMapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var10_14.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $dstr$_u24__u24$argument = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$_u24__u24$argument;
            boolean bl3 = false;
            ConstantValue argument = (ConstantValue)entry.getValue();
            Iterable list$iv$iv = this.mapKotlinConstantToQualifierApplicabilityTypes(argument);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void applicabilityType;
            AnnotationQualifierApplicabilityType annotationQualifierApplicabilityType = (AnnotationQualifierApplicabilityType)((Object)element$iv);
            int acc = accumulator$iv;
            boolean bl4 = false;
            accumulator$iv = acc | 1 << applicabilityType.ordinal();
        }
        int elementTypesMask = accumulator$iv;
        return new TypeQualifierWithApplicability(annotationDescriptor, elementTypesMask);
    }

    @NotNull
    public final ReportLevel resolveJsr305AnnotationState(@NotNull AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkNotNullParameter(annotationDescriptor, "annotationDescriptor");
        ReportLevel reportLevel = this.resolveJsr305CustomState(annotationDescriptor);
        if (reportLevel != null) {
            ReportLevel reportLevel2 = reportLevel;
            boolean bl = false;
            boolean bl2 = false;
            ReportLevel it = reportLevel2;
            boolean bl3 = false;
            return it;
        }
        return this.javaTypeEnhancementState.getJsr305().getGlobalLevel();
    }

    @Nullable
    public final ReportLevel resolveJsr305CustomState(@NotNull AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkNotNullParameter(annotationDescriptor, "annotationDescriptor");
        Object object = this.javaTypeEnhancementState.getJsr305().getUserDefinedLevelForSpecificAnnotation();
        FqName fqName2 = annotationDescriptor.getFqName();
        boolean bl = false;
        Object object2 = object.get(fqName2);
        if (object2 != null) {
            object = object2;
            boolean bl2 = false;
            bl = false;
            Object it = object;
            boolean bl3 = false;
            return it;
        }
        object2 = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
        return object2 == null ? null : this.migrationAnnotationStatus((ClassDescriptor)object2);
    }

    private final ReportLevel migrationAnnotationStatus(ClassDescriptor $this$migrationAnnotationStatus) {
        ReportLevel reportLevel;
        Object object;
        AnnotationDescriptor annotationDescriptor = $this$migrationAnnotationStatus.getAnnotations().findAnnotation(AnnotationQualifiersFqNamesKt.getMIGRATION_ANNOTATION_FQNAME());
        Object object2 = annotationDescriptor == null ? null : DescriptorUtilsKt.firstArgument(annotationDescriptor);
        Object object3 = object = object2 instanceof EnumValue ? (EnumValue)object2 : null;
        if (object == null) {
            return null;
        }
        EnumValue enumValue = object;
        object = this.javaTypeEnhancementState.getJsr305().getMigrationLevel();
        if (object != null) {
            object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            return it;
        }
        switch (enumValue.getEnumEntryName().asString()) {
            case "STRICT": {
                reportLevel = ReportLevel.STRICT;
                break;
            }
            case "WARN": {
                reportLevel = ReportLevel.WARN;
                break;
            }
            case "IGNORE": {
                reportLevel = ReportLevel.IGNORE;
                break;
            }
            default: {
                reportLevel = null;
            }
        }
        return reportLevel;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toKotlinTargetNames(String $this$toKotlinTargetNames) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = JavaAnnotationTargetMapper.INSTANCE.mapJavaTargetArgumentByName($this$toKotlinTargetNames);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinTarget kotlinTarget = (KotlinTarget)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.name();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnnotationQualifierApplicabilityType> mapConstantToQualifierApplicabilityTypes(ConstantValue<?> $this$mapConstantToQualifierApplicabilityTypes, Function2<? super EnumValue, ? super AnnotationQualifierApplicabilityType, Boolean> findPredicate) {
        List list;
        ConstantValue<?> constantValue = $this$mapConstantToQualifierApplicabilityTypes;
        if (constantValue instanceof ArrayValue) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)((ArrayValue)$this$mapConstantToQualifierApplicabilityTypes).getValue();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ConstantValue it = (ConstantValue)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.mapConstantToQualifierApplicabilityTypes(it, findPredicate);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (constantValue instanceof EnumValue) {
            AnnotationQualifierApplicabilityType annotationQualifierApplicabilityType;
            block6: {
                AnnotationQualifierApplicabilityType[] annotationQualifierApplicabilityTypeArray = AnnotationQualifierApplicabilityType.values();
                boolean bl = false;
                AnnotationQualifierApplicabilityType[] annotationQualifierApplicabilityTypeArray2 = annotationQualifierApplicabilityTypeArray;
                boolean bl2 = false;
                AnnotationQualifierApplicabilityType[] annotationQualifierApplicabilityTypeArray3 = annotationQualifierApplicabilityTypeArray2;
                int n = annotationQualifierApplicabilityTypeArray3.length;
                for (int j = 0; j < n; ++j) {
                    AnnotationQualifierApplicabilityType annotationQualifierApplicabilityType2;
                    AnnotationQualifierApplicabilityType it = annotationQualifierApplicabilityType2 = annotationQualifierApplicabilityTypeArray3[j];
                    boolean bl3 = false;
                    if (!findPredicate.invoke((EnumValue)$this$mapConstantToQualifierApplicabilityTypes, it).booleanValue()) continue;
                    annotationQualifierApplicabilityType = annotationQualifierApplicabilityType2;
                    break block6;
                }
                annotationQualifierApplicabilityType = null;
            }
            list = CollectionsKt.listOfNotNull(annotationQualifierApplicabilityType);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<AnnotationQualifierApplicabilityType> mapJavaConstantToQualifierApplicabilityTypes(ConstantValue<?> $this$mapJavaConstantToQualifierApplicabilityTypes) {
        return this.mapConstantToQualifierApplicabilityTypes($this$mapJavaConstantToQualifierApplicabilityTypes, mapJavaConstantToQualifierApplicabilityTypes.1.INSTANCE);
    }

    private final List<AnnotationQualifierApplicabilityType> mapKotlinConstantToQualifierApplicabilityTypes(ConstantValue<?> $this$mapKotlinConstantToQualifierApplicabilityTypes) {
        return this.mapConstantToQualifierApplicabilityTypes($this$mapKotlinConstantToQualifierApplicabilityTypes, (Function2<? super EnumValue, ? super AnnotationQualifierApplicabilityType, Boolean>)new Function2<EnumValue, AnnotationQualifierApplicabilityType, Boolean>(this){
            final /* synthetic */ AnnotationTypeQualifierResolver this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull EnumValue $this$mapConstantToQualifierApplicabilityTypes, @NotNull AnnotationQualifierApplicabilityType it) {
                Intrinsics.checkNotNullParameter($this$mapConstantToQualifierApplicabilityTypes, "$this$mapConstantToQualifierApplicabilityTypes");
                Intrinsics.checkNotNullParameter((Object)((Object)it), "it");
                return AnnotationTypeQualifierResolver.access$toKotlinTargetNames(this.this$0, it.getJavaTarget()).contains($this$mapConstantToQualifierApplicabilityTypes.getEnumEntryName().getIdentifier());
            }
        });
    }

    public static final /* synthetic */ List access$toKotlinTargetNames(AnnotationTypeQualifierResolver $this, String $receiver) {
        return $this.toKotlinTargetNames($receiver);
    }

    public static final /* synthetic */ AnnotationDescriptor access$computeTypeQualifierNickname(AnnotationTypeQualifierResolver $this, ClassDescriptor classDescriptor) {
        return $this.computeTypeQualifierNickname(classDescriptor);
    }

    public static final class TypeQualifierWithApplicability {
        @NotNull
        private final AnnotationDescriptor typeQualifier;
        private final int applicability;

        public TypeQualifierWithApplicability(@NotNull AnnotationDescriptor typeQualifier, int applicability) {
            Intrinsics.checkNotNullParameter(typeQualifier, "typeQualifier");
            this.typeQualifier = typeQualifier;
            this.applicability = applicability;
        }

        @NotNull
        public final AnnotationDescriptor component1() {
            return this.typeQualifier;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<AnnotationQualifierApplicabilityType> component2() {
            void $this$filterTo$iv$iv;
            AnnotationQualifierApplicabilityType[] $this$filter$iv = AnnotationQualifierApplicabilityType.values();
            boolean $i$f$filter = false;
            AnnotationQualifierApplicabilityType[] annotationQualifierApplicabilityTypeArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var6_6 = $this$filterTo$iv$iv;
            int n = ((void)var6_6).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void p0 = element$iv$iv = var6_6[j];
                boolean bl = false;
                if (!this.isApplicableTo((AnnotationQualifierApplicabilityType)p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isApplicableTo(AnnotationQualifierApplicabilityType elementType) {
            if (this.isApplicableConsideringMask(elementType)) {
                return true;
            }
            return this.isApplicableConsideringMask(AnnotationQualifierApplicabilityType.TYPE_USE) && elementType != AnnotationQualifierApplicabilityType.TYPE_PARAMETER_BOUNDS;
        }

        private final boolean isApplicableConsideringMask(AnnotationQualifierApplicabilityType elementType) {
            return (this.applicability & 1 << elementType.ordinal()) != 0;
        }
    }
}

