/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.util.Fields;

public class FormContentProvider
extends StringContentProvider {
    public FormContentProvider(Fields fields2) {
        this(fields2, StandardCharsets.UTF_8);
    }

    public FormContentProvider(Fields fields2, Charset charset) {
        super("application/x-www-form-urlencoded", FormContentProvider.convert(fields2, charset), charset);
    }

    public static String convert(Fields fields2) {
        return FormContentProvider.convert(fields2, StandardCharsets.UTF_8);
    }

    public static String convert(Fields fields2, Charset charset) {
        StringBuilder builder = new StringBuilder(fields2.getSize() * 32);
        for (Fields.Field field : fields2) {
            for (String value : field.getValues()) {
                if (builder.length() > 0) {
                    builder.append("&");
                }
                builder.append(FormContentProvider.encode(field.getName(), charset)).append("=").append(FormContentProvider.encode(value, charset));
            }
        }
        return builder.toString();
    }

    private static String encode(String value, Charset charset) {
        try {
            return URLEncoder.encode(value, charset.name());
        }
        catch (UnsupportedEncodingException x) {
            throw new UnsupportedCharsetException(charset.name());
        }
    }
}

