/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import java.nio.charset.Charset;
import org.postgresql.core.OptimizedUTF8Encoder;

final class ByteOptimizedUTF8Encoder
extends OptimizedUTF8Encoder {
    private static final Charset ASCII_CHARSET = Charset.forName("ascii");

    ByteOptimizedUTF8Encoder() {
    }

    @Override
    public String decode(byte[] encodedString, int offset, int length) throws IOException {
        if (length <= 32) {
            return this.charDecode(encodedString, offset, length);
        }
        int j = offset + length;
        for (int i2 = offset; i2 < j; ++i2) {
            if (encodedString[i2] >= 0) continue;
            return this.slowDecode(encodedString, offset, length, i2);
        }
        return new String(encodedString, offset, length, ASCII_CHARSET);
    }

    private synchronized String slowDecode(byte[] encodedString, int offset, int length, int curIdx) throws IOException {
        char[] chars = this.getCharArray(length);
        int out = 0;
        for (int i2 = offset; i2 < curIdx; ++i2) {
            chars[out++] = (char)encodedString[i2];
        }
        return ByteOptimizedUTF8Encoder.decodeToChars(encodedString, curIdx, length - (curIdx - offset), chars, out);
    }
}

