/*
 * Decompiled with CFR 0.152.
 */
package io.requery.query.element;

import io.requery.meta.Attribute;
import io.requery.meta.EntityModel;
import io.requery.meta.Type;
import io.requery.query.Aliasable;
import io.requery.query.AliasedExpression;
import io.requery.query.Condition;
import io.requery.query.Deletion;
import io.requery.query.DistinctSelection;
import io.requery.query.Exists;
import io.requery.query.Expression;
import io.requery.query.ExpressionType;
import io.requery.query.HavingAndOr;
import io.requery.query.InsertInto;
import io.requery.query.Insertion;
import io.requery.query.JoinOn;
import io.requery.query.JoinWhereGroupByOrderBy;
import io.requery.query.Limit;
import io.requery.query.Offset;
import io.requery.query.Return;
import io.requery.query.Selectable;
import io.requery.query.Selection;
import io.requery.query.SetGroupByOrderByLimit;
import io.requery.query.SetHavingOrderByLimit;
import io.requery.query.Update;
import io.requery.query.WhereAndOr;
import io.requery.query.element.ExistsElement;
import io.requery.query.element.ExtendQueryOperation;
import io.requery.query.element.GroupByElement;
import io.requery.query.element.HavingConditionElement;
import io.requery.query.element.InsertType;
import io.requery.query.element.JoinOnElement;
import io.requery.query.element.JoinType;
import io.requery.query.element.LimitedElement;
import io.requery.query.element.LogicalOperator;
import io.requery.query.element.OrderByElement;
import io.requery.query.element.QueryOperation;
import io.requery.query.element.QueryType;
import io.requery.query.element.QueryWrapper;
import io.requery.query.element.SelectionElement;
import io.requery.query.element.SetOperationElement;
import io.requery.query.element.SetOperator;
import io.requery.query.element.WhereConditionElement;
import io.requery.query.element.WhereElement;
import io.requery.query.function.Function;
import io.requery.util.Objects;
import io.requery.util.function.Supplier;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class QueryElement<E>
implements Selectable<E>,
Selection<E>,
DistinctSelection<E>,
Insertion<E>,
InsertInto<E>,
Deletion<E>,
Update<E>,
JoinWhereGroupByOrderBy<E>,
SetGroupByOrderByLimit<E>,
SetHavingOrderByLimit<E>,
Offset<E>,
Aliasable<Return<E>>,
Expression<QueryElement>,
QueryWrapper<E>,
SelectionElement,
LimitedElement,
OrderByElement,
GroupByElement,
SetOperationElement,
WhereElement {
    private final QueryType queryType;
    private final EntityModel model;
    private QueryOperation<E> operator;
    private String aliasName;
    private boolean selectDistinct;
    private Set<WhereConditionElement<E>> where;
    private Set<JoinOnElement<E>> joins;
    private Set<Expression<?>> groupBy;
    private Set<HavingConditionElement<E>> having;
    private Set<Expression<?>> orderBy;
    private Map<Expression<?>, Object> updates;
    private Set<Expression<?>> from;
    private Set<? extends Expression<?>> selection;
    private QueryElement<E> parent;
    private ExistsElement<?> whereSubQuery;
    private QueryElement<E> setQuery;
    private QueryElement<?> subQuery;
    private SetOperator setOperator;
    private Integer limit;
    private Integer offset;
    private Set<Type<?>> types;
    private InsertType insertType;

    public QueryElement(QueryType queryType, EntityModel model, QueryOperation<E> operator) {
        this.queryType = Objects.requireNotNull(queryType);
        this.model = model;
        this.operator = operator;
        this.where = new LinkedHashSet<WhereConditionElement<E>>();
    }

    private QueryElement(QueryElement<E> parent) {
        this(parent.queryType, parent.model, parent.operator);
        this.parent = parent;
    }

    public QueryType queryType() {
        return this.queryType;
    }

    public InsertType insertType() {
        return this.insertType;
    }

    public QueryElement<?> subQuery() {
        return this.subQuery;
    }

    @Override
    public Set<? extends Expression<?>> getSelection() {
        return this.selection;
    }

    @Override
    public boolean isDistinct() {
        return this.selectDistinct;
    }

    public Map<Expression<?>, Object> updateValues() {
        return this.updates == null ? Collections.emptyMap() : this.updates;
    }

    @Override
    public Set<WhereConditionElement<?>> getWhereElements() {
        return this.where;
    }

    @Override
    public ExistsElement<?> getWhereExistsElement() {
        return this.whereSubQuery;
    }

    public Set<JoinOnElement<E>> joinElements() {
        return this.joins;
    }

    @Override
    public SetOperator getOperator() {
        return this.setOperator;
    }

    @Override
    public Set<Expression<?>> getOrderByExpressions() {
        return this.orderBy;
    }

    @Override
    public Set<Expression<?>> getGroupByExpressions() {
        return this.groupBy;
    }

    @Override
    public Set<HavingConditionElement<?>> getHavingElements() {
        return this.having;
    }

    public QueryElement<E> getInnerSetQuery() {
        return this.setQuery;
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public Integer getOffset() {
        return this.offset;
    }

    public Set<Type<?>> entityTypes() {
        return this.types;
    }

    public Set<Expression<?>> fromExpressions() {
        if (this.from == null) {
            Set<Object> expressions;
            this.types = new LinkedHashSet();
            switch (this.queryType) {
                case SELECT: {
                    expressions = this.getSelection();
                    break;
                }
                case INSERT: 
                case UPDATE: 
                case UPSERT: {
                    expressions = this.updates.keySet();
                    break;
                }
                default: {
                    expressions = Collections.emptySet();
                }
            }
            for (Expression expression : expressions) {
                if (expression instanceof AliasedExpression) {
                    expression = ((AliasedExpression)expression).getInnerExpression();
                }
                if (expression instanceof Attribute) {
                    Type type2 = ((Attribute)((Object)expression)).getDeclaringType();
                    this.types.add(type2);
                    continue;
                }
                if (!(expression instanceof Function)) continue;
                Function function2 = (Function)expression;
                for (Object arg : function2.arguments()) {
                    Type type3 = null;
                    if (arg instanceof Attribute) {
                        type3 = ((Attribute)arg).getDeclaringType();
                        this.types.add(type3);
                    } else if (arg instanceof Class) {
                        type3 = this.model.typeOf((Class)arg);
                    }
                    if (type3 == null) continue;
                    this.types.add(type3);
                }
            }
            if (this.from == null) {
                this.from = new LinkedHashSet();
            }
            if (!this.types.isEmpty()) {
                this.from.addAll(this.types);
            }
        }
        return this.from;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Class<QueryElement> getClassType() {
        return QueryElement.class;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.QUERY;
    }

    @Override
    public Expression<QueryElement> getInnerExpression() {
        return null;
    }

    @Override
    public Return<E> as(String alias) {
        this.aliasName = alias;
        return this;
    }

    @Override
    public String getAlias() {
        return this.aliasName;
    }

    @Override
    public QueryElement<E> select(Expression<?> ... selection) {
        this.selection = selection == null ? null : new LinkedHashSet(Arrays.asList(selection));
        return this;
    }

    @Override
    public QueryElement<E> select(Set<? extends Expression<?>> select) {
        this.selection = select;
        return this;
    }

    @Override
    public QueryElement<E> unwrapQuery() {
        return this;
    }

    @Override
    public DistinctSelection<E> distinct() {
        this.selectDistinct = true;
        return this;
    }

    @Override
    public QueryElement<E> from(Class<?> ... types) {
        this.types = new LinkedHashSet();
        for (Class<?> cls : types) {
            Type<?> type2 = this.model.typeOf(cls);
            this.types.add(type2);
        }
        if (this.from == null) {
            this.from = new LinkedHashSet();
        }
        this.from.addAll(this.types);
        return this;
    }

    @Override
    public QueryElement<E> from(Supplier<?> ... subqueries) {
        if (this.from == null) {
            this.from = new LinkedHashSet();
        }
        for (Supplier<?> supplier : subqueries) {
            if (!(supplier instanceof Expression)) {
                throw new UnsupportedOperationException();
            }
            this.from.add((Expression)((Object)supplier));
        }
        return this;
    }

    @Override
    public E get() {
        return this.operator.evaluate(this.parent == null ? this : this.parent);
    }

    public <F extends E> QueryElement<F> extend(io.requery.util.function.Function<E, F> transform) {
        this.operator = new ExtendQueryOperation<F, E>(transform, this.operator);
        return this;
    }

    @Override
    public SetHavingOrderByLimit<E> groupBy(Expression<?> ... expressions) {
        if (this.groupBy == null) {
            this.groupBy = new LinkedHashSet();
        }
        Collections.addAll(this.groupBy, expressions);
        return this;
    }

    @Override
    public <V> SetHavingOrderByLimit<E> groupBy(Expression<V> expression) {
        if (this.groupBy == null) {
            this.groupBy = new LinkedHashSet();
        }
        this.groupBy.add(expression);
        return this;
    }

    private void addJoinElement(JoinOnElement<E> element) {
        if (this.joins == null) {
            this.joins = new LinkedHashSet<JoinOnElement<E>>();
        }
        this.joins.add(element);
    }

    private <J> JoinOn<E> createJoin(Class<J> type2, JoinType joinType) {
        String table = this.model.typeOf(type2).getName();
        JoinOnElement join = new JoinOnElement(this, table, joinType);
        this.addJoinElement(join);
        return join;
    }

    private <J> JoinOn<E> createJoin(Return<J> query, JoinType joinType) {
        JoinOnElement join = new JoinOnElement(this, query, joinType);
        this.addJoinElement(join);
        return join;
    }

    @Override
    public <J> JoinOn<E> join(Class<J> type2) {
        return this.createJoin(type2, JoinType.INNER);
    }

    @Override
    public <J> JoinOn<E> leftJoin(Class<J> type2) {
        return this.createJoin(type2, JoinType.LEFT);
    }

    @Override
    public <J> JoinOn<E> rightJoin(Class<J> type2) {
        return this.createJoin(type2, JoinType.RIGHT);
    }

    @Override
    public <J> JoinOn<E> join(Return<J> query) {
        return this.createJoin(query, JoinType.INNER);
    }

    @Override
    public <J> JoinOn<E> leftJoin(Return<J> query) {
        return this.createJoin(query, JoinType.LEFT);
    }

    @Override
    public <J> JoinOn<E> rightJoin(Return<J> query) {
        return this.createJoin(query, JoinType.RIGHT);
    }

    @Override
    public <V> Limit<E> orderBy(Expression<V> expression) {
        if (this.orderBy == null) {
            this.orderBy = new LinkedHashSet();
        }
        this.orderBy.add(expression);
        return this;
    }

    @Override
    public Limit<E> orderBy(Expression<?> ... expressions) {
        if (this.orderBy == null) {
            this.orderBy = new LinkedHashSet();
        }
        this.orderBy.addAll(Arrays.asList(expressions));
        return this;
    }

    @Override
    public Exists<SetGroupByOrderByLimit<E>> where() {
        ExistsElement<SetGroupByOrderByLimit<E>> element = new ExistsElement<SetGroupByOrderByLimit<E>>(this);
        this.whereSubQuery = element;
        return element;
    }

    @Override
    public <V> WhereAndOr<E> where(Condition<V, ?> condition) {
        if (this.where == null) {
            this.where = new LinkedHashSet<WhereConditionElement<E>>();
        }
        LogicalOperator operator = this.where.size() > 0 ? LogicalOperator.AND : null;
        WhereConditionElement<E> element = new WhereConditionElement<E>(this, this.where, condition, operator);
        this.where.add(element);
        return element;
    }

    @Override
    public <V> HavingAndOr<E> having(Condition<V, ?> condition) {
        if (this.having == null) {
            this.having = new LinkedHashSet<HavingConditionElement<E>>();
        }
        HavingConditionElement<E> element = new HavingConditionElement<E>(this, this.having, condition, null);
        this.having.add(element);
        return element;
    }

    @Override
    public Offset<E> limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public Return<E> offset(int offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public <V> Update<E> set(Expression<V> expression, V value) {
        this.value(expression, value);
        return this;
    }

    @Override
    public <V> Insertion<E> value(Expression<V> expression, V value) {
        Objects.requireNotNull(expression);
        if (this.updates == null) {
            this.updates = new LinkedHashMap();
        }
        this.updates.put(expression, value);
        this.insertType = InsertType.VALUES;
        return this;
    }

    public InsertInto<E> insertColumns(Expression[] expressions) {
        if (this.updates == null) {
            this.updates = new LinkedHashMap();
        }
        for (Expression expression : expressions) {
            this.updates.put(expression, null);
        }
        this.insertType = InsertType.SELECT;
        return this;
    }

    @Override
    public QueryElement<E> query(Return<?> query) {
        this.subQuery = (QueryElement)query;
        this.insertType = InsertType.SELECT;
        return this;
    }

    @Override
    public Selectable<E> union() {
        this.setOperator = SetOperator.UNION;
        this.setQuery = new QueryElement<E>(this);
        return this.setQuery;
    }

    @Override
    public Selectable<E> unionAll() {
        this.setOperator = SetOperator.UNION_ALL;
        this.setQuery = new QueryElement<E>(this);
        return this.setQuery;
    }

    @Override
    public Selectable<E> intersect() {
        this.setOperator = SetOperator.INTERSECT;
        this.setQuery = new QueryElement<E>(this);
        return this.setQuery;
    }

    @Override
    public Selectable<E> except() {
        this.setOperator = SetOperator.EXCEPT;
        this.setQuery = new QueryElement<E>(this);
        return this.setQuery;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryElement) {
            QueryElement other = (QueryElement)obj;
            return this.queryType == other.queryType && this.selectDistinct == other.selectDistinct && Objects.equals(this.selection, other.selection) && Objects.equals(this.updates, other.updates) && Objects.equals(this.joins, other.joins) && Objects.equals(this.where, other.where) && Objects.equals(this.orderBy, other.orderBy) && Objects.equals(this.groupBy, other.groupBy) && Objects.equals(this.having, other.having) && Objects.equals(this.setQuery, other.setQuery) && Objects.equals((Object)this.setOperator, (Object)other.setOperator) && Objects.equals(this.limit, other.limit) && Objects.equals(this.offset, other.offset);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queryType, this.selectDistinct, this.selection, this.updates, this.joins, this.where, this.orderBy, this.groupBy, this.having, this.limit, this.offset});
    }
}

