/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.State;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FqNamesUtilKt {
    public static final boolean isSubpackageOf(@NotNull FqName $this$isSubpackageOf, @NotNull FqName packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isSubpackageOf, "<this>");
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        if (Intrinsics.areEqual($this$isSubpackageOf, packageName)) {
            bl = true;
        } else if (packageName.isRoot()) {
            bl = true;
        } else {
            String string = $this$isSubpackageOf.asString();
            Intrinsics.checkNotNullExpressionValue(string, "this.asString()");
            String string2 = string;
            string = packageName.asString();
            Intrinsics.checkNotNullExpressionValue(string, "packageName.asString()");
            bl = FqNamesUtilKt.isSubpackageOf(string2, string);
        }
        return bl;
    }

    public static final boolean isChildOf(@NotNull FqName $this$isChildOf, @NotNull FqName packageName) {
        Intrinsics.checkNotNullParameter($this$isChildOf, "<this>");
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return Intrinsics.areEqual(FqNamesUtilKt.parentOrNull($this$isChildOf), packageName);
    }

    private static final boolean isSubpackageOf(String subpackageNameStr, String packageNameStr) {
        return StringsKt.startsWith$default(subpackageNameStr, packageNameStr, false, 2, null) && subpackageNameStr.charAt(packageNameStr.length()) == '.';
    }

    @NotNull
    public static final FqName tail(@NotNull FqName $this$tail, @NotNull FqName prefix) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$tail, "<this>");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        if (!FqNamesUtilKt.isSubpackageOf($this$tail, prefix) || prefix.isRoot()) {
            fqName2 = $this$tail;
        } else if (Intrinsics.areEqual($this$tail, prefix)) {
            FqName fqName3 = FqName.ROOT;
            Intrinsics.checkNotNullExpressionValue(fqName3, "ROOT");
            fqName2 = fqName3;
        } else {
            String string = $this$tail.asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString()");
            int n = prefix.asString().length() + 1;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).substring(startIndex)");
            fqName2 = new FqName(string2);
        }
        return fqName2;
    }

    @Nullable
    public static final FqName parentOrNull(@NotNull FqName $this$parentOrNull) {
        Intrinsics.checkNotNullParameter($this$parentOrNull, "<this>");
        return $this$parentOrNull.isRoot() ? null : $this$parentOrNull.parent();
    }

    public static final boolean isValidJavaFqName(@Nullable String qualifiedName2) {
        if (qualifiedName2 == null) {
            return false;
        }
        State state = State.BEGINNING;
        String string = qualifiedName2;
        block4: for (int j = 0; j < string.length(); ++j) {
            char c = string.charAt(j);
            State state2 = state;
            int n = WhenMappings.$EnumSwitchMapping$0[state2.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    if (!Character.isJavaIdentifierPart(c)) {
                        return false;
                    }
                    state = State.MIDDLE;
                    continue block4;
                }
                case 3: {
                    if (c != '.') continue block4;
                    state = State.AFTER_DOT;
                    continue block4;
                }
            }
        }
        return state != State.AFTER_DOT;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <V> V findValueForMostSpecificFqname(@NotNull FqName $this$findValueForMostSpecificFqname, @NotNull Map<FqName, ? extends V> values2) {
        Map map;
        Map suitableItems;
        Object object;
        Map.Entry element$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$findValueForMostSpecificFqname, "<this>");
        Intrinsics.checkNotNullParameter(values2, "values");
        Map<FqName, ? extends V> $this$filter$iv = values2;
        boolean $i$f$filter = false;
        Map<FqName, ? extends V> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Map map3 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry $dstr$fqName$_u24__u242 = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$fqName$_u24__u242;
            boolean bl3 = false;
            FqName fqName2 = (FqName)entry.getKey();
            if (!(Intrinsics.areEqual($this$findValueForMostSpecificFqname, fqName2) || FqNamesUtilKt.isChildOf($this$findValueForMostSpecificFqname, fqName2))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map4 = destination$iv$iv;
        boolean bl4 = false;
        boolean bl5 = false;
        Map it = map4;
        boolean bl6 = false;
        map3 = it;
        bl = false;
        Object object2 = object = !map3.isEmpty() ? map4 : null;
        if (object == null) {
            return null;
        }
        map4 = suitableItems = object;
        bl4 = false;
        Iterable iterable = map4.entrySet();
        boolean bl7 = false;
        Iterator iterator3 = iterable.iterator();
        if (!iterator3.hasNext()) {
            map = null;
        } else {
            map3 = iterator3.next();
            if (!iterator3.hasNext()) {
                map = map3;
            } else {
                Map.Entry $dstr$fqName$_u24__u24 = (Map.Entry)((Object)map3);
                boolean bl8 = false;
                element$iv$iv = $dstr$fqName$_u24__u24;
                boolean $dstr$fqName$_u24__u242 = false;
                FqName fqName3 = (FqName)element$iv$iv.getKey();
                int n = FqNamesUtilKt.tail(fqName3, $this$findValueForMostSpecificFqname).asString().length();
                do {
                    Object t = iterator3.next();
                    Map.Entry $dstr$fqName$_u24__u243 = (Map.Entry)t;
                    $i$a$-minByOrNull-FqNamesUtilKt$findValueForMostSpecificFqname$1 = false;
                    Map.Entry entry = $dstr$fqName$_u24__u243;
                    boolean bl9 = false;
                    FqName fqName4 = (FqName)entry.getKey();
                    int n2 = FqNamesUtilKt.tail(fqName4, $this$findValueForMostSpecificFqname).asString().length();
                    if (n <= n2) continue;
                    map3 = t;
                    n = n2;
                } while (iterator3.hasNext());
                map = map3;
            }
        }
        object = (Map.Entry)((Object)map);
        return object == null ? null : (V)object.getValue();
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            nArray[State.BEGINNING.ordinal()] = 1;
            nArray[State.AFTER_DOT.ordinal()] = 2;
            nArray[State.MIDDLE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

